/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.AbstractMap;
import java.util.Map;
import java.util.NoSuchElementException;
import swim.collections.ArrayMap;
import swim.collections.HashTrieMap;

abstract class HashTrieMapIterator<K, V> {
    final Object[] nodes = new Object[8];
    final int[] stack = new int[32];
    int depth = 0;
    int stackPointer = 0;

    HashTrieMapIterator(HashTrieMap<K, V> tree) {
        this.setNode(tree);
        this.setSlotIndex(0);
        this.setLeafIndex(0);
        this.setTreeMap(tree.treeMap);
        this.setLeafMap(tree.leafMap);
    }

    final Object getNode() {
        return this.nodes[this.depth];
    }

    final void setNode(Object node) {
        this.nodes[this.depth] = node;
    }

    final int getSlotIndex() {
        return this.stack[this.stackPointer];
    }

    final void setSlotIndex(int index) {
        this.stack[this.stackPointer] = index;
    }

    final int getLeafIndex() {
        return this.stack[this.stackPointer + 1];
    }

    final void setLeafIndex(int index) {
        this.stack[this.stackPointer + 1] = index;
    }

    final int getTreeMap() {
        return this.stack[this.stackPointer + 2];
    }

    final void setTreeMap(int treeMap) {
        this.stack[this.stackPointer + 2] = treeMap;
    }

    final int getLeafMap() {
        return this.stack[this.stackPointer + 3];
    }

    final void setLeafMap(int leafMap) {
        this.stack[this.stackPointer + 3] = leafMap;
    }

    final int follow(int treeMap, int leafMap) {
        return leafMap & 1 | (treeMap & 1) << 1;
    }

    final void push(HashTrieMap<K, V> tree) {
        ++this.depth;
        this.setNode(tree);
        this.stackPointer += 4;
        this.setSlotIndex(0);
        this.setLeafIndex(0);
        this.setTreeMap(tree.treeMap);
        this.setLeafMap(tree.leafMap);
    }

    final void push(ArrayMap<K, V> knot) {
        ++this.depth;
        this.setNode(knot);
        this.stackPointer += 4;
        this.setSlotIndex(0);
    }

    final void pop() {
        this.setNode(null);
        --this.depth;
        this.setSlotIndex(0);
        this.setLeafIndex(0);
        this.setTreeMap(0);
        this.setLeafMap(0);
        this.stackPointer -= 4;
        this.setSlotIndex(this.getSlotIndex() + 1);
        this.setTreeMap(this.getTreeMap() >>> 1);
        this.setLeafMap(this.getLeafMap() >>> 1);
    }

    public boolean hasNext() {
        block6: while (true) {
            Object node;
            if ((node = this.getNode()) instanceof HashTrieMap) {
                int leafMap;
                HashTrieMap tree = (HashTrieMap)node;
                int treeMap = this.getTreeMap();
                if ((treeMap | (leafMap = this.getLeafMap())) != 0) {
                    switch (this.follow(treeMap, leafMap)) {
                        case 0: {
                            this.setTreeMap(treeMap >>> 1);
                            this.setLeafMap(leafMap >>> 1);
                            continue block6;
                        }
                        case 1: {
                            return true;
                        }
                        case 2: {
                            this.push(tree.treeAt(this.getSlotIndex()));
                            continue block6;
                        }
                        case 3: {
                            this.push(tree.knotAt(this.getSlotIndex()));
                            continue block6;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (this.depth > 0) {
                    this.pop();
                    continue;
                }
                return false;
            }
            if (!(node instanceof ArrayMap)) break;
            ArrayMap knot = (ArrayMap)node;
            if (this.getSlotIndex() < knot.size()) {
                return true;
            }
            this.pop();
        }
        throw new AssertionError();
    }

    protected Map.Entry<K, V> nextEntry() {
        block6: while (true) {
            Object node;
            if ((node = this.getNode()) instanceof HashTrieMap) {
                int leafMap;
                HashTrieMap tree = (HashTrieMap)node;
                int treeMap = this.getTreeMap();
                int slotMap = treeMap | (leafMap = this.getLeafMap());
                if (slotMap != 0) {
                    switch (this.follow(treeMap, leafMap)) {
                        case 0: {
                            this.setTreeMap(treeMap >>> 1);
                            this.setLeafMap(leafMap >>> 1);
                            continue block6;
                        }
                        case 1: {
                            int slotIndex = this.getSlotIndex();
                            int leafIndex = this.getLeafIndex();
                            Object key = tree.keyAt(slotIndex);
                            Object value = tree.valueAt(leafIndex);
                            this.setSlotIndex(slotIndex + 1);
                            this.setLeafIndex(leafIndex + 1);
                            this.setTreeMap(treeMap >>> 1);
                            this.setLeafMap(leafMap >>> 1);
                            return new AbstractMap.SimpleImmutableEntry(key, value);
                        }
                        case 2: {
                            this.push(tree.treeAt(this.getSlotIndex()));
                            continue block6;
                        }
                        case 3: {
                            this.push(tree.knotAt(this.getSlotIndex()));
                            continue block6;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (this.depth > 0) {
                    this.pop();
                    continue;
                }
                throw new NoSuchElementException();
            }
            if (!(node instanceof ArrayMap)) break;
            ArrayMap knot = (ArrayMap)node;
            int slotIndex = this.getSlotIndex();
            if (slotIndex < knot.size()) {
                Object key = knot.keyAt(slotIndex);
                Object value = knot.valueAt(slotIndex);
                this.setSlotIndex(slotIndex + 1);
                return new AbstractMap.SimpleImmutableEntry(key, value);
            }
            this.pop();
        }
        throw new AssertionError();
    }

    protected K nextKey() {
        block6: while (true) {
            Object node;
            if ((node = this.getNode()) instanceof HashTrieMap) {
                int leafMap;
                HashTrieMap tree = (HashTrieMap)node;
                int treeMap = this.getTreeMap();
                int slotMap = treeMap | (leafMap = this.getLeafMap());
                if (slotMap != 0) {
                    switch (this.follow(treeMap, leafMap)) {
                        case 0: {
                            this.setTreeMap(treeMap >>> 1);
                            this.setLeafMap(leafMap >>> 1);
                            continue block6;
                        }
                        case 1: {
                            int slotIndex = this.getSlotIndex();
                            Object key = tree.keyAt(slotIndex);
                            this.setSlotIndex(slotIndex + 1);
                            this.setLeafIndex(this.getLeafIndex() + 1);
                            this.setTreeMap(treeMap >>> 1);
                            this.setLeafMap(leafMap >>> 1);
                            return key;
                        }
                        case 2: {
                            this.push(tree.treeAt(this.getSlotIndex()));
                            continue block6;
                        }
                        case 3: {
                            this.push(tree.knotAt(this.getSlotIndex()));
                            continue block6;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (this.depth > 0) {
                    this.pop();
                    continue;
                }
                throw new NoSuchElementException();
            }
            if (!(node instanceof ArrayMap)) break;
            ArrayMap knot = (ArrayMap)node;
            int slotIndex = this.getSlotIndex();
            if (slotIndex < knot.size()) {
                Object key = knot.keyAt(slotIndex);
                this.setSlotIndex(slotIndex + 1);
                return key;
            }
            this.pop();
        }
        throw new AssertionError();
    }

    protected V nextValue() {
        block6: while (true) {
            Object node;
            if ((node = this.getNode()) instanceof HashTrieMap) {
                int leafMap;
                HashTrieMap tree = (HashTrieMap)node;
                int treeMap = this.getTreeMap();
                int slotMap = treeMap | (leafMap = this.getLeafMap());
                if (slotMap != 0) {
                    switch (this.follow(treeMap, leafMap)) {
                        case 0: {
                            this.setTreeMap(treeMap >>> 1);
                            this.setLeafMap(leafMap >>> 1);
                            continue block6;
                        }
                        case 1: {
                            int leafIndex = this.getLeafIndex();
                            Object value = tree.valueAt(leafIndex);
                            this.setSlotIndex(this.getSlotIndex() + 1);
                            this.setLeafIndex(leafIndex + 1);
                            this.setTreeMap(treeMap >>> 1);
                            this.setLeafMap(leafMap >>> 1);
                            return value;
                        }
                        case 2: {
                            this.push(tree.treeAt(this.getSlotIndex()));
                            continue block6;
                        }
                        case 3: {
                            this.push(tree.knotAt(this.getSlotIndex()));
                            continue block6;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (this.depth > 0) {
                    this.pop();
                    continue;
                }
                throw new NoSuchElementException();
            }
            if (!(node instanceof ArrayMap)) break;
            ArrayMap knot = (ArrayMap)node;
            int slotIndex = this.getSlotIndex();
            if (slotIndex < knot.size()) {
                Object value = knot.valueAt(slotIndex);
                this.setSlotIndex(slotIndex + 1);
                return value;
            }
            this.pop();
        }
        throw new AssertionError();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

