/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.ArraySet;
import swim.collections.HashTrieSetIterator;
import swim.util.Murmur3;

public final class HashTrieSet<T>
implements Set<T>,
Debug {
    final int treeMap;
    final int leafMap;
    final Object[] slots;
    static final int VOID = 0;
    static final int LEAF = 1;
    static final int TREE = 2;
    static final int KNOT = 3;
    private static HashTrieSet<Object> empty;

    HashTrieSet(int treeMap, int leafMap, Object[] slots) {
        this.treeMap = treeMap;
        this.leafMap = leafMap;
        this.slots = slots;
    }

    @Override
    public boolean isEmpty() {
        return this.slotMap() == 0;
    }

    @Override
    public int size() {
        int t = 0;
        int i = 0;
        int treeMap = this.treeMap;
        int leafMap = this.leafMap;
        while ((treeMap | leafMap) != 0) {
            switch (leafMap & 1 | (treeMap & 1) << 1) {
                case 0: {
                    break;
                }
                case 1: {
                    ++t;
                    ++i;
                    break;
                }
                case 2: {
                    t += this.treeAt(i).size();
                    ++i;
                    break;
                }
                case 3: {
                    t += this.knotAt(i).size();
                    ++i;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            treeMap >>>= 1;
            leafMap >>>= 1;
        }
        return t;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem != null) {
            return HashTrieSet.contains(this, elem, Murmur3.hash((Object)elem), 0);
        }
        return false;
    }

    static boolean contains(HashTrieSet<?> tree, Object elem, int elemHash, int shift) {
        block6: while (true) {
            int branch = tree.choose(elemHash, shift);
            switch (tree.follow(branch)) {
                case 0: {
                    return false;
                }
                case 1: {
                    return elem.equals(tree.getLeaf(branch));
                }
                case 2: {
                    tree = tree.getTree(branch);
                    shift += 5;
                    continue block6;
                }
                case 3: {
                    return tree.getKnot(branch).contains(elem);
                }
            }
            break;
        }
        throw new AssertionError();
    }

    @Override
    public boolean containsAll(Collection<?> elems) {
        for (Object elem : elems) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public T head() {
        return HashTrieSet.head(this);
    }

    static <T> T head(HashTrieSet<T> tree) {
        block6: while (true) {
            int treeMap = tree.treeMap;
            int leafMap = tree.leafMap;
            while ((treeMap | leafMap) != 0) {
                switch (leafMap & 1 | (treeMap & 1) << 1) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return tree.leafAt(0);
                    }
                    case 2: {
                        tree = tree.treeAt(0);
                        continue block6;
                    }
                    case 3: {
                        return tree.knotAt(0).head();
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                treeMap >>>= 1;
                leafMap >>>= 1;
            }
            break;
        }
        return null;
    }

    public T next(Object elem) {
        return this.next(elem, Murmur3.hash((Object)elem), 0);
    }

    @Override
    public boolean add(T elem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> elems) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object elem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> elems) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> elems) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public HashTrieSet<T> added(T elem) {
        return this.updated(elem, Murmur3.hash(elem), 0);
    }

    public HashTrieSet<T> added(Collection<? extends T> elems) {
        HashTrieSet<T> these = this;
        for (T elem : elems) {
            these = these.added(elem);
        }
        return these;
    }

    public HashTrieSet<T> merged(HashTrieSet<T> elems) {
        HashTrieSet<T> these = this;
        Iterator<T> iter = elems.iterator();
        while (iter.hasNext()) {
            these = these.added(iter.next());
        }
        return these;
    }

    public HashTrieSet<T> removed(T elem) {
        if (elem != null) {
            return this.removed(elem, Murmur3.hash(elem), 0);
        }
        return this;
    }

    int slotMap() {
        return this.treeMap | this.leafMap;
    }

    int choose(int hash, int shift) {
        return 1 << (hash >>> shift & 0x1F);
    }

    int select(int branch) {
        return Integer.bitCount(this.slotMap() & branch - 1);
    }

    int follow(int branch) {
        return ((this.leafMap & branch) != 0 ? 1 : 0) | ((this.treeMap & branch) != 0 ? 2 : 0);
    }

    T leafAt(int index) {
        return (T)this.slots[index];
    }

    T getLeaf(int branch) {
        return (T)this.slots[this.select(branch)];
    }

    HashTrieSet<T> setLeaf(int branch, T leaf) {
        this.slots[this.select((int)branch)] = leaf;
        return this;
    }

    HashTrieSet<T> treeAt(int index) {
        return (HashTrieSet)this.slots[index];
    }

    HashTrieSet<T> getTree(int branch) {
        return (HashTrieSet)this.slots[this.select(branch)];
    }

    HashTrieSet<T> setTree(int branch, HashTrieSet<T> tree) {
        this.slots[this.select((int)branch)] = tree;
        return this;
    }

    ArraySet<T> knotAt(int index) {
        return (ArraySet)this.slots[index];
    }

    ArraySet<T> getKnot(int branch) {
        return (ArraySet)this.slots[this.select(branch)];
    }

    HashTrieSet<T> setKnot(int branch, ArraySet<T> knot) {
        this.slots[this.select((int)branch)] = knot;
        return this;
    }

    boolean isUnary() {
        return this.treeMap == 0 && Integer.bitCount(this.leafMap) == 1;
    }

    T unaryElem() {
        return (T)this.slots[0];
    }

    HashTrieSet<T> remap(int treeMap, int leafMap) {
        int newSlotMap;
        int oldSlotMap = this.treeMap | this.leafMap;
        Object[] oldSlots = this.slots;
        if (oldSlotMap == newSlotMap) {
            return new HashTrieSet<T>(treeMap, leafMap, (Object[])oldSlots.clone());
        }
        int i = 0;
        int j = 0;
        Object[] newSlots = new Object[Integer.bitCount(newSlotMap)];
        for (newSlotMap = treeMap | leafMap; newSlotMap != 0; newSlotMap >>>= 1) {
            if ((oldSlotMap & newSlotMap & 1) == 1) {
                newSlots[j] = oldSlots[i];
            }
            if ((oldSlotMap & 1) == 1) {
                ++i;
            }
            if ((newSlotMap & 1) == 1) {
                ++j;
            }
            oldSlotMap >>>= 1;
        }
        return new HashTrieSet<T>(treeMap, leafMap, newSlots);
    }

    T next(Object elem, int elemHash, int shift) {
        int block = elem == null ? 0 : elemHash >>> shift & 0x1F;
        int branch = 1 << block;
        int treeMap = this.treeMap >>> block;
        int leafMap = this.leafMap >>> block;
        while ((treeMap | leafMap) != 0) {
            switch (leafMap & 1 | (treeMap & 1) << 1) {
                case 0: {
                    break;
                }
                case 1: {
                    if (elem != null) break;
                    return this.getLeaf(branch);
                }
                case 2: {
                    T next = this.getTree(branch).next(elem, elemHash, shift + 5);
                    if (next == null) break;
                    return next;
                }
                case 3: {
                    T next = this.getKnot(branch).next(elem);
                    if (next == null) break;
                    return next;
                }
                default: {
                    throw new AssertionError();
                }
            }
            elem = null;
            elemHash = 0;
            treeMap >>>= 1;
            leafMap >>>= 1;
            branch <<= 1;
        }
        return null;
    }

    HashTrieSet<T> updated(T elem, int elemHash, int shift) {
        int branch = this.choose(elemHash, shift);
        switch (this.follow(branch)) {
            case 0: {
                return this.remap(this.treeMap, this.leafMap | branch).setLeaf(branch, elem);
            }
            case 1: {
                T leaf = this.getLeaf(branch);
                int leafHash = Murmur3.hash(leaf);
                if (elemHash == leafHash && elem.equals(leaf)) {
                    return this;
                }
                if (elemHash != leafHash) {
                    return this.remap(this.treeMap | branch, this.leafMap ^ branch).setTree(branch, this.merge(leaf, leafHash, elem, elemHash, shift + 5));
                }
                return this.remap(this.treeMap | branch, this.leafMap).setKnot(branch, new ArraySet(new Object[]{leaf, elem}));
            }
            case 2: {
                HashTrieSet<T> oldTree = this.getTree(branch);
                HashTrieSet<T> newTree = oldTree.updated(elem, elemHash, shift + 5);
                if (oldTree == newTree) {
                    return this;
                }
                return this.remap(this.treeMap, this.leafMap).setTree(branch, newTree);
            }
            case 3: {
                ArraySet<T> oldKnot = this.getKnot(branch);
                ArraySet<T> newKnot = oldKnot.added(elem);
                if (oldKnot == newKnot) {
                    return this;
                }
                return this.remap(this.treeMap, this.leafMap).setKnot(branch, newKnot);
            }
        }
        throw new AssertionError();
    }

    HashTrieSet<T> merge(T elem0, int hash0, T elem1, int hash1, int shift) {
        int branch0 = this.choose(hash0, shift);
        int branch1 = this.choose(hash1, shift);
        int slotMap = branch0 | branch1;
        if (branch0 == branch1) {
            Object[] slots = new Object[]{this.merge(elem0, hash0, elem1, hash1, shift + 5)};
            return new HashTrieSet<T>(slotMap, 0, slots);
        }
        Object[] slots = new Object[2];
        if ((branch0 - 1 & branch1) == 0) {
            slots[0] = elem0;
            slots[1] = elem1;
        } else {
            slots[0] = elem1;
            slots[1] = elem0;
        }
        return new HashTrieSet<T>(0, slotMap, slots);
    }

    HashTrieSet<T> removed(T elem, int elemHash, int shift) {
        int branch = this.choose(elemHash, shift);
        switch (this.follow(branch)) {
            case 0: {
                return this;
            }
            case 1: {
                if (!elem.equals(this.getLeaf(branch))) {
                    return this;
                }
                return this.remap(this.treeMap, this.leafMap ^ branch);
            }
            case 2: {
                HashTrieSet<T> oldTree = this.getTree(branch);
                HashTrieSet<T> newTree = oldTree.removed(elem, elemHash, shift + 5);
                if (oldTree == newTree) {
                    return this;
                }
                if (newTree.isEmpty()) {
                    return this.remap(this.treeMap ^ branch, this.leafMap);
                }
                if (newTree.isUnary()) {
                    return this.remap(this.treeMap ^ branch, this.leafMap | branch).setLeaf(branch, newTree.unaryElem());
                }
                return this.remap(this.treeMap, this.leafMap).setTree(branch, newTree);
            }
            case 3: {
                ArraySet<T> oldKnot = this.getKnot(branch);
                ArraySet<T> newKnot = oldKnot.removed(elem);
                if (oldKnot == newKnot) {
                    return this;
                }
                if (newKnot.isEmpty()) {
                    return this.remap(this.treeMap ^ branch, this.leafMap);
                }
                if (newKnot.isUnary()) {
                    return this.remap(this.treeMap ^ branch, this.leafMap | branch).setLeaf(branch, newKnot.unaryElem());
                }
                return this.remap(this.treeMap, this.leafMap).setKnot(branch, newKnot);
            }
        }
        throw new AssertionError();
    }

    @Override
    public Object[] toArray() {
        int i = 0;
        Object[] array = new Object[this.size()];
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    @Override
    public <U> U[] toArray(U[] array) {
        int i = 0;
        int n = this.size();
        if (array.length < n) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), n);
        }
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        if (array.length > n) {
            array[n] = null;
        }
        return array;
    }

    @Override
    public Iterator<T> iterator() {
        return new HashTrieSetIterator(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (this.size() == that.size()) {
                Iterator those = that.iterator();
                while (those.hasNext()) {
                    if (this.contains(those.next())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 0;
        for (T next : this) {
            code += next == null ? 0 : next.hashCode();
        }
        return code;
    }

    public <U> Output<U> debug(Output<U> output) {
        output = output.write("HashTrieSet").write(46);
        Iterator<T> these = this.iterator();
        if (these.hasNext()) {
            output = output.write("of").write(40).debug(these.next());
            while (these.hasNext()) {
                output = output.write(", ").debug(these.next());
            }
        } else {
            output = output.write("empty").write(40);
        }
        output = output.write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> HashTrieSet<T> empty() {
        if (empty == null) {
            empty = new HashTrieSet<T>(0, 0, new Object[0]);
        }
        return empty;
    }

    public static <T> HashTrieSet<T> of(T ... elems) {
        HashTrieSet<T> trie = HashTrieSet.empty();
        for (T elem : elems) {
            trie = trie.added(elem);
        }
        return trie;
    }

    public static <T> HashTrieSet<T> from(Iterable<? extends T> elems) {
        HashTrieSet<T> trie = HashTrieSet.empty();
        for (T elem : elems) {
            trie = trie.added(elem);
        }
        return trie;
    }
}

