/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.concurrent.ClockDef;
import swim.concurrent.ClockEvent;
import swim.concurrent.ClockQueue;
import swim.concurrent.ClockThread;
import swim.concurrent.ClockTimer;
import swim.concurrent.Schedule;
import swim.concurrent.ScheduleException;
import swim.concurrent.Timer;
import swim.concurrent.TimerException;
import swim.concurrent.TimerFunction;
import swim.concurrent.TimerRef;

public class Clock
implements Schedule {
    public static final int TICK_MILLIS;
    public static final int TICK_COUNT;
    static final int STARTED = 1;
    static final int STOPPED = 2;
    static final AtomicIntegerFieldUpdater<Clock> STATUS;
    final ClockQueue[] dial;
    final CountDownLatch startLatch;
    final CountDownLatch stopLatch;
    final ClockThread thread;
    final long tickNanos;
    final int tickCount;
    volatile long startTime;
    volatile int status;

    public Clock(int tickMillis, int tickCount) {
        if (tickMillis <= 0) {
            throw new IllegalArgumentException(Long.toString(tickMillis));
        }
        this.tickNanos = (long)tickMillis * 1000000L;
        if (tickCount <= 0) {
            throw new IllegalArgumentException(Integer.toString(tickCount));
        }
        --tickCount;
        tickCount |= tickCount >> 1;
        tickCount |= tickCount >> 2;
        tickCount |= tickCount >> 4;
        tickCount |= tickCount >> 8;
        tickCount |= tickCount >> 16;
        this.tickCount = ++tickCount;
        this.dial = new ClockQueue[tickCount];
        for (int i = 0; i < tickCount; ++i) {
            this.dial[i] = new ClockQueue(i);
        }
        this.startLatch = new CountDownLatch(1);
        this.stopLatch = new CountDownLatch(1);
        this.thread = new ClockThread(this);
    }

    public Clock(ClockDef clockDef) {
        this(clockDef.tickMillis, clockDef.tickCount);
    }

    public Clock() {
        this(TICK_MILLIS, TICK_COUNT);
    }

    public final long tick() {
        return this.thread.tick;
    }

    public final void start() {
        block6: {
            int oldStatus;
            while (((oldStatus = STATUS.get(this)) & 2) == 0) {
                if ((oldStatus & 1) == 0) {
                    int newStatus = oldStatus | 1;
                    if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                    this.willStart();
                    this.thread.start();
                }
                break block6;
            }
            throw new ScheduleException("Can't restart stopped clock");
        }
        boolean interrupted = false;
        while (this.startLatch.getCount() != 0L) {
            try {
                this.startLatch.await();
            }
            catch (InterruptedException error) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public final void stop() {
        int oldStatus;
        if ((STATUS.get(this) & 1) == 0) {
            return;
        }
        boolean interrupted = false;
        while (((oldStatus = STATUS.get(this)) & 2) == 0) {
            int newStatus = oldStatus | 2;
            if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
            while (this.thread.isAlive()) {
                this.thread.interrupt();
                try {
                    this.thread.join(100L);
                }
                catch (InterruptedException error) {
                    interrupted = true;
                }
            }
        }
        while (this.stopLatch.getCount() != 0L) {
            try {
                this.stopLatch.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public TimerRef timer(TimerFunction timer) {
        this.start();
        ClockTimer context = new ClockTimer(this, timer);
        if (timer instanceof Timer) {
            ((Timer)timer).setTimerContext(context);
        }
        return context;
    }

    @Override
    public TimerRef setTimer(long millis, TimerFunction timer) {
        if (millis < 0L) {
            throw new TimerException("negative timeout: " + Long.toString(millis));
        }
        this.start();
        ClockTimer context = new ClockTimer(this, timer);
        if (timer instanceof Timer) {
            ((Timer)timer).setTimerContext(context);
        }
        this.schedule(millis, context);
        return context;
    }

    final void schedule(long millis, ClockTimer context) {
        ClockEvent foot;
        this.timerWillSchedule(context.timer, millis);
        if (context.timer instanceof Timer) {
            ((Timer)context.timer).timerWillSchedule(millis);
        }
        long nanos = millis * 1000000L;
        long deadline = Math.max(0L, this.nanoTime() + nanos - this.startTime);
        long targetTick = (deadline + (this.tickNanos - 1L)) / this.tickNanos;
        int targetHand = (int)(targetTick % (long)this.tickCount);
        ClockEvent newEvent = new ClockEvent(0L, targetTick, context, context.timer);
        ClockEvent oldEvent = ClockTimer.EVENT.getAndSet(context, newEvent);
        if (oldEvent != null) {
            oldEvent.cancel();
        }
        ClockQueue queue = this.dial[targetHand];
        ClockEvent prev = foot = queue.foot;
        while (true) {
            ClockEvent next;
            if ((next = prev.next) == null) {
                if (targetTick >= prev.insertTick) {
                    newEvent.insertTick = prev.insertTick;
                    if (!ClockEvent.NEXT.compareAndSet(prev, null, newEvent)) continue;
                    if (prev == foot) break;
                    ClockQueue.FOOT.compareAndSet(queue, foot, newEvent);
                    break;
                }
                targetHand = (int)(++targetTick % (long)this.tickCount);
                queue = this.dial[targetHand];
                prev = foot = queue.foot;
                continue;
            }
            ClockEvent newFoot = queue.foot;
            if (foot != newFoot) {
                prev = foot = newFoot;
                continue;
            }
            prev = next;
        }
    }

    protected void willStart() {
    }

    protected void didStart() {
    }

    protected void didTick(long tick, long waitedMillis) {
    }

    protected void willStop() {
    }

    protected void didStop() {
    }

    protected void didFail(Throwable error) {
        error.printStackTrace();
    }

    protected void timerWillSchedule(TimerFunction timer, long millis) {
    }

    protected void timerDidCancel(TimerFunction timer) {
    }

    protected void timerWillRun(TimerFunction timer) {
    }

    protected void runTimer(TimerFunction timer, Runnable runnable) {
        timer.runTimer();
    }

    protected void timerDidRun(TimerFunction timer) {
    }

    protected void timerDidFail(TimerFunction timer, Throwable error) {
    }

    protected long nanoTime() {
        return System.nanoTime();
    }

    protected void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    static {
        int tickCount;
        int tickMillis;
        STATUS = AtomicIntegerFieldUpdater.newUpdater(Clock.class, "status");
        try {
            tickMillis = Integer.parseInt(System.getProperty("swim.clock.tick.millis"));
        }
        catch (NumberFormatException e) {
            tickMillis = 100;
        }
        TICK_MILLIS = tickMillis;
        try {
            tickCount = Integer.parseInt(System.getProperty("swim.clock.tick.count"));
        }
        catch (NumberFormatException e) {
            tickCount = 512;
        }
        TICK_COUNT = tickCount;
    }
}

