/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.concurrent.Clock;
import swim.concurrent.ClockForm;
import swim.concurrent.ScheduleDef;
import swim.structure.Form;
import swim.structure.Kind;
import swim.util.Murmur3;

public class ClockDef
implements ScheduleDef,
Debug {
    private static int hashSeed;
    private static ClockDef standard;
    private static Form<ClockDef> clockForm;
    final int tickMillis;
    final int tickCount;

    public ClockDef(int tickMillis, int tickCount) {
        this.tickMillis = tickMillis;
        this.tickCount = tickCount;
    }

    public static ClockDef standard() {
        if (standard == null) {
            standard = new ClockDef(Clock.TICK_MILLIS, Clock.TICK_COUNT);
        }
        return standard;
    }

    @Kind
    public static Form<ClockDef> clockForm() {
        if (clockForm == null) {
            clockForm = new ClockForm(ClockDef.standard());
        }
        return clockForm;
    }

    public final int tickMillis() {
        return this.tickMillis;
    }

    public ClockDef tickMillis(int tickMillis) {
        return this.copy(tickMillis, this.tickCount);
    }

    public final int tickCount() {
        return this.tickCount;
    }

    public ClockDef tickCount(int tickCount) {
        return this.copy(this.tickMillis, tickCount);
    }

    protected ClockDef copy(int tickMillis, int tickCount) {
        return new ClockDef(tickMillis, tickCount);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ClockDef) {
            ClockDef that = (ClockDef)other;
            return this.tickMillis == that.tickMillis && this.tickCount == that.tickCount;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ClockDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.tickMillis), (int)this.tickCount));
    }

    public void debug(Output<?> output) {
        output = output.write("ClockDef").write(46).write("standard").write(40).write(41);
        if (this.tickMillis != Clock.TICK_MILLIS) {
            output = output.write(46).write("tickMillis").write(40).debug((Object)this.tickMillis).write(41);
        }
        if (this.tickCount != Clock.TICK_COUNT) {
            output = output.write(46).write("tickCount").write(40).debug((Object)this.tickCount).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

