/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import swim.concurrent.Clock;
import swim.concurrent.ClockEvent;
import swim.concurrent.ClockQueue;
import swim.concurrent.ClockTimer;
import swim.concurrent.Conts;
import swim.concurrent.TimerFunction;

final class ClockThread
extends Thread {
    static final AtomicInteger THREAD_COUNT = new AtomicInteger(0);
    final Clock clock;
    long tick;

    ClockThread(Clock clock) {
        this.setName("SwimClock" + THREAD_COUNT.getAndIncrement());
        this.setDaemon(true);
        this.clock = clock;
    }

    static long waitForTick(Clock clock, long tick) {
        long initialTime;
        long deadline = clock.tickNanos * tick;
        long currentTime = initialTime = clock.nanoTime() - clock.startTime;
        while (true) {
            block4: {
                if (currentTime < 0L) {
                    throw new InternalError("Clock elapsed time overflow");
                }
                long sleepMillis = (deadline - currentTime + 999999L) / 1000000L;
                if (sleepMillis <= 0L) break;
                try {
                    clock.sleep(sleepMillis);
                }
                catch (InterruptedException e) {
                    if ((Clock.STATUS.get(clock) & 2) == 0) break block4;
                    return Long.MIN_VALUE;
                }
            }
            currentTime = clock.nanoTime() - clock.startTime;
        }
        currentTime = clock.nanoTime() - clock.startTime;
        return (currentTime - initialTime) / 1000000L;
    }

    static void executeTick(Clock clock, long tick) {
        long nextTick = tick + (long)clock.tickCount;
        int hand = (int)(tick % (long)clock.tickCount);
        ClockQueue queue = clock.dial[hand];
        ClockEvent head = null;
        ClockEvent prev = null;
        ClockEvent next = queue.head;
        ClockEvent nextFoot = new ClockEvent(nextTick, nextTick, null, null);
        while (true) {
            if (next.targetTick <= tick) {
                TimerFunction timer = next.cancel();
                if (next.context != null) {
                    ClockTimer.EVENT.compareAndSet(next.context, next, null);
                }
                if (timer != null) {
                    try {
                        clock.timerWillRun(timer);
                        clock.runTimer(timer, next);
                        clock.timerDidRun(timer);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal(error)) {
                            clock.timerDidFail(timer, error);
                        }
                        throw error;
                    }
                }
            } else if (next.isScheduled()) {
                if (prev != null) {
                    prev.next = next;
                } else {
                    head = next;
                }
                prev = next;
            }
            if (next.next == null && ClockEvent.NEXT.compareAndSet(next, null, nextFoot)) {
                ClockQueue.FOOT.set(queue, nextFoot);
                if (head == null) {
                    head = nextFoot;
                }
                break;
            }
            next = next.next;
        }
        queue.head = head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            Clock clock = this.clock;
            try {
                long startTime = clock.nanoTime();
                if (startTime == 0L) {
                    startTime = 1L;
                }
                clock.startTime = startTime;
                clock.startLatch.countDown();
                clock.didStart();
                do {
                    long tick;
                    long waitedMillis;
                    if ((waitedMillis = ClockThread.waitForTick(clock, tick = this.tick)) == Long.MIN_VALUE) continue;
                    ClockThread.executeTick(clock, tick);
                    clock.didTick(tick, waitedMillis);
                    this.tick = tick + 1L;
                } while ((Clock.STATUS.get(clock) & 2) == 0);
                clock.willStop();
            }
            catch (Throwable error) {
                if (Conts.isNonFatal(error)) {
                    clock.didFail(error);
                    break block8;
                }
                throw error;
            }
            finally {
                Clock.STATUS.set(clock, 2);
                clock.stopLatch.countDown();
                clock.didStop();
            }
        }
    }
}

