/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.concurrent.Call;
import swim.concurrent.Cont;
import swim.concurrent.ContException;
import swim.concurrent.Theater;

final class TheaterCall<T>
implements Call<T>,
Runnable {
    static final int BIND = 1;
    static final int TRAP = 2;
    static final int CUED = 4;
    static final int DONE = 8;
    static final AtomicIntegerFieldUpdater<TheaterCall<?>> STATUS = AtomicIntegerFieldUpdater.newUpdater(TheaterCall.class, "status");
    final Theater theater;
    final Cont<T> cont;
    volatile Object result;
    volatile int status;

    TheaterCall(Theater theater, Cont<T> cont) {
        this.theater = theater;
        this.cont = cont;
    }

    @Override
    public Cont<T> cont() {
        return this.cont;
    }

    @Override
    public void bind(T value) {
        if (!this.tryBind(value)) {
            throw new ContException("continuation already completed");
        }
    }

    @Override
    public void trap(Throwable error) {
        if (!this.tryTrap(error)) {
            throw new ContException("continuation already completed");
        }
    }

    @Override
    public boolean tryBind(T value) {
        int newStatus;
        int oldStatus;
        while (!STATUS.compareAndSet(this, oldStatus, newStatus = (oldStatus = this.status) == 0 ? oldStatus | 1 | 4 : oldStatus)) {
        }
        if (oldStatus != newStatus) {
            this.result = value;
            this.theater.callWillCue(this.cont);
            this.theater.execute(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryTrap(Throwable error) {
        int newStatus;
        int oldStatus;
        while (!STATUS.compareAndSet(this, oldStatus, newStatus = (oldStatus = this.status) == 0 ? oldStatus | 2 | 4 : oldStatus)) {
        }
        if (oldStatus != newStatus) {
            this.result = error;
            this.theater.callWillCue(this.cont);
            this.theater.execute(this);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        int newStatus;
        int oldStatus;
        while (!STATUS.compareAndSet(this, oldStatus, newStatus = ((oldStatus = this.status) & 4) != 0 ? oldStatus & 0xFFFFFFFB : oldStatus)) {
        }
        if (oldStatus != newStatus) {
            Object result;
            if ((newStatus & 1) != 0) {
                result = this.result;
                this.theater.callWillBind(this.cont, result);
                try {
                    this.cont.bind(result);
                    this.theater.callDidBind(this.cont, result);
                }
                catch (Throwable error) {
                    this.theater.callDidFail(this.cont, error);
                    this.cont.trap(error);
                }
            } else if ((newStatus & 2) != 0) {
                result = (Throwable)this.result;
                this.theater.callWillTrap(this.cont, (Throwable)result);
                try {
                    this.cont.trap((Throwable)result);
                    this.theater.callDidTrap(this.cont, (Throwable)result);
                }
                catch (Throwable error) {
                    this.theater.callDidFail(this.cont, error);
                }
            }
        }
        while (!STATUS.compareAndSet(this, oldStatus = this.status, newStatus = oldStatus | 8)) {
        }
    }
}

