/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.concurrent.Clock;
import swim.concurrent.ClockEvent;
import swim.concurrent.Schedule;
import swim.concurrent.Timer;
import swim.concurrent.TimerContext;
import swim.concurrent.TimerException;
import swim.concurrent.TimerFunction;

final class ClockTimer
implements TimerContext {
    final Clock clock;
    final TimerFunction timer;
    volatile ClockEvent event;
    static final AtomicReferenceFieldUpdater<ClockTimer, ClockEvent> EVENT = AtomicReferenceFieldUpdater.newUpdater(ClockTimer.class, ClockEvent.class, "event");

    ClockTimer(Clock clock, TimerFunction timer) {
        this.clock = clock;
        this.timer = timer;
        this.event = null;
    }

    @Override
    public Schedule schedule() {
        return this.clock;
    }

    @Override
    public boolean isScheduled() {
        ClockEvent event = EVENT.get(this);
        return event != null && event.isScheduled();
    }

    @Override
    public void reschedule(long millis) {
        if (millis < 0L) {
            throw new TimerException("negative timeout: " + Long.toString(millis));
        }
        this.clock.schedule(millis, this);
    }

    @Override
    public boolean cancel() {
        TimerFunction timer;
        ClockEvent event = EVENT.getAndSet(this, null);
        if (event != null && (timer = event.cancel()) != null) {
            if (timer instanceof Timer) {
                ((Timer)timer).timerDidCancel();
            }
            this.clock.timerDidCancel(timer);
            return true;
        }
        return false;
    }
}

