/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.concurrent.Cont;
import swim.concurrent.ContException;
import swim.concurrent.SyncException;

public class Sync<T>
implements Cont<T>,
ForkJoinPool.ManagedBlocker {
    volatile int status = 0;
    volatile Object result = null;
    static final int BIND = 1;
    static final int TRAP = 2;
    static final AtomicIntegerFieldUpdater<Sync<?>> STATUS = AtomicIntegerFieldUpdater.newUpdater(Sync.class, "status");
    static final ThreadLocal<Long> TIMEOUT = new ThreadLocal();

    @Override
    public boolean isReleasable() {
        return this.status != 0;
    }

    @Override
    public synchronized boolean block() throws InterruptedException {
        if (this.status == 0) {
            this.wait(TIMEOUT.get());
        }
        return true;
    }

    @Override
    public synchronized void bind(T value) {
        this.result = value;
        STATUS.set(this, 1);
        this.notifyAll();
    }

    @Override
    public synchronized void trap(Throwable error) {
        this.result = error;
        STATUS.set(this, 2);
        this.notifyAll();
    }

    public T await(long timeout) throws InterruptedException {
        block6: {
            long t1;
            long elapsedMillis;
            long t0 = System.nanoTime();
            long waitMillis = timeout;
            do {
                if (this.status == 0) {
                    TIMEOUT.set(timeout);
                    ForkJoinPool.managedBlock(this);
                }
                if (this.status != 0) break block6;
            } while (timeout <= 0L || (waitMillis = timeout - (elapsedMillis = ((t1 = System.nanoTime()) - t0) / 1000000L)) > 0L);
            throw new SyncException("timed out");
        }
        int status = this.status;
        Object result = this.result;
        if (status == 1) {
            return (T)result;
        }
        if (status == 2) {
            if (result instanceof Error) {
                throw (Error)result;
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            throw new ContException((Throwable)result);
        }
        throw new IllegalStateException();
    }

    public T await() throws InterruptedException {
        return this.await(0L);
    }
}

