/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.concurrent.Call;
import swim.concurrent.Cont;
import swim.concurrent.ContException;
import swim.concurrent.Theater;

final class TheaterCall<T>
implements Call<T>,
Runnable {
    final Theater theater;
    final Cont<T> cont;
    volatile Object result;
    volatile int status;
    static final int BIND = 1;
    static final int TRAP = 2;
    static final int CUED = 4;
    static final int DONE = 8;
    static final AtomicIntegerFieldUpdater<TheaterCall<?>> STATUS = AtomicIntegerFieldUpdater.newUpdater(TheaterCall.class, "status");

    TheaterCall(Theater theater, Cont<T> cont) {
        this.theater = theater;
        this.cont = cont;
        this.result = null;
        this.status = 0;
    }

    @Override
    public Cont<T> cont() {
        return this.cont;
    }

    @Override
    public void bind(T value) {
        if (!this.tryBind(value)) {
            throw new ContException("continuation already completed");
        }
    }

    @Override
    public void trap(Throwable error) {
        if (!this.tryTrap(error)) {
            throw new ContException("continuation already completed");
        }
    }

    @Override
    public boolean tryBind(T value) {
        int oldStatus;
        while ((oldStatus = STATUS.get(this)) == 0) {
            int newStatus = 5;
            if (!STATUS.compareAndSet(this, oldStatus, 5)) continue;
            this.result = value;
            this.theater.callWillCue(this.cont);
            this.theater.execute(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryTrap(Throwable error) {
        int oldStatus;
        while ((oldStatus = STATUS.get(this)) == 0) {
            int newStatus = 6;
            if (!STATUS.compareAndSet(this, oldStatus, 6)) continue;
            this.result = error;
            this.theater.callWillCue(this.cont);
            this.theater.execute(this);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        int newStatus;
        int oldStatus;
        while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus & 0xFFFFFFFB)) {
        }
        if (oldStatus != newStatus) {
            Object result;
            if ((newStatus & 1) != 0) {
                result = this.result;
                this.theater.callWillBind(this.cont, result);
                try {
                    this.cont.bind(result);
                    this.theater.callDidBind(this.cont, result);
                }
                catch (Throwable error) {
                    if (Cont.isNonFatal(error)) {
                        this.theater.callDidFail(this.cont, error);
                        this.cont.trap(error);
                    }
                    throw error;
                }
            } else if ((newStatus & 2) != 0) {
                result = (Throwable)this.result;
                this.theater.callWillTrap(this.cont, (Throwable)result);
                try {
                    this.cont.trap((Throwable)result);
                    this.theater.callDidTrap(this.cont, (Throwable)result);
                }
                catch (Throwable error) {
                    if (Cont.isNonFatal(error)) {
                        this.theater.callDidFail(this.cont, error);
                    }
                    throw error;
                }
            }
        }
        while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus | 8)) {
        }
    }
}

