/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.concurrent.ScheduleDef;
import swim.concurrent.StageDef;
import swim.concurrent.TheaterForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.util.Murmur3;

public class TheaterDef
implements StageDef,
Debug {
    final String name;
    final int parallelism;
    final ScheduleDef scheduleDef;
    private static int hashSeed;
    private static TheaterDef standard;
    private static Form<TheaterDef> theaterForm;

    public TheaterDef(String name, int parallelism, ScheduleDef scheduleDef) {
        this.name = name;
        this.parallelism = parallelism;
        this.scheduleDef = scheduleDef;
    }

    public final String name() {
        return this.name;
    }

    public TheaterDef name(String name) {
        return this.copy(name, this.parallelism, this.scheduleDef);
    }

    public final int parallelism() {
        return this.parallelism;
    }

    public TheaterDef parallelism(int parallelism) {
        return this.copy(this.name, parallelism, this.scheduleDef);
    }

    public final ScheduleDef scheduleDef() {
        return this.scheduleDef;
    }

    public TheaterDef scheduleDef(ScheduleDef scheduleDef) {
        return this.copy(this.name, this.parallelism, scheduleDef);
    }

    protected TheaterDef copy(String name, int parallelism, ScheduleDef scheduleDef) {
        return new TheaterDef(name, parallelism, scheduleDef);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TheaterDef) {
            TheaterDef that = (TheaterDef)other;
            return (this.name == null ? that.name == null : this.name.equals(that.name)) && this.parallelism == that.parallelism && (this.scheduleDef == null ? that.scheduleDef == null : this.scheduleDef.equals(that.scheduleDef));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(TheaterDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.name)), (int)this.parallelism), (int)Murmur3.hash((Object)this.scheduleDef)));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("TheaterDef").write(46).write("standard").write(40).write(41);
        if (this.name != null) {
            output = output.write(46).write("name").write(40).debug((Object)this.name).write(41);
        }
        output = output.write(46).write("parallelism").write(40).debug((Object)this.parallelism).write(41);
        if (this.scheduleDef != null) {
            output = output.write(46).write("scheduleDef").write(40).debug((Object)this.scheduleDef).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static TheaterDef standard() {
        if (standard == null) {
            standard = new TheaterDef(null, 0, null);
        }
        return standard;
    }

    @Kind
    public static Form<TheaterDef> theaterForm() {
        if (theaterForm == null) {
            theaterForm = new TheaterForm(ScheduleDef.form(), TheaterDef.standard());
        }
        return theaterForm;
    }

    public static Form<TheaterDef> theaterForm(Form<ScheduleDef> scheduleForm) {
        return new TheaterForm(scheduleForm, TheaterDef.standard());
    }
}

