// Copyright 2015-2020 SWIM.AI inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package swim.csv.structure;

import swim.csv.schema.CsvCol;
import swim.csv.schema.CsvHeader;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

public abstract class CsvStructureHeader extends CsvHeader<Record, Value, Item> {

  @Override
  public abstract CsvStructureHeader col(int index, CsvCol<? extends Item> col);

  @Override
  public abstract CsvStructureHeader col(CsvCol<? extends Item> col);

  public abstract CsvStructureHeader cols(CsvStructureCol... cols);

}
