/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.parser;

import swim.codec.Input;
import swim.codec.InputException;
import swim.codec.InputSettings;
import swim.codec.Mark;

final class CsvQuotedInput
extends Input {
    final int quote;
    Input input;
    int head;

    CsvQuotedInput(int quote, Input input, int head) {
        this.quote = quote;
        this.input = input;
        this.head = head;
    }

    CsvQuotedInput(int quote, Input input) {
        this(quote, input, -1);
    }

    int next() {
        if (this.head == -1 && this.input.isCont()) {
            this.head = this.input.head();
            this.input = this.input.step();
            if (this.head == this.quote) {
                this.head = -2;
            }
        } else if (this.head == -1 && this.input.isDone()) {
            this.head = -4;
        }
        if (this.head == -2 && this.input.isCont()) {
            this.head = this.input.head();
            if (this.head == this.quote) {
                this.input = this.input.step();
            } else {
                this.head = -3;
            }
        } else if (this.head == -2 && this.input.isDone()) {
            this.head = -3;
        }
        return this.head;
    }

    public boolean isCont() {
        return this.next() >= 0;
    }

    public boolean isEmpty() {
        int head = this.next();
        return head == -1 && this.input.isEmpty() || head == -2;
    }

    public boolean isDone() {
        int head = this.next();
        return head == -1 && this.input.isDone() || head == -3 || head == -4;
    }

    public boolean isError() {
        int head = this.next();
        return head == -1 && this.input.isError();
    }

    public boolean isPart() {
        return this.input.isPart();
    }

    public Input isPart(boolean isPart) {
        return new CsvQuotedInput(this.quote, this.input.isPart(isPart), this.head);
    }

    public int head() {
        int head = this.next();
        if (head >= 0) {
            return head;
        }
        throw new InputException();
    }

    public Input step() {
        int head = this.next();
        if (head >= 0) {
            this.head = -1;
            return this;
        }
        InputException error = new InputException("invalid step");
        return Input.error((Throwable)error, (Object)this.id(), (Mark)this.mark(), (InputSettings)this.settings());
    }

    public Input seek(Mark mark) {
        throw new UnsupportedOperationException();
    }

    public Throwable trap() {
        return this.input.trap();
    }

    public Object id() {
        return this.input.id();
    }

    public Input id(Object id) {
        return new CsvQuotedInput(this.quote, this.input.id(id), this.head);
    }

    public Mark mark() {
        return this.input.mark();
    }

    public Input mark(Mark mark) {
        return new CsvQuotedInput(this.quote, this.input.mark(mark), this.head);
    }

    public long offset() {
        return this.input.offset();
    }

    public int line() {
        return this.input.line();
    }

    public int column() {
        return this.input.column();
    }

    public InputSettings settings() {
        return this.input.settings();
    }

    public Input settings(InputSettings settings) {
        return new CsvQuotedInput(this.quote, this.input.settings(settings), this.head);
    }

    public Input clone() {
        return new CsvQuotedInput(this.quote, this.input.clone(), this.head);
    }
}

