/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.parser;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.csv.parser.CsvInput;
import swim.csv.parser.CsvParser;
import swim.csv.parser.CsvQuotedInput;
import swim.csv.schema.CsvHeader;

final class HeaderParser<T, R, C>
extends Parser<CsvHeader<T, R, C>> {
    final CsvParser csv;
    final CsvHeader<T, R, C> header;
    final Parser<String> nameParser;
    final int index;
    final int head;
    final int step;

    HeaderParser(CsvParser csv, CsvHeader<T, R, C> header, Parser<String> nameParser, int index, int head, int step) {
        this.csv = csv;
        this.header = header;
        this.nameParser = nameParser;
        this.index = index;
        this.head = head;
        this.step = step;
    }

    HeaderParser(CsvParser csv, CsvHeader<T, R, C> header) {
        this(csv, header, null, 0, -1, 1);
    }

    static <T, R, C> Parser<CsvHeader<T, R, C>> parse(Input input, CsvParser csv, CsvHeader<T, R, C> header, Parser<String> nameParser, int index, int head, int step) {
        block22: {
            block23: {
                int c = 0;
                while (true) {
                    Input cellInput;
                    if (step == 1) {
                        if (input.isCont() && input.head() == 34) {
                            input = input.step();
                            step = 3;
                        } else if (!input.isEmpty()) {
                            step = 2;
                        }
                    }
                    if (step == 2) {
                        cellInput = new CsvInput(csv, input);
                        if (nameParser == null) {
                            nameParser = Unicode.parseString((Input)cellInput);
                        }
                        while (nameParser.isCont() && !cellInput.isEmpty()) {
                            nameParser = nameParser.feed(cellInput);
                        }
                        if (nameParser.isDone()) {
                            header = header.col(index, (String)nameParser.bind());
                            nameParser = null;
                            ++index;
                            step = 4;
                        } else if (nameParser.isError()) {
                            return nameParser.asError();
                        }
                    }
                    if (step == 3) {
                        cellInput = new CsvQuotedInput(34, input, head);
                        if (nameParser == null) {
                            nameParser = Unicode.parseString((Input)cellInput);
                        }
                        while (nameParser.isCont() && !cellInput.isEmpty()) {
                            nameParser = nameParser.feed(cellInput);
                        }
                        if (cellInput instanceof CsvQuotedInput) {
                            head = ((CsvQuotedInput)cellInput).next();
                        }
                        if (head == -4) {
                            return HeaderParser.error((Diagnostic)Diagnostic.expected((int)34, (Input)input));
                        }
                        if (nameParser.isDone()) {
                            header = header.col(index, (String)nameParser.bind());
                            nameParser = null;
                            ++index;
                            head = -1;
                            step = 4;
                        } else if (nameParser.isError()) {
                            return nameParser.asError();
                        }
                    }
                    if (step != 4) break block22;
                    if (!input.isCont()) break block23;
                    c = input.head();
                    if (c == 13 || c == 10) {
                        return HeaderParser.done(header);
                    }
                    if (!csv.isDelimiter(c)) break;
                    input = input.step();
                    step = 1;
                }
                return HeaderParser.error((Diagnostic)Diagnostic.expected((String)"delimiter or line break", (Input)input));
            }
            if (input.isDone()) {
                return HeaderParser.error((Diagnostic)Diagnostic.expected((String)"delimiter", (Input)input));
            }
        }
        if (input.isError()) {
            return HeaderParser.error((Throwable)input.trap());
        }
        return new HeaderParser<T, R, C>(csv, header, (Parser<String>)nameParser, index, head, step);
    }

    static <T, R, C> Parser<CsvHeader<T, R, C>> parse(Input input, CsvParser csv, CsvHeader<T, R, C> header) {
        return HeaderParser.parse(input, csv, header, null, 0, -1, 1);
    }

    public Parser<CsvHeader<T, R, C>> feed(Input input) {
        return HeaderParser.parse(input, this.csv, this.header, this.nameParser, this.index, this.head, this.step);
    }
}

