/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.parser;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.csv.parser.CsvParser;
import swim.csv.schema.CsvHeader;

final class TableParser<T, R, C>
extends Parser<T> {
    final CsvParser csv;
    final CsvHeader<T, R, C> header;
    final Parser<CsvHeader<T, R, C>> headerParser;
    final int step;

    TableParser(CsvParser csv, CsvHeader<T, R, C> header, Parser<CsvHeader<T, R, C>> headerParser, int step) {
        this.csv = csv;
        this.header = header;
        this.headerParser = headerParser;
        this.step = step;
    }

    TableParser(CsvParser csv, CsvHeader<T, R, C> header) {
        this(csv, header, null, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    static <T, R, C> Parser<T> parse(Input input, CsvParser csv, CsvHeader<T, R, C> header, Parser<CsvHeader<T, R, C>> headerParser, int step) {
        block16: {
            int c = 0;
            if (step == 1) {
                if (headerParser == null) {
                    headerParser = csv.parseHeader(header, input);
                }
                while (headerParser.isCont() && !input.isEmpty()) {
                    headerParser = headerParser.feed(input);
                }
                if (headerParser.isDone()) {
                    step = 2;
                } else if (headerParser.isError()) {
                    return headerParser.asError();
                }
            }
            if (step == 2) {
                if (input.isCont()) {
                    c = input.head();
                    if (c == 13) {
                        input = input.step();
                        step = 3;
                        break block16;
                    } else {
                        if (c == 10) {
                            input = input.step();
                            return csv.parseBody((CsvHeader)headerParser.bind(), input);
                        }
                        return TableParser.error((Diagnostic)Diagnostic.expected((String)"carriage return or line feed", (Input)input));
                    }
                }
                if (!input.isEmpty()) {
                    return TableParser.error((Diagnostic)Diagnostic.expected((String)"carriage return or line feed", (Input)input));
                }
            }
        }
        if (step == 3) {
            if (input.isCont() && input.head() == 10) {
                input = input.step();
                return csv.parseBody((CsvHeader)headerParser.bind(), input);
            }
            if (!input.isEmpty()) {
                return csv.parseBody((CsvHeader)headerParser.bind(), input);
            }
        }
        if (input.isError()) {
            return TableParser.error((Throwable)input.trap());
        }
        return new TableParser<T, R, C>(csv, header, headerParser, step);
    }

    static <T, R, C> Parser<T> parse(Input input, CsvParser csv, CsvHeader<T, R, C> header) {
        return TableParser.parse(input, csv, header, null, 1);
    }

    public Parser<T> feed(Input input) {
        return TableParser.parse(input, this.csv, this.header, this.headerParser, this.step);
    }
}

