/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.structure;

import swim.codec.Parser;
import swim.codec.Unicode;
import swim.collections.FingerTrieSeq;
import swim.csv.schema.CsvCol;
import swim.csv.structure.ArrayStructure;
import swim.csv.structure.CsvStructureCol;
import swim.csv.structure.CsvStructureHeader;
import swim.csv.structure.HeaderStructure;
import swim.csv.structure.NumberStructure;
import swim.csv.structure.ParsedStructure;
import swim.csv.structure.StringStructure;
import swim.structure.Item;
import swim.structure.Text;
import swim.structure.Value;

public final class CsvStructure {
    private CsvStructure() {
    }

    public static CsvStructureHeader header(CsvStructureCol ... cols) {
        return new HeaderStructure((FingerTrieSeq<CsvCol<? extends Item>>)FingerTrieSeq.of((Object[])cols));
    }

    public static CsvStructureHeader header() {
        return HeaderStructure.empty();
    }

    public static CsvStructureHeader array(CsvCol<? extends Item> col, int colCount) {
        return new ArrayStructure(col, colCount);
    }

    public static CsvStructureHeader array(CsvCol<? extends Item> col) {
        return new ArrayStructure(col, Integer.MAX_VALUE);
    }

    public static CsvStructureCol stringCol(Value key) {
        return new StringStructure(key, key.stringValue(""), false);
    }

    public static CsvStructureCol stringCol(String key) {
        return new StringStructure((Value)Text.from((String)key), key, false);
    }

    public static CsvStructureCol stringCol() {
        return new StringStructure(Value.absent(), "", false);
    }

    public static CsvStructureCol numberCol(Value key) {
        return new NumberStructure(key, key.stringValue(""), false);
    }

    public static CsvStructureCol numberCol(String key) {
        return new NumberStructure((Value)Text.from((String)key), key, false);
    }

    public static CsvStructureCol numberCol() {
        return new NumberStructure(Value.absent(), "", false);
    }

    public static CsvStructureCol nullCol(Value key) {
        return new ParsedStructure(key, key.stringValue(""), true, (Parser<? extends Item>)Unicode.nullParser());
    }

    public static CsvStructureCol nullCol(String key) {
        return new ParsedStructure((Value)Text.from((String)key), key, true, (Parser<? extends Item>)Unicode.nullParser());
    }

    public static CsvStructureCol nullCol() {
        return new ParsedStructure(Value.absent(), "", true, (Parser<? extends Item>)Unicode.nullParser());
    }

    public static CsvStructureCol parsedCol(Value key, Parser<? extends Item> itemParser) {
        return new ParsedStructure(key, key.stringValue(""), false, itemParser);
    }

    public static CsvStructureCol parsedCol(String key, Parser<? extends Item> itemParser) {
        return new ParsedStructure((Value)Text.from((String)key), key, false, itemParser);
    }

    public static CsvStructureCol parsedCol(Parser<? extends Item> itemParser) {
        return new ParsedStructure(Value.absent(), "", false, itemParser);
    }
}

