/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.structure;

import java.util.Collection;
import swim.collections.FingerTrieSeq;
import swim.csv.schema.CsvCol;
import swim.csv.structure.CsvStructure;
import swim.csv.structure.CsvStructureCol;
import swim.csv.structure.CsvStructureHeader;
import swim.csv.structure.StringStructure;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Builder;

final class HeaderStructure
extends CsvStructureHeader {
    final FingerTrieSeq<CsvCol<? extends Item>> cols;

    HeaderStructure(FingerTrieSeq<CsvCol<? extends Item>> cols) {
        this.cols = cols;
    }

    public static HeaderStructure empty() {
        return new HeaderStructure((FingerTrieSeq<CsvCol<? extends Item>>)FingerTrieSeq.empty());
    }

    @Override
    public int colCount() {
        return this.cols.size();
    }

    @Override
    public CsvCol<? extends Item> getCol(int index) {
        return (CsvCol)this.cols.get(index);
    }

    @Override
    public CsvCol<? extends Item> overflowCol() {
        return CsvStructure.nullCol();
    }

    @Override
    public CsvStructureHeader col(int index, CsvCol<? extends Item> col) {
        FingerTrieSeq<CsvCol<? extends Item>> cols = this.cols;
        if (index < 0) {
            return new HeaderStructure((FingerTrieSeq<CsvCol<? extends Item>>)cols.prepended(col));
        }
        if (index >= cols.size()) {
            return new HeaderStructure((FingerTrieSeq<CsvCol<? extends Item>>)cols.appended(col));
        }
        return new HeaderStructure((FingerTrieSeq<CsvCol<? extends Item>>)cols.updated(index, col));
    }

    public CsvStructureHeader col(int index, String name) {
        FingerTrieSeq<CsvCol<? extends Item>> cols = this.cols;
        if (index < 0) {
            return new HeaderStructure((FingerTrieSeq<CsvCol<? extends Item>>)cols.prepended((Object)new StringStructure((Value)Text.from((String)name), name, false)));
        }
        if (index >= cols.size()) {
            return new HeaderStructure((FingerTrieSeq<CsvCol<? extends Item>>)cols.appended((Object)new StringStructure((Value)Text.from((String)name), name, false)));
        }
        return new HeaderStructure((FingerTrieSeq<CsvCol<? extends Item>>)cols.updated(index, ((CsvCol)cols.get(index)).name(name)));
    }

    @Override
    public CsvStructureHeader col(CsvCol<? extends Item> col) {
        return new HeaderStructure((FingerTrieSeq<CsvCol<? extends Item>>)this.cols.appended(col));
    }

    public CsvStructureHeader col(String name) {
        return new HeaderStructure((FingerTrieSeq<CsvCol<? extends Item>>)this.cols.appended((Object)new StringStructure((Value)Text.from((String)name), name, false)));
    }

    @Override
    public CsvStructureHeader cols(CsvStructureCol ... cols) {
        return new HeaderStructure((FingerTrieSeq<CsvCol<? extends Item>>)this.cols.appended((Collection)FingerTrieSeq.of((Object[])cols)));
    }

    @Override
    public Builder<Item, Value> rowBuilder() {
        return Record.create();
    }

    @Override
    public Builder<Value, Record> tableBuilder() {
        return Record.create();
    }
}

