/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.structure;

import swim.codec.Base10;
import swim.codec.Input;
import swim.codec.Parser;
import swim.structure.Item;
import swim.structure.Num;

final class NumberStructureParser
extends Parser<Item> {
    final Parser<Number> numberParser;
    final int step;

    NumberStructureParser(Parser<Number> numberParser, int step) {
        this.numberParser = numberParser;
        this.step = step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<Item> parse(Input input, Parser<Number> numberParser, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (c != 45 && (48 > c || c > 57)) return NumberStructureParser.done();
                step = 2;
            } else if (input.isDone()) {
                return NumberStructureParser.done();
            }
        }
        if (step == 2) {
            if (numberParser == null) {
                numberParser = Base10.parseNumber((Input)input);
            }
            while (numberParser.isCont() && !input.isEmpty()) {
                numberParser = numberParser.feed(input);
            }
            if (numberParser.isDone()) {
                return NumberStructureParser.done((Object)Num.from((Number)((Number)numberParser.bind())));
            }
            if (numberParser.isError()) {
                return numberParser.asError();
            }
        }
        if (!input.isError()) return new NumberStructureParser((Parser<Number>)numberParser, step);
        return NumberStructureParser.error((Throwable)input.trap());
    }

    public Parser<Item> feed(Input input) {
        return NumberStructureParser.parse(input, this.numberParser, this.step);
    }
}

