/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.parser;

import java.nio.ByteBuffer;
import swim.codec.Binary;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Utf8;
import swim.csv.parser.BodyParser;
import swim.csv.parser.HeaderParser;
import swim.csv.parser.RowParser;
import swim.csv.parser.TableParser;
import swim.csv.schema.CsvCol;
import swim.csv.schema.CsvHeader;

public class CsvParser {
    protected final int delimiter;

    public CsvParser(int delimiter) {
        this.delimiter = delimiter;
    }

    public final int delimiter() {
        return this.delimiter;
    }

    public boolean isDelimiter(int c) {
        return c == this.delimiter;
    }

    public <T, R, C> Parser<T> parseTable(CsvHeader<T, R, C> header, Input input) {
        return TableParser.parse(input, this, header);
    }

    public <T, R, C> Parser<CsvHeader<T, R, C>> parseHeader(CsvHeader<T, R, C> header, Input input) {
        return HeaderParser.parse(input, this, header);
    }

    public <T, R, C> Parser<T> parseBody(CsvHeader<T, R, C> header, Input input) {
        return BodyParser.parse(input, this, header);
    }

    public <T, R, C> Parser<R> parseRow(CsvHeader<T, R, C> header, Input input) {
        return RowParser.parse(input, this, header);
    }

    public <C> Parser<C> parseCell(CsvCol<C> col, Input input) {
        return col.parseCell(input);
    }

    public <T, R, C> Parser<T> tableParser(CsvHeader<T, R, C> header) {
        return new TableParser<T, R, C>(this, header);
    }

    public <T, R, C> Parser<CsvHeader<T, R, C>> headerParser(CsvHeader<T, R, C> header) {
        return new HeaderParser<T, R, C>(this, header);
    }

    public <T, R, C> Parser<T> bodyParser(CsvHeader<T, R, C> header) {
        return new BodyParser<T, R, C>(this, header);
    }

    public <T, R, C> Parser<R> rowParser(CsvHeader<T, R, C> header) {
        return new RowParser<T, R, C>(this, header);
    }

    public <T, R, C> T parseTableString(CsvHeader<T, R, C> header, String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseTable(header, input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (T)parser.bind();
    }

    public <T, R, C> T parseTableData(CsvHeader<T, R, C> header, byte[] data) {
        Input input = Utf8.decodedInput((Input)Binary.inputBuffer((byte[])data));
        Parser parser = this.parseTable(header, input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (T)parser.bind();
    }

    public <T, R, C> T parseTableBuffer(CsvHeader<T, R, C> header, ByteBuffer buffer) {
        Input input = Utf8.decodedInput((Input)Binary.inputBuffer((ByteBuffer)buffer));
        Parser parser = this.parseTable(header, input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (T)parser.bind();
    }

    public <T, R, C> T parseBodyString(CsvHeader<T, R, C> header, String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseBody(header, input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (T)parser.bind();
    }

    public <T, R, C> T parseBodyData(CsvHeader<T, R, C> header, byte[] data) {
        Input input = Utf8.decodedInput((Input)Binary.inputBuffer((byte[])data));
        Parser parser = this.parseBody(header, input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (T)parser.bind();
    }

    public <T, R, C> T parseBodyBuffer(CsvHeader<T, R, C> header, ByteBuffer buffer) {
        Input input = Utf8.decodedInput((Input)Binary.inputBuffer((ByteBuffer)buffer));
        Parser parser = this.parseBody(header, input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (T)parser.bind();
    }

    public <T, R, C> R parseRowString(CsvHeader<T, R, C> header, String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseRow(header, input);
        if (parser.isDone()) {
            while (input.isCont()) {
                int c = input.head();
                if (c != 13 && c != 10) continue;
                input = input.step();
            }
        }
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (R)parser.bind();
    }

    public <T, R, C> R parseRowData(CsvHeader<T, R, C> header, byte[] data) {
        Input input = Utf8.decodedInput((Input)Binary.inputBuffer((byte[])data));
        Parser parser = this.parseRow(header, input);
        if (parser.isDone()) {
            while (input.isCont()) {
                int c = input.head();
                if (c != 13 && c != 10) continue;
                input = input.step();
            }
        }
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (R)parser.bind();
    }

    public <T, R, C> R parseRowBuffer(CsvHeader<T, R, C> header, ByteBuffer buffer) {
        Input input = Utf8.decodedInput((Input)Binary.inputBuffer((ByteBuffer)buffer));
        Parser parser = this.parseRow(header, input);
        if (parser.isDone()) {
            while (input.isCont()) {
                int c = input.head();
                if (c != 13 && c != 10) continue;
                input = input.step();
            }
        }
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (R)parser.bind();
    }
}

