/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.structure;

import swim.codec.Input;
import swim.codec.Parser;
import swim.csv.structure.CsvStructureCol;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Builder;

final class ParsedStructure
implements CsvStructureCol {
    final Value key;
    final String name;
    final boolean optional;
    final Parser<? extends Item> itemParser;

    ParsedStructure(Value key, String name, boolean optional, Parser<? extends Item> itemParser) {
        this.key = key;
        this.name = name;
        this.optional = optional;
        this.itemParser = itemParser;
    }

    @Override
    public Value key() {
        return this.key;
    }

    @Override
    public CsvStructureCol key(Value key) {
        return new ParsedStructure(key, this.name, this.optional, this.itemParser);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CsvStructureCol name(String name) {
        return new ParsedStructure(this.key, name, this.optional, this.itemParser);
    }

    @Override
    public boolean optional() {
        return this.optional;
    }

    @Override
    public CsvStructureCol optional(boolean optional) {
        return new ParsedStructure(this.key, this.name, optional, this.itemParser);
    }

    @Override
    public Item defaultCell() {
        return Item.extant();
    }

    @Override
    public Parser<Item> parseCell(Input input) {
        return this.itemParser.feed(input);
    }

    @Override
    public void addCell(Item cell, Builder<Item, ?> rowBuilder) {
        if (!this.optional || cell instanceof Record && !((Record)cell).isEmpty() || cell != null && !(cell instanceof Record) && cell.isDefined()) {
            if (cell == null) {
                cell = this.defaultCell();
            }
            if (this.key.isDefined() && cell instanceof Value) {
                rowBuilder.add((Object)Slot.of((Value)this.key, (Value)((Value)cell)));
            } else {
                rowBuilder.add((Object)cell);
            }
        }
    }
}

