/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.parser;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.csv.parser.CsvInput;
import swim.csv.parser.CsvParser;
import swim.csv.parser.CsvQuotedInput;
import swim.csv.schema.CsvCol;
import swim.csv.schema.CsvHeader;
import swim.util.Builder;

final class RowParser<T, R, C>
extends Parser<R> {
    final CsvParser csv;
    final CsvHeader<T, R, C> header;
    final Builder<C, R> rowBuilder;
    final Parser<? extends C> cellParser;
    final int index;
    final int head;
    final int step;

    RowParser(CsvParser csv, CsvHeader<T, R, C> header, Builder<C, R> rowBuilder, Parser<? extends C> cellParser, int index, int head, int step) {
        this.csv = csv;
        this.header = header;
        this.rowBuilder = rowBuilder;
        this.cellParser = cellParser;
        this.index = index;
        this.head = head;
        this.step = step;
    }

    RowParser(CsvParser csv, CsvHeader<T, R, C> header) {
        this(csv, header, null, null, 0, -1, 1);
    }

    static <T, R, C> Parser<R> parse(Input input, CsvParser csv, CsvHeader<T, R, C> header, Builder<C, R> rowBuilder, Parser<? extends C> cellParser, int index, int head, int step) {
        block32: {
            block33: {
                int c = 0;
                while (true) {
                    CsvCol<Object> col;
                    Input cellInput;
                    if (step == 1) {
                        if (input.isCont()) {
                            c = input.head();
                            if (c == 13 || c == 10) {
                                if (rowBuilder == null) {
                                    rowBuilder = header.rowBuilder();
                                }
                                return RowParser.done((Object)rowBuilder.bind());
                            }
                            if (c == 34) {
                                input = input.step();
                                step = 3;
                            } else {
                                step = 2;
                            }
                        } else if (input.isDone()) {
                            step = 2;
                        }
                    }
                    if (step == 2) {
                        cellInput = new CsvInput(csv, input);
                        col = null;
                        if (cellParser == null) {
                            col = index < header.colCount() ? header.getCol(index) : header.overflowCol();
                            cellParser = csv.parseCell(col, cellInput);
                        }
                        while (cellParser.isCont() && !cellInput.isEmpty()) {
                            cellParser = cellParser.feed(cellInput);
                        }
                        if (cellParser.isDone()) {
                            if (col == null) {
                                col = index < header.colCount() ? header.getCol(index) : header.overflowCol();
                            }
                            if (rowBuilder == null) {
                                rowBuilder = header.rowBuilder();
                            }
                            col.addCell(cellParser.bind(), rowBuilder);
                            cellParser = null;
                            ++index;
                            step = 4;
                        } else if (cellParser.isError()) {
                            return cellParser.asError();
                        }
                    }
                    if (step == 3) {
                        cellInput = new CsvQuotedInput(34, input, head);
                        col = null;
                        if (cellParser == null) {
                            col = index < header.colCount() ? header.getCol(index) : header.overflowCol();
                            cellParser = csv.parseCell(col, cellInput);
                        }
                        while (cellParser.isCont() && !cellInput.isEmpty()) {
                            cellParser = cellParser.feed(cellInput);
                        }
                        if (cellInput instanceof CsvQuotedInput) {
                            head = ((CsvQuotedInput)cellInput).next();
                        }
                        if (head == -4) {
                            return RowParser.error((Diagnostic)Diagnostic.expected((int)34, (Input)input));
                        }
                        if (cellParser.isDone()) {
                            if (col == null) {
                                col = index < header.colCount() ? header.getCol(index) : header.overflowCol();
                            }
                            if (rowBuilder == null) {
                                rowBuilder = header.rowBuilder();
                            }
                            col.addCell(cellParser.bind(), rowBuilder);
                            cellParser = null;
                            head = -1;
                            ++index;
                            step = 4;
                        } else if (cellParser.isError()) {
                            return cellParser.asError();
                        }
                    }
                    if (step != 4) break block32;
                    if (!input.isCont()) break block33;
                    c = input.head();
                    if (c == 13 || c == 10) {
                        if (rowBuilder == null) {
                            rowBuilder = header.rowBuilder();
                        }
                        return RowParser.done((Object)rowBuilder.bind());
                    }
                    if (!csv.isDelimiter(c)) break;
                    input = input.step();
                    step = 1;
                }
                return RowParser.error((Diagnostic)Diagnostic.expected((String)"delimiter", (Input)input));
            }
            if (input.isDone()) {
                if (rowBuilder == null) {
                    rowBuilder = header.rowBuilder();
                }
                return RowParser.done((Object)rowBuilder.bind());
            }
        }
        if (input.isError()) {
            return RowParser.error((Throwable)input.trap());
        }
        return new RowParser<T, R, C>(csv, header, rowBuilder, cellParser, index, head, step);
    }

    static <T, R, C> Parser<R> parse(Input input, CsvParser csv, CsvHeader<T, R, C> header) {
        return RowParser.parse(input, csv, header, null, null, 0, -1, 1);
    }

    public Parser<R> feed(Input input) {
        return RowParser.parse(input, this.csv, this.header, this.rowBuilder, this.cellParser, this.index, this.head, this.step);
    }
}

