/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.parser;

import swim.codec.Input;
import swim.codec.InputException;
import swim.codec.InputSettings;
import swim.codec.Mark;
import swim.csv.parser.CsvParser;

final class CsvInput
extends Input {
    final CsvParser csv;
    Input input;

    CsvInput(CsvParser csv, Input input) {
        this.csv = csv;
        this.input = input;
    }

    boolean isDelimiter(int c) {
        return c == 13 || c == 10 || c == 34 || this.csv.isDelimiter(c);
    }

    public boolean isCont() {
        return this.input.isCont() && !this.isDelimiter(this.input.head());
    }

    public boolean isEmpty() {
        return this.input.isEmpty();
    }

    public boolean isDone() {
        return this.input.isDone() || this.input.isCont() && this.isDelimiter(this.input.head());
    }

    public boolean isError() {
        return this.input.isError();
    }

    public boolean isPart() {
        return this.input.isPart();
    }

    public Input isPart(boolean isPart) {
        return new CsvInput(this.csv, this.input.isPart(isPart));
    }

    public int head() {
        int head = this.input.head();
        if (!this.isDelimiter(head)) {
            return head;
        }
        throw new InputException();
    }

    public Input step() {
        int head = this.input.head();
        if (!this.isDelimiter(head)) {
            this.input = this.input.step();
            return this;
        }
        InputException error = new InputException("invalid step");
        return Input.error((Throwable)error, (Object)this.id(), (Mark)this.mark(), (InputSettings)this.settings());
    }

    public Input seek(Mark mark) {
        return new CsvInput(this.csv, this.input.seek(mark));
    }

    public Input fork(Object condition) {
        return new CsvInput(this.csv, this.input.fork(condition));
    }

    public Throwable trap() {
        return this.input.trap();
    }

    public Object id() {
        return this.input.id();
    }

    public Input id(Object id) {
        return new CsvInput(this.csv, this.input.id(id));
    }

    public Mark mark() {
        return this.input.mark();
    }

    public Input mark(Mark mark) {
        return new CsvInput(this.csv, this.input.mark(mark));
    }

    public long offset() {
        return this.input.offset();
    }

    public int line() {
        return this.input.line();
    }

    public int column() {
        return this.input.column();
    }

    public InputSettings settings() {
        return this.input.settings();
    }

    public Input settings(InputSettings settings) {
        return new CsvInput(this.csv, this.input.settings(settings));
    }

    public Input clone() {
        return new CsvInput(this.csv, this.input.clone());
    }
}

