/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.structure;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.csv.structure.CsvStructureCol;
import swim.structure.Item;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Builder;

final class StringStructure
implements CsvStructureCol {
    final Value key;
    final String name;
    final boolean optional;

    StringStructure(Value key, String name, boolean optional) {
        this.key = key;
        this.name = name;
        this.optional = optional;
    }

    @Override
    public Value key() {
        return this.key;
    }

    @Override
    public CsvStructureCol key(Value key) {
        return new StringStructure(key, this.name, this.optional);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CsvStructureCol name(String name) {
        return new StringStructure(this.key, name, this.optional);
    }

    @Override
    public boolean optional() {
        return this.optional;
    }

    @Override
    public CsvStructureCol optional(boolean optional) {
        return new StringStructure(this.key, this.name, optional);
    }

    @Override
    public Item defaultCell() {
        return Text.from((String)"");
    }

    @Override
    public Parser<Item> parseCell(Input input) {
        return Unicode.parseOutput((Input)input, (Output)Text.output());
    }

    @Override
    public void addCell(Item cell, Builder<Item, ?> rowBuilder) {
        if (!this.optional || cell instanceof Text && ((Text)cell).size() != 0) {
            if (cell == null) {
                cell = this.defaultCell();
            }
            if (this.key.isDefined() && cell instanceof Value) {
                rowBuilder.add((Object)Slot.of((Value)this.key, (Value)((Value)cell)));
            } else {
                rowBuilder.add((Object)cell);
            }
        }
    }
}

