/*
 * Decompiled with CFR 0.152.
 */
package swim.csv.parser;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.csv.parser.CsvParser;
import swim.csv.schema.CsvHeader;
import swim.util.Builder;

final class BodyParser<T, R, C>
extends Parser<T> {
    final CsvParser csv;
    final CsvHeader<T, R, C> header;
    final Builder<R, T> tableBuilder;
    final Parser<R> rowParser;
    final int step;

    BodyParser(CsvParser csv, CsvHeader<T, R, C> header, Builder<R, T> tableBuilder, Parser<R> rowParser, int step) {
        this.csv = csv;
        this.header = header;
        this.rowParser = rowParser;
        this.tableBuilder = tableBuilder;
        this.step = step;
    }

    BodyParser(CsvParser csv, CsvHeader<T, R, C> header) {
        this(csv, header, null, null, 1);
    }

    public Parser<T> feed(Input input) {
        return BodyParser.parse(input, this.csv, this.header, this.tableBuilder, this.rowParser, this.step);
    }

    /*
     * Enabled aggressive block sorting
     */
    static <T, R, C> Parser<T> parse(Input input, CsvParser csv, CsvHeader<T, R, C> header, Builder<R, T> tableBuilder, Parser<R> rowParser, int step) {
        int c = 0;
        while (true) {
            block21: {
                if (step == 1) {
                    if (input.isCont()) {
                        step = 2;
                    } else if (input.isDone()) {
                        if (tableBuilder == null) {
                            tableBuilder = header.tableBuilder();
                        }
                        return Parser.done((Object)tableBuilder.bind());
                    }
                }
                if (step == 2) {
                    if (rowParser == null) {
                        rowParser = csv.parseRow(input, header);
                    }
                    while (rowParser.isCont() && !input.isEmpty()) {
                        rowParser = rowParser.feed(input);
                    }
                    if (rowParser.isDone()) {
                        if (tableBuilder == null) {
                            tableBuilder = header.tableBuilder();
                        }
                        tableBuilder.add(rowParser.bind());
                        rowParser = null;
                        step = 3;
                    } else if (rowParser.isError()) {
                        return rowParser.asError();
                    }
                }
                if (step == 3) {
                    if (input.isCont()) {
                        c = input.head();
                        if (c == 13) {
                            input = input.step();
                            step = 4;
                            break block21;
                        } else {
                            if (c != 10) {
                                return Parser.error((Diagnostic)Diagnostic.expected((String)"carriage return or line feed", (Input)input));
                            }
                            input = input.step();
                            step = 1;
                            continue;
                        }
                    }
                    if (input.isDone()) {
                        step = 1;
                        continue;
                    }
                }
            }
            if (step != 4) break;
            if (input.isCont() && input.head() == 10) {
                input = input.step();
                step = 1;
                continue;
            }
            if (input.isEmpty()) break;
            step = 1;
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new BodyParser<T, R, C>(csv, header, tableBuilder, rowParser, step);
    }

    static <T, R, C> Parser<T> parse(Input input, CsvParser csv, CsvHeader<T, R, C> header) {
        return BodyParser.parse(input, csv, header, null, null, 1);
    }
}

