/*
 * Decompiled with CFR 0.152.
 */
package swim.dataflow;

import java.util.Iterator;
import swim.collections.HashTrieMap;
import swim.dataflow.AbstractRecordOutlet;
import swim.dataflow.Dataflow;
import swim.dataflow.RecordFieldUpdater;
import swim.dataflow.RecordScope;
import swim.dataflow.RecordStreamlet;
import swim.dataflow.Transmuter;
import swim.streamlet.KeyEffect;
import swim.streamlet.MapOutlet;
import swim.streamlet.Outlet;
import swim.streamlet.StreamletScope;
import swim.structure.Field;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;
import swim.structure.func.MathModule;

public class RecordModel
extends AbstractRecordOutlet {
    protected Record state;
    protected HashTrieMap<Value, RecordFieldUpdater> fieldUpdaters;

    public RecordModel(Record state) {
        this.state = state;
        this.fieldUpdaters = HashTrieMap.empty();
    }

    public RecordModel() {
        this(Record.create());
    }

    public static RecordModel from(Record record) {
        RecordModel model = new RecordModel();
        model.materialize(record);
        model.compile(record);
        return model;
    }

    public static RecordModel of() {
        return new RecordModel();
    }

    public static RecordModel of(Object object) {
        return RecordModel.from(Record.of((Object)object));
    }

    public static RecordModel of(Object ... objects) {
        return RecordModel.from(Record.of((Object[])objects));
    }

    public static RecordModel globalScope() {
        RecordModel model = new RecordModel();
        model.materializeField((Field)Slot.of((String)"math", (Value)MathModule.scope().branch()));
        return model;
    }

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public boolean isArray() {
        return this.state.isArray();
    }

    public boolean isObject() {
        return this.state.isObject();
    }

    public int size() {
        return this.state.size();
    }

    public int fieldCount() {
        return this.state.fieldCount();
    }

    public int valueCount() {
        return this.state.valueCount();
    }

    public boolean containsKey(Value key) {
        if (this.state.containsKey(key)) {
            return true;
        }
        StreamletScope<? extends Value> scope = this.streamletScope();
        return scope instanceof Record ? ((Record)scope).containsKey(key) : false;
    }

    @Override
    public boolean containsOwnKey(Value key) {
        return this.state.containsKey(key);
    }

    public int indexOf(Object item) {
        return this.state.indexOf(item);
    }

    public int lastIndexOf(Object item) {
        return this.state.lastIndexOf(item);
    }

    public Value get(Value key) {
        StreamletScope<? extends Value> scope;
        Value value = this.state.get(key);
        if (!value.isDefined() && (scope = this.streamletScope()) instanceof Record) {
            value = ((Record)scope).get(key);
        }
        return value;
    }

    public Value getAttr(Text key) {
        StreamletScope<? extends Value> scope;
        Value value = this.state.getAttr(key);
        if (!value.isDefined() && (scope = this.streamletScope()) instanceof Record) {
            value = ((Record)scope).getAttr(key);
        }
        return value;
    }

    public Value getSlot(Value key) {
        StreamletScope<? extends Value> scope;
        Value value = this.state.getSlot(key);
        if (!value.isDefined() && (scope = this.streamletScope()) instanceof Record) {
            value = ((Record)scope).getSlot(key);
        }
        return value;
    }

    public Field getField(Value key) {
        StreamletScope<? extends Value> scope;
        Field field = this.state.getField(key);
        if (field == null && (scope = this.streamletScope()) instanceof Record) {
            field = ((Record)scope).getField(key);
        }
        return field;
    }

    public Item get(int index) {
        return this.state.get(index);
    }

    public Item getItem(int index) {
        return this.state.getItem(index);
    }

    public void bindValue(Value key, Value expr) {
        RecordFieldUpdater fieldUpdater = new RecordFieldUpdater(this, key);
        Outlet<Value> valueInput = Dataflow.compile(expr, this);
        fieldUpdater.bindInput(valueInput);
        this.fieldUpdaters = this.fieldUpdaters.updated((Object)key, (Object)fieldUpdater);
    }

    public Value put(Value key, Value newValue) {
        StreamletScope<? extends Value> scope;
        Value oldValue = !this.state.containsKey(key) ? ((scope = this.streamletScope()) instanceof Record && ((Record)scope).containsKey(key) ? ((Record)scope).put(key, newValue) : this.state.put(key, newValue)) : this.state.put(key, newValue);
        this.invalidateInputKey(key, KeyEffect.UPDATE);
        return oldValue;
    }

    public Value put(String key, Value newValue) {
        return this.put((Value)Text.from((String)key), newValue);
    }

    public Value putAttr(Text key, Value newValue) {
        StreamletScope<? extends Value> scope;
        Value oldValue = !this.state.containsKey((Value)key) ? ((scope = this.streamletScope()) instanceof Record && ((Record)scope).containsKey((Value)key) ? ((Record)scope).putAttr(key, newValue) : this.state.putAttr(key, newValue)) : this.state.putAttr(key, newValue);
        this.invalidateInputKey((Value)key, KeyEffect.UPDATE);
        return oldValue;
    }

    public Value putAttr(String key, Value newValue) {
        return this.putAttr(Text.from((String)key), newValue);
    }

    public Value putSlot(Value key, Value newValue) {
        StreamletScope<? extends Value> scope;
        Value oldValue = !this.state.containsKey(key) ? ((scope = this.streamletScope()) instanceof Record && ((Record)scope).containsKey(key) ? ((Record)scope).putSlot(key, newValue) : this.state.putSlot(key, newValue)) : this.state.putSlot(key, newValue);
        this.invalidateInputKey(key, KeyEffect.UPDATE);
        return oldValue;
    }

    public Value putSlot(String key, Value newValue) {
        return this.putSlot((Value)Text.from((String)key), newValue);
    }

    public Item setItem(int index, Item newItem) {
        Item oldItem = this.state.setItem(index, newItem);
        if (oldItem instanceof Field && newItem instanceof Field) {
            if (oldItem.key().equals((Object)newItem.key())) {
                this.invalidateInputKey(oldItem.key(), KeyEffect.UPDATE);
            } else {
                this.invalidateInputKey(oldItem.key(), KeyEffect.REMOVE);
                this.invalidateInputKey(newItem.key(), KeyEffect.UPDATE);
            }
        } else if (oldItem instanceof Field) {
            this.invalidateInputKey(oldItem.key(), KeyEffect.REMOVE);
        } else if (newItem instanceof Field) {
            this.invalidateInputKey(newItem.key(), KeyEffect.UPDATE);
        } else {
            this.invalidateInput();
        }
        return oldItem;
    }

    public boolean add(Item item) {
        this.state.add(item);
        if (item instanceof Field) {
            this.invalidateInputKey(item.key(), KeyEffect.UPDATE);
        }
        return true;
    }

    public void add(int index, Item item) {
        this.state.add(index, item);
        if (item instanceof Field) {
            this.invalidateInputKey(item.key(), KeyEffect.UPDATE);
        }
    }

    public Item remove(int index) {
        Item oldItem = this.state.remove(index);
        if (oldItem instanceof Field) {
            this.invalidateInputKey(oldItem.key(), KeyEffect.REMOVE);
        }
        return oldItem;
    }

    public void clear() {
        Record oldState = this.state.branch();
        this.state.clear();
        for (Item oldItem : oldState) {
            if (!(oldItem instanceof Field)) continue;
            this.invalidateInputKey(oldItem.key(), KeyEffect.REMOVE);
        }
    }

    public Record subList(int fromIndex, int toIndex) {
        return this.state.subList(fromIndex, toIndex);
    }

    @Override
    public final Iterator<Value> keyIterator() {
        return this.state.keyIterator();
    }

    @Override
    public void disconnectInputs() {
        HashTrieMap<Value, RecordFieldUpdater> fieldUpdaters = this.fieldUpdaters;
        if (!fieldUpdaters.isEmpty()) {
            this.fieldUpdaters = HashTrieMap.empty();
            Iterator inlets = fieldUpdaters.valueIterator();
            while (inlets.hasNext()) {
                RecordFieldUpdater inlet = (RecordFieldUpdater)((Object)inlets.next());
                inlet.disconnectInputs();
            }
        }
    }

    public MapOutlet<Value, Value, Record> memoize() {
        return this;
    }

    public void materialize(Record record) {
        for (Item item : record) {
            this.materializeItem(item);
        }
    }

    public void materializeItem(Item item) {
        if (item instanceof Field) {
            this.materializeField((Field)item);
        } else {
            this.materializeValue((Value)item);
        }
    }

    public void materializeField(Field field) {
        Value value = field.value();
        if (value instanceof RecordStreamlet) {
            ((RecordStreamlet)value).setStreamletScope(this);
            this.state.add((Item)field);
        } else if (value instanceof Record) {
            RecordScope child = new RecordScope(this);
            child.materialize((Record)value);
            this.state.add((Item)field.updatedValue((Value)child));
        } else {
            this.state.add((Item)field);
        }
    }

    public void materializeValue(Value value) {
        if (value instanceof RecordStreamlet) {
            ((RecordStreamlet)value).setStreamletScope(this);
            this.state.add((Item)value);
        } else if (value instanceof Record) {
            RecordScope child = new RecordScope(this);
            child.materialize((Record)value);
            this.state.add((Item)child);
        } else {
            this.state.add((Item)value);
        }
    }

    public void compile(Record record) {
        int index = 0;
        for (Item item : record) {
            this.compileItem(item, index);
            ++index;
        }
    }

    public void compileItem(Item item, int index) {
        if (item instanceof Field) {
            this.compileField((Field)item, index);
        } else {
            this.compileValue((Value)item, index);
        }
    }

    public void compileField(Field field, int index) {
        Value key = field.key();
        Value value = field.value();
        if (key.isConstant()) {
            if (!value.isConstant()) {
                if (value instanceof RecordStreamlet) {
                    ((RecordStreamlet)value).compile();
                    this.invalidateInputKey(key, KeyEffect.UPDATE);
                } else if (value instanceof Record) {
                    ((RecordModel)this.state.getItem(index).toValue()).compile((Record)value);
                    this.invalidateInputKey(key, KeyEffect.UPDATE);
                } else {
                    field.setValue(Value.extant());
                    this.bindValue(key, value);
                }
            } else {
                this.invalidateInputKey(key, KeyEffect.UPDATE);
            }
        }
    }

    public void compileValue(Value value, int index) {
        if (value instanceof RecordStreamlet) {
            ((RecordStreamlet)value).compile();
        } else if (value instanceof Record) {
            ((RecordModel)this.state.getItem(index)).compile((Record)value);
        } else if (!value.isConstant()) {
            // empty if block
        }
    }

    public void transmute(Transmuter transmuter) {
        int index = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Item newItem;
            Item oldItem = (Item)iterator.next();
            if (oldItem != (newItem = this.transmuteItem(oldItem, transmuter))) {
                this.setItem(index, newItem);
            }
            ++index;
        }
    }

    public void transmute() {
        this.transmute(Transmuter.system());
    }

    public Item transmuteItem(Item item, Transmuter transmuter) {
        if (item instanceof Field) {
            return this.transmuteField((Field)item, transmuter);
        }
        return this.transmuteValue((Value)item, transmuter);
    }

    public Field transmuteField(Field field, Transmuter transmuter) {
        Value newValue;
        Value oldValue = field.value();
        if (oldValue != (newValue = this.transmuteValue(oldValue, transmuter))) {
            return field.updatedValue(newValue);
        }
        return field;
    }

    public Value transmuteValue(Value oldValue, Transmuter transmuter) {
        if (oldValue instanceof RecordModel) {
            Record newValue = this.transmuteModel((RecordModel)oldValue);
            if (oldValue == newValue && transmuter != null) {
                newValue = transmuter.transmute((RecordModel)oldValue);
            }
            return newValue;
        }
        return oldValue;
    }

    public Record transmuteModel(RecordModel model) {
        StreamletScope<? extends Value> scope = this.streamletScope();
        if (scope instanceof RecordModel) {
            return ((RecordModel)scope).transmuteModel(model);
        }
        return model;
    }
}

