/*
 * Decompiled with CFR 0.152.
 */
package swim.dataflow;

import java.util.Iterator;
import swim.collections.HashTrieMap;
import swim.dataflow.RecordOutlet;
import swim.dataflow.RecordStreamlet;
import swim.streamlet.Inlet;
import swim.streamlet.KeyEffect;
import swim.streamlet.KeyOutlet;
import swim.streamlet.MapInlet;
import swim.streamlet.MapOutlet;
import swim.streamlet.Outlet;
import swim.streamlet.StreamletContext;
import swim.streamlet.StreamletScope;
import swim.structure.Field;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Cursor;

public abstract class AbstractRecordOutlet
extends Record
implements RecordOutlet {
    protected HashTrieMap<Value, KeyEffect> effects = HashTrieMap.empty();
    protected HashTrieMap<Value, KeyOutlet<Value, Value>> outlets = HashTrieMap.empty();
    protected Inlet<? super Record>[] outputs = null;
    protected int version = -1;

    public StreamletScope<? extends Value> streamletScope() {
        return null;
    }

    public StreamletContext streamletContext() {
        StreamletScope<? extends Value> scope = this.streamletScope();
        if (scope != null) {
            return scope.streamletContext();
        }
        return null;
    }

    public boolean containsOwnKey(Value key) {
        return this.containsKey(key);
    }

    public abstract Iterator<Value> keyIterator();

    public Record get() {
        return this;
    }

    @Override
    public Outlet<Value> outlet(Value key) {
        StreamletScope<? extends Value> scope;
        if (!this.containsOwnKey(key) && (scope = this.streamletScope()) instanceof RecordOutlet && ((RecordOutlet)scope).containsKey(key)) {
            return ((RecordOutlet)scope).outlet(key);
        }
        KeyOutlet outlet = (KeyOutlet)this.outlets.get((Object)key);
        if (outlet == null) {
            outlet = new KeyOutlet((MapOutlet)this, (Object)key);
            this.outlets = this.outlets.updated((Object)key, (Object)outlet);
            this.invalidateInputKey(key, KeyEffect.UPDATE);
        }
        return outlet;
    }

    @Override
    public Outlet<Value> outlet(String key) {
        return this.outlet((Value)Text.from((String)key));
    }

    public Iterator<Inlet<? super Record>> outputIterator() {
        return this.outputs != null ? Cursor.array((Object[])this.outputs) : Cursor.empty();
    }

    public void bindOutput(Inlet<? super Record> output) {
        Inlet<? super Record>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        Inlet[] newOutputs = new Inlet[n + 1];
        if (n > 0) {
            System.arraycopy(oldOutputs, 0, newOutputs, 0, n);
        }
        newOutputs[n] = output;
        this.outputs = newOutputs;
    }

    public void unbindOutput(Inlet<? super Record> output) {
        Inlet<? super Record>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        for (int i = 0; i < n; ++i) {
            if (oldOutputs[i] != output) continue;
            if (n > 1) {
                Inlet[] newOutputs = new Inlet[n - 1];
                System.arraycopy(oldOutputs, 0, newOutputs, 0, i);
                System.arraycopy(oldOutputs, i + 1, newOutputs, i, n - 1 - i);
                this.outputs = newOutputs;
                break;
            }
            this.outputs = null;
            break;
        }
    }

    public void unbindOutputs() {
        Inlet<? super Record>[] oldOutputs;
        HashTrieMap<Value, KeyOutlet<Value, Value>> outlets = this.outlets;
        if (!outlets.isEmpty()) {
            this.outlets = HashTrieMap.empty();
            Iterator keyOutlets = outlets.valueIterator();
            while (keyOutlets.hasNext()) {
                KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                keyOutlet.unbindOutputs();
            }
        }
        if ((oldOutputs = this.outputs) != null) {
            this.outputs = null;
            int n = oldOutputs.length;
            for (int i = 0; i < n; ++i) {
                oldOutputs[i].unbindInput();
            }
        }
    }

    public void disconnectOutputs() {
        Inlet<? super Record>[] outputs;
        HashTrieMap<Value, KeyOutlet<Value, Value>> outlets = this.outlets;
        if (!outlets.isEmpty()) {
            this.outlets = HashTrieMap.empty();
            Iterator keyOutlets = outlets.valueIterator();
            while (keyOutlets.hasNext()) {
                KeyOutlet keyOutlet = (KeyOutlet)keyOutlets.next();
                keyOutlet.disconnectOutputs();
            }
        }
        if ((outputs = this.outputs) != null) {
            this.outputs = null;
            for (Inlet<? super Record> output : outputs) {
                output.unbindInput();
                output.disconnectOutputs();
            }
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Item member = (Item)iterator.next();
            if (member instanceof Field) {
                member = member.toValue();
            }
            if (member instanceof RecordOutlet) {
                ((RecordOutlet)member).disconnectOutputs();
                continue;
            }
            if (!(member instanceof RecordStreamlet)) continue;
            ((RecordStreamlet)member).disconnectOutputs();
        }
    }

    public void disconnectInputs() {
    }

    public void invalidateInputKey(Value key, KeyEffect effect) {
        HashTrieMap<Value, KeyEffect> oldEffects = this.effects;
        if (oldEffects.get((Object)key) != effect) {
            this.willInvalidateInputKey(key, effect);
            this.effects = oldEffects.updated((Object)key, (Object)effect);
            this.version = -1;
            this.onInvalidateInputKey(key, effect);
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<? super Record> output = this.outputs[i];
                if (output instanceof MapInlet) {
                    ((MapInlet)output).invalidateOutputKey((Object)key, effect);
                    continue;
                }
                output.invalidateOutput();
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get((Object)key);
            if (outlet != null) {
                outlet.invalidateInput();
            }
            this.didInvalidateInputKey(key, effect);
        }
    }

    public void invalidateInput() {
        if (this.version >= 0) {
            this.willInvalidateInput();
            this.version = -1;
            this.onInvalidateInput();
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].invalidateOutput();
            }
            Iterator outlets = this.outlets.valueIterator();
            while (outlets.hasNext()) {
                ((KeyOutlet)outlets.next()).invalidateInput();
            }
            this.didInvalidateInput();
        }
    }

    public void reconcileInputKey(Value key, int version) {
        HashTrieMap<Value, KeyEffect> oldEffects;
        KeyEffect effect;
        if (this.version < 0 && (effect = (KeyEffect)(oldEffects = this.effects).get((Object)key)) != null) {
            int n;
            this.willReconcileInputKey(key, effect, version);
            this.effects = oldEffects.removed((Object)key);
            this.onReconcileInputKey(key, effect, version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                Inlet<? super Record> output = this.outputs[i];
                if (!(output instanceof MapInlet)) continue;
                ((MapInlet)output).reconcileOutputKey((Object)key, version);
            }
            KeyOutlet outlet = (KeyOutlet)this.outlets.get((Object)key);
            if (outlet != null) {
                outlet.reconcileInput(version);
            }
            this.didReconcileInputKey(key, effect, version);
        }
    }

    public void reconcileInput(int version) {
        if (this.version < 0) {
            int n;
            this.willReconcileInput(version);
            Iterator keys = this.effects.keyIterator();
            while (keys.hasNext()) {
                this.reconcileInputKey((Value)keys.next(), version);
            }
            this.version = version;
            this.onReconcileInput(version);
            int n2 = n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].reconcileOutput(version);
            }
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Item member = (Item)iterator.next();
                if (member instanceof Field) {
                    member = member.toValue();
                }
                if (member instanceof RecordOutlet) {
                    ((RecordOutlet)member).reconcileInput(version);
                    continue;
                }
                if (!(member instanceof RecordStreamlet)) continue;
                ((RecordStreamlet)member).reconcile(version);
            }
            this.didReconcileInput(version);
        }
    }

    protected void willInvalidateInputKey(Value key, KeyEffect effect) {
    }

    protected void onInvalidateInputKey(Value key, KeyEffect effect) {
    }

    protected void didInvalidateInputKey(Value key, KeyEffect effect) {
    }

    protected void willInvalidateInput() {
    }

    protected void onInvalidateInput() {
    }

    protected void didInvalidateInput() {
    }

    protected void willReconcileInputKey(Value key, KeyEffect effect, int version) {
    }

    protected void onReconcileInputKey(Value key, KeyEffect effect, int version) {
    }

    protected void didReconcileInputKey(Value key, KeyEffect effect, int version) {
    }

    protected void willReconcileInput(int version) {
    }

    protected void onReconcileInput(int version) {
    }

    protected void didReconcileInput(int version) {
    }
}

