/*
 * Decompiled with CFR 0.152.
 */
package swim.dataflow;

import java.lang.reflect.Field;
import java.util.Map;
import swim.dataflow.RecordStreamlet;
import swim.streamlet.AbstractStreamlet;
import swim.streamlet.GenericStreamlet;
import swim.streamlet.In;
import swim.streamlet.Inlet;
import swim.streamlet.Inout;
import swim.streamlet.Inoutlet;
import swim.streamlet.Outlet;
import swim.streamlet.Streamlet;
import swim.streamlet.StreamletContext;
import swim.streamlet.StreamletInlet;
import swim.streamlet.StreamletInoutlet;
import swim.streamlet.StreamletOutlet;
import swim.streamlet.StreamletScope;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;

public abstract class AbstractRecordStreamlet<I extends Value, O extends Value>
extends RecordStreamlet<I, O>
implements GenericStreamlet<I, O> {
    protected StreamletScope<? extends O> scope;
    protected StreamletContext context;
    protected int version;

    public AbstractRecordStreamlet(StreamletScope<? extends O> scope) {
        this.scope = scope;
        this.version = -1;
    }

    public AbstractRecordStreamlet() {
        this(null);
    }

    public StreamletScope<? extends O> streamletScope() {
        return this.scope;
    }

    public void setStreamletScope(StreamletScope<? extends O> scope) {
        this.scope = scope;
    }

    public StreamletContext streamletContext() {
        if (this.context != null) {
            return this.context;
        }
        StreamletScope<O> scope = this.streamletScope();
        if (scope != null) {
            return scope.streamletContext();
        }
        return null;
    }

    public void setStreamletContext(StreamletContext context) {
        this.context = context;
    }

    public boolean isEmpty() {
        return this.size() != 0;
    }

    public int size() {
        return AbstractStreamlet.reflectOutletCount(((Object)((Object)this)).getClass());
    }

    public boolean containsKey(Value key) {
        if (!(key instanceof Text)) {
            return false;
        }
        Outlet<O> outlet = this.outlet(((Text)key).stringValue());
        return outlet != null;
    }

    public boolean containsKey(String key) {
        Outlet<O> outlet = this.outlet(key);
        return outlet != null;
    }

    public Value get(Value key) {
        Value output;
        if (!(key instanceof Text)) {
            return Value.absent();
        }
        Outlet<O> outlet = this.outlet(((Text)key).stringValue());
        if (outlet != null && (output = (Value)outlet.get()) != null) {
            return output;
        }
        return Value.absent();
    }

    public Value get(String key) {
        Value output;
        Outlet<O> outlet = this.outlet(key);
        if (outlet != null && (output = (Value)outlet.get()) != null) {
            return output;
        }
        return Value.absent();
    }

    public Value getAttr(Text key) {
        return Value.absent();
    }

    public Value getAttr(String key) {
        return Value.absent();
    }

    public Value getSlot(Value key) {
        return this.get(key);
    }

    public Value getSlot(String key) {
        return this.get(key);
    }

    public swim.structure.Field getField(Value key) {
        Value value = this.get(key);
        if (value.isDefined()) {
            return Slot.of((Value)key, (Value)value);
        }
        return null;
    }

    public swim.structure.Field getField(String key) {
        Value value = this.get(key);
        if (value.isDefined()) {
            return Slot.of((String)key, (Value)value);
        }
        return null;
    }

    public Item get(int index) {
        Map.Entry entry = AbstractStreamlet.reflectOutletIndex((int)index, (Streamlet)this, ((Object)((Object)this)).getClass());
        if (entry != null) {
            String name = (String)entry.getKey();
            Value output = (Value)((Outlet)entry.getValue()).get();
            if (output != null) {
                return Slot.of((String)name, (Value)output);
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    public Item getItem(int index) {
        Map.Entry entry = AbstractStreamlet.reflectOutletIndex((int)index, (Streamlet)this, ((Object)((Object)this)).getClass());
        if (entry != null) {
            String name = (String)entry.getKey();
            Value output = (Value)((Outlet)entry.getValue()).get();
            if (output == null) {
                output = Value.extant();
            }
            return Slot.of((String)name, (Value)output);
        }
        return Item.absent();
    }

    public Value put(Value key, Value newValue) {
        throw new UnsupportedOperationException();
    }

    public Value put(String key, Value newValue) {
        throw new UnsupportedOperationException();
    }

    public Value putAttr(Text key, Value newValue) {
        throw new UnsupportedOperationException();
    }

    public Value putAttr(String key, Value newValue) {
        throw new UnsupportedOperationException();
    }

    public Value putSlot(Value key, Value newValue) {
        throw new UnsupportedOperationException();
    }

    public Value putSlot(String key, Value newValue) {
        throw new UnsupportedOperationException();
    }

    public Item setItem(int index, Item item) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Item item) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Item item) {
        throw new UnsupportedOperationException();
    }

    public Item remove(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean removeKey(Value key) {
        throw new UnsupportedOperationException();
    }

    public boolean removeKey(String key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Inlet<I> inlet(String key) {
        return AbstractStreamlet.reflectInletKey((String)key, (Streamlet)this, ((Object)((Object)this)).getClass());
    }

    protected <I2 extends I> Inlet<I2> inlet() {
        return new StreamletInlet((Streamlet)this);
    }

    public void bindInput(String key, Outlet<? extends I> input) {
        Inlet<I> inlet = this.inlet(key);
        if (inlet == null) {
            throw new IllegalArgumentException(key.toString());
        }
        inlet.bindInput(input);
    }

    public void unbindInput(String key) {
        Inlet<I> inlet = this.inlet(key);
        if (inlet == null) {
            throw new IllegalArgumentException(key.toString());
        }
        inlet.unbindInput();
    }

    public Outlet<O> outlet(String key) {
        return AbstractStreamlet.reflectOutletKey((String)key, (Streamlet)this, ((Object)((Object)this)).getClass());
    }

    protected <O2 extends Value> Outlet<O2> outlet() {
        return new StreamletOutlet((Streamlet)this);
    }

    protected <I2 extends I, O2> Inoutlet<I2, O2> inoutlet() {
        return new StreamletInoutlet((Streamlet)this);
    }

    public void decohere() {
        if (this.version >= 0) {
            this.willDecohere();
            this.version = -1;
            this.onDecohere();
            this.onDecohereOutlets();
            this.didDecohere();
        }
    }

    public void recohere(int version) {
        if (this.version < 0) {
            this.willRecohere(version);
            this.version = version;
            this.onRecohereInlets(version);
            this.onRecohere(version);
            this.onRecohereOutlets(version);
            this.didRecohere(version);
        }
    }

    public <I2 extends I> I2 getInput(Inlet<I2> inlet) {
        Outlet input = inlet.input();
        if (input != null) {
            return (I2)((Value)input.get());
        }
        return null;
    }

    public <I2 extends I> I2 getInput(String key) {
        Inlet<I> inlet = this.inlet(key);
        if (inlet != null) {
            return (I2)this.getInput(inlet);
        }
        return null;
    }

    public <I2 extends I> I2 getInput(Inlet<I2> inlet, I2 orElse) {
        I2 input = this.getInput(inlet);
        if (input == null) {
            input = orElse;
        }
        return input;
    }

    public <I2 extends I> I2 getInput(String key, I2 orElse) {
        I2 input = this.getInput(key);
        if (input == null) {
            input = orElse;
        }
        return input;
    }

    public <T> T castInput(Inlet<? extends I> inlet, Form<T> form) {
        I input = this.getInput(inlet);
        Object object = null;
        if (input != null) {
            object = form.cast(input);
        }
        return (T)object;
    }

    public <T> T castInput(String key, Form<T> form) {
        Object input = this.getInput(key);
        Object object = null;
        if (input != null) {
            object = form.cast(input);
        }
        return (T)object;
    }

    public <T> T castInput(Inlet<? extends I> inlet, Form<T> form, T orElse) {
        I input = this.getInput(inlet);
        Object object = null;
        if (input != null) {
            object = form.cast(input);
        }
        if (object == null) {
            object = orElse;
        }
        return (T)object;
    }

    public <T> T castInput(String key, Form<T> form, T orElse) {
        Object input = this.getInput(key);
        Object object = null;
        if (input != null) {
            object = form.cast(input);
        }
        if (object == null) {
            object = orElse;
        }
        return (T)object;
    }

    public <T> T coerceInput(Inlet<? extends I> inlet, Form<T> form) {
        I input = this.getInput(inlet);
        Object object = null;
        if (input != null) {
            object = form.cast(input);
        }
        if (object == null) {
            object = form.unit();
        }
        return (T)object;
    }

    public <T> T coerceInput(String key, Form<T> form) {
        Object input = this.getInput(key);
        Object object = null;
        if (input != null) {
            object = form.cast(input);
        }
        if (object == null) {
            object = form.unit();
        }
        return (T)object;
    }

    public <T> T coerceInput(Inlet<? extends I> inlet, Form<T> form, T orElse) {
        I input = this.getInput(inlet);
        Object object = null;
        if (input != null) {
            object = form.cast(input);
        }
        if (object == null) {
            object = form.unit();
        }
        if (object == null) {
            object = orElse;
        }
        return (T)object;
    }

    public <T> T coerceInput(String key, Form<T> form, T orElse) {
        Object input = this.getInput(key);
        Object object = null;
        if (input != null) {
            object = form.cast(input);
        }
        if (object == null) {
            object = form.unit();
        }
        if (object == null) {
            object = orElse;
        }
        return (T)object;
    }

    public O getOutput(Outlet<? super O> outlet) {
        return null;
    }

    public O getOutput(String key) {
        Outlet<O> outlet = this.outlet(key);
        if (outlet != null) {
            return this.getOutput((Outlet<? super O>)outlet);
        }
        return null;
    }

    public void disconnectInputs() {
        AbstractStreamlet.disconnectInputs((Streamlet)this, ((Object)((Object)this)).getClass());
    }

    public void disconnectOutputs() {
        AbstractStreamlet.disconnectOutputs((Streamlet)this, ((Object)((Object)this)).getClass());
    }

    public void willDecohereInlet(Inlet<? extends I> inlet) {
    }

    public void didDecohereInlet(Inlet<? extends I> inlet) {
        this.decohere();
    }

    public void willRecohereInlet(Inlet<? extends I> inlet, int version) {
    }

    public void didRecohereInlet(Inlet<? extends I> inlet, int version) {
        this.recohere(version);
    }

    public void willDecohereOutlet(Outlet<? super O> outlet) {
    }

    public void didDecohereOutlet(Outlet<? super O> outlet) {
    }

    public void willRecohereOutlet(Outlet<? super O> outlet, int version) {
    }

    public void didRecohereOutlet(Outlet<? super O> outlet, int version) {
    }

    protected void willDecohere() {
    }

    protected void onDecohere() {
    }

    protected void onDecohereOutlets() {
        AbstractStreamlet.decohereOutlets((Streamlet)this, ((Object)((Object)this)).getClass());
    }

    protected void didDecohere() {
    }

    protected void willRecohere(int version) {
    }

    protected void onRecohereInlets(int version) {
        AbstractStreamlet.recohereInlets((int)version, (Streamlet)this, ((Object)((Object)this)).getClass());
    }

    protected void onRecohere(int version) {
    }

    protected void onRecohereOutlets(int version) {
        AbstractStreamlet.recohereOutlets((int)version, (Streamlet)this, ((Object)((Object)this)).getClass());
    }

    protected void didRecohere(int version) {
    }

    public static <I extends Value, O extends Value> void compileInlets(Class<?> streamletClass, RecordStreamlet<I, O> streamlet) {
        while (streamletClass != null) {
            Field[] fields;
            for (Field field : fields = streamletClass.getDeclaredFields()) {
                if (!Inlet.class.isAssignableFrom(field.getType())) continue;
                In in = field.getAnnotation(In.class);
                if (in != null) {
                    String name = in.value();
                    if (name.isEmpty()) {
                        name = field.getName();
                    }
                    Inlet inlet = AbstractStreamlet.reflectInletField(streamlet, (Field)field);
                    streamlet.compileInlet(inlet, name);
                    continue;
                }
                Inout inout = field.getAnnotation(Inout.class);
                if (inout == null) continue;
                String name = inout.value();
                if (name.isEmpty()) {
                    name = field.getName();
                }
                Inoutlet inoutlet = AbstractStreamlet.reflectInoutletField(streamlet, (Field)field);
                streamlet.compileInlet((Inlet<I>)inoutlet, name);
            }
            streamletClass = streamletClass.getSuperclass();
        }
    }
}

