/*
 * Decompiled with CFR 0.152.
 */
package swim.dataflow;

import swim.dataflow.RecordOutlet;
import swim.dataflow.RecordScope;
import swim.dataflow.operator.AndOutlet;
import swim.dataflow.operator.BinaryOutlet;
import swim.dataflow.operator.BitwiseAndOutlet;
import swim.dataflow.operator.BitwiseNotOutlet;
import swim.dataflow.operator.BitwiseOrOutlet;
import swim.dataflow.operator.BitwiseXorOutlet;
import swim.dataflow.operator.ConditionalOutlet;
import swim.dataflow.operator.DivideOutlet;
import swim.dataflow.operator.EqOutlet;
import swim.dataflow.operator.GeOutlet;
import swim.dataflow.operator.GtOutlet;
import swim.dataflow.operator.InvokeOutlet;
import swim.dataflow.operator.LeOutlet;
import swim.dataflow.operator.LtOutlet;
import swim.dataflow.operator.MinusOutlet;
import swim.dataflow.operator.ModuloOutlet;
import swim.dataflow.operator.NeOutlet;
import swim.dataflow.operator.NegativeOutlet;
import swim.dataflow.operator.NotOutlet;
import swim.dataflow.operator.OrOutlet;
import swim.dataflow.operator.PlusOutlet;
import swim.dataflow.operator.PositiveOutlet;
import swim.dataflow.operator.TimesOutlet;
import swim.dataflow.operator.UnaryOutlet;
import swim.dataflow.selector.GetOutlet;
import swim.streamlet.KeyOutlet;
import swim.streamlet.Outlet;
import swim.streamlet.StreamletScope;
import swim.streamlet.ValueInput;
import swim.structure.Operator;
import swim.structure.Record;
import swim.structure.Selector;
import swim.structure.Value;
import swim.structure.operator.AndOperator;
import swim.structure.operator.BinaryOperator;
import swim.structure.operator.BitwiseAndOperator;
import swim.structure.operator.BitwiseNotOperator;
import swim.structure.operator.BitwiseOrOperator;
import swim.structure.operator.BitwiseXorOperator;
import swim.structure.operator.ConditionalOperator;
import swim.structure.operator.DivideOperator;
import swim.structure.operator.EqOperator;
import swim.structure.operator.GeOperator;
import swim.structure.operator.GtOperator;
import swim.structure.operator.InvokeOperator;
import swim.structure.operator.LeOperator;
import swim.structure.operator.LtOperator;
import swim.structure.operator.MinusOperator;
import swim.structure.operator.ModuloOperator;
import swim.structure.operator.NeOperator;
import swim.structure.operator.NegativeOperator;
import swim.structure.operator.NotOperator;
import swim.structure.operator.OrOperator;
import swim.structure.operator.PlusOperator;
import swim.structure.operator.PositiveOperator;
import swim.structure.operator.TimesOperator;
import swim.structure.operator.UnaryOperator;
import swim.structure.selector.ChildrenSelector;
import swim.structure.selector.DescendantsSelector;
import swim.structure.selector.FilterSelector;
import swim.structure.selector.GetAttrSelector;
import swim.structure.selector.GetItemSelector;
import swim.structure.selector.GetSelector;
import swim.structure.selector.IdentitySelector;
import swim.structure.selector.KeysSelector;
import swim.structure.selector.ValuesSelector;

public final class Dataflow {
    private Dataflow() {
    }

    public static Outlet<Value> compile(Value expr, Outlet<? extends Value> scope) {
        Value value;
        if (scope instanceof KeyOutlet && (value = (Value)((KeyOutlet)scope).get()) instanceof Outlet) {
            scope = (Outlet)value;
        }
        if (expr.isConstant()) {
            return new ValueInput((Object)expr);
        }
        if (expr instanceof Selector) {
            return Dataflow.compileSelector((Selector)expr, scope);
        }
        if (expr instanceof Operator) {
            return Dataflow.compileOperator((Operator)expr, (Outlet<? extends Value>)scope);
        }
        throw new IllegalArgumentException(expr.toString());
    }

    private static Outlet<Value> compileSelector(Selector selector, Outlet<? extends Value> scope) {
        if (selector instanceof IdentitySelector) {
            return Dataflow.compileIdentitySelector(scope);
        }
        if (selector instanceof GetSelector) {
            return Dataflow.compileGetSelector((GetSelector)selector, scope);
        }
        if (selector instanceof GetAttrSelector) {
            return Dataflow.compileGetAttrSelector((GetAttrSelector)selector, scope);
        }
        if (selector instanceof GetItemSelector) {
            return Dataflow.compileGetItemSelector((GetItemSelector)selector, scope);
        }
        if (selector instanceof KeysSelector) {
            return Dataflow.compileKeysSelector(scope);
        }
        if (selector instanceof ValuesSelector) {
            return Dataflow.compileValuesSelector(scope);
        }
        if (selector instanceof ChildrenSelector) {
            return Dataflow.compileChildrenSelector(scope);
        }
        if (selector instanceof DescendantsSelector) {
            return Dataflow.compileDescendantsSelector(scope);
        }
        if (selector instanceof FilterSelector) {
            return Dataflow.compileFilterSelector((FilterSelector)selector, scope);
        }
        throw new IllegalArgumentException(selector.toString());
    }

    private static Outlet<Value> compileIdentitySelector(Outlet<? extends Value> scope) {
        return scope;
    }

    private static Outlet<Value> compileGetSelector(GetSelector selector, Outlet<? extends Value> scope) {
        Value key = selector.accessor();
        if (key.isConstant()) {
            Outlet outlet;
            String name;
            if (scope instanceof RecordOutlet) {
                Outlet<Value> outlet2 = ((RecordScope)scope).outlet(key);
                if (outlet2 != null) {
                    return Dataflow.compile((Value)selector.then(), outlet2);
                }
            } else if (scope instanceof StreamletScope && (name = key.stringValue(null)) != null && (outlet = ((StreamletScope)scope).outlet(name)) != null) {
                return Dataflow.compile((Value)selector.then(), (Outlet<? extends Value>)outlet);
            }
        } else {
            GetOutlet getOutlet = new GetOutlet();
            Outlet<Value> outlet = Dataflow.compile(key, scope);
            getOutlet.keyInlet().bindInput(outlet);
            getOutlet.mapInlet().bindInput(scope);
            return getOutlet;
        }
        return null;
    }

    private static Outlet<Value> compileGetAttrSelector(GetAttrSelector selector, Outlet<? extends Value> scope) {
        throw new UnsupportedOperationException();
    }

    private static Outlet<Value> compileGetItemSelector(GetItemSelector selector, Outlet<? extends Value> scope) {
        throw new UnsupportedOperationException();
    }

    private static Outlet<Value> compileKeysSelector(Outlet<? extends Value> scope) {
        throw new UnsupportedOperationException();
    }

    private static Outlet<Value> compileValuesSelector(Outlet<? extends Value> scope) {
        throw new UnsupportedOperationException();
    }

    private static Outlet<Value> compileChildrenSelector(Outlet<? extends Value> scope) {
        throw new UnsupportedOperationException();
    }

    private static Outlet<Value> compileDescendantsSelector(Outlet<? extends Value> scope) {
        throw new UnsupportedOperationException();
    }

    private static Outlet<Value> compileFilterSelector(FilterSelector selector, Outlet<? extends Value> scope) {
        throw new UnsupportedOperationException();
    }

    private static Outlet<Value> compileOperator(Operator operator, Outlet<? extends Value> scope) {
        if (operator instanceof ConditionalOperator) {
            return Dataflow.compileConditionalOperator((ConditionalOperator)operator, scope);
        }
        if (operator instanceof BinaryOperator) {
            return Dataflow.compileBinaryOperator((BinaryOperator)operator, scope);
        }
        if (operator instanceof UnaryOperator) {
            return Dataflow.compileUnaryOperator((UnaryOperator)operator, scope);
        }
        if (operator instanceof InvokeOperator) {
            return Dataflow.compileInvokeOperator((InvokeOperator)operator, scope);
        }
        throw new IllegalArgumentException(operator.toString());
    }

    private static Outlet<Value> compileConditionalOperator(ConditionalOperator operator, Outlet<? extends Value> scope) {
        ConditionalOutlet outlet = new ConditionalOutlet();
        Value ifTerm = operator.ifTerm().toValue();
        Value thenTerm = operator.thenTerm().toValue();
        Value elseTerm = operator.elseTerm().toValue();
        Outlet<Value> ifOutlet = Dataflow.compile(ifTerm, scope);
        Outlet<Value> thenOutlet = Dataflow.compile(thenTerm, scope);
        Outlet<Value> elseOutlet = Dataflow.compile(elseTerm, scope);
        outlet.ifInlet().bindInput(ifOutlet);
        outlet.thenInlet().bindInput(thenOutlet);
        outlet.elseInlet().bindInput(elseOutlet);
        return outlet;
    }

    private static Outlet<Value> compileBinaryOperator(BinaryOperator operator, Outlet<? extends Value> scope) {
        if (operator instanceof OrOperator) {
            return Dataflow.compileOrOperator((OrOperator)operator, scope);
        }
        if (operator instanceof AndOperator) {
            return Dataflow.compileAndOperator((AndOperator)operator, scope);
        }
        if (operator instanceof BitwiseOrOperator) {
            return Dataflow.compileBitwiseOrOperator((BitwiseOrOperator)operator, scope);
        }
        if (operator instanceof BitwiseXorOperator) {
            return Dataflow.compileBitwiseXorOperator((BitwiseXorOperator)operator, scope);
        }
        if (operator instanceof BitwiseAndOperator) {
            return Dataflow.compileBitwiseAndOperator((BitwiseAndOperator)operator, scope);
        }
        if (operator instanceof LtOperator) {
            return Dataflow.compileLtOperator((LtOperator)operator, scope);
        }
        if (operator instanceof LeOperator) {
            return Dataflow.compileLeOperator((LeOperator)operator, scope);
        }
        if (operator instanceof EqOperator) {
            return Dataflow.compileEqOperator((EqOperator)operator, scope);
        }
        if (operator instanceof NeOperator) {
            return Dataflow.compileNeOperator((NeOperator)operator, scope);
        }
        if (operator instanceof GeOperator) {
            return Dataflow.compileGeOperator((GeOperator)operator, scope);
        }
        if (operator instanceof GtOperator) {
            return Dataflow.compileGtOperator((GtOperator)operator, scope);
        }
        if (operator instanceof PlusOperator) {
            return Dataflow.compilePlusOperator((PlusOperator)operator, scope);
        }
        if (operator instanceof MinusOperator) {
            return Dataflow.compileMinusOperator((MinusOperator)operator, scope);
        }
        if (operator instanceof TimesOperator) {
            return Dataflow.compileTimesOperator((TimesOperator)operator, scope);
        }
        if (operator instanceof DivideOperator) {
            return Dataflow.compileDivideOperator((DivideOperator)operator, scope);
        }
        if (operator instanceof ModuloOperator) {
            return Dataflow.compileModuloOperator((ModuloOperator)operator, scope);
        }
        throw new IllegalArgumentException(operator.toString());
    }

    private static Outlet<Value> compileBinaryOutlet(BinaryOperator operator, BinaryOutlet outlet, Outlet<? extends Value> scope) {
        Value lhs = operator.lhs().toValue();
        Value rhs = operator.rhs().toValue();
        Outlet<Value> operand1Outlet = Dataflow.compile(lhs, scope);
        Outlet<Value> operand2Outlet = Dataflow.compile(rhs, scope);
        outlet.lhsInlet().bindInput(operand1Outlet);
        outlet.rhsInlet().bindInput(operand2Outlet);
        return outlet;
    }

    private static Outlet<Value> compileOrOperator(OrOperator operator, Outlet<? extends Value> scope) {
        OrOutlet outlet = new OrOutlet();
        Value lhs = operator.lhs().toValue();
        Value rhs = operator.rhs().toValue();
        Outlet<Value> operand1Outlet = Dataflow.compile(lhs, scope);
        Outlet<Value> operand2Outlet = Dataflow.compile(rhs, scope);
        outlet.lhsInlet().bindInput(operand1Outlet);
        outlet.rhsInlet().bindInput(operand2Outlet);
        return outlet;
    }

    private static Outlet<Value> compileAndOperator(AndOperator operator, Outlet<? extends Value> scope) {
        AndOutlet outlet = new AndOutlet();
        Value lhs = operator.lhs().toValue();
        Value rhs = operator.rhs().toValue();
        Outlet<Value> operand1Outlet = Dataflow.compile(lhs, scope);
        Outlet<Value> operand2Outlet = Dataflow.compile(rhs, scope);
        outlet.lhsInlet().bindInput(operand1Outlet);
        outlet.rhsInlet().bindInput(operand2Outlet);
        return outlet;
    }

    private static Outlet<Value> compileBitwiseOrOperator(BitwiseOrOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new BitwiseOrOutlet(), scope);
    }

    private static Outlet<Value> compileBitwiseXorOperator(BitwiseXorOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new BitwiseXorOutlet(), scope);
    }

    private static Outlet<Value> compileBitwiseAndOperator(BitwiseAndOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new BitwiseAndOutlet(), scope);
    }

    private static Outlet<Value> compileLtOperator(LtOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new LtOutlet(), scope);
    }

    private static Outlet<Value> compileLeOperator(LeOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new LeOutlet(), scope);
    }

    private static Outlet<Value> compileEqOperator(EqOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new EqOutlet(), scope);
    }

    private static Outlet<Value> compileNeOperator(NeOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new NeOutlet(), scope);
    }

    private static Outlet<Value> compileGeOperator(GeOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new GeOutlet(), scope);
    }

    private static Outlet<Value> compileGtOperator(GtOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new GtOutlet(), scope);
    }

    private static Outlet<Value> compilePlusOperator(PlusOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new PlusOutlet(), scope);
    }

    private static Outlet<Value> compileMinusOperator(MinusOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new MinusOutlet(), scope);
    }

    private static Outlet<Value> compileTimesOperator(TimesOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new TimesOutlet(), scope);
    }

    private static Outlet<Value> compileDivideOperator(DivideOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new DivideOutlet(), scope);
    }

    private static Outlet<Value> compileModuloOperator(ModuloOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileBinaryOutlet((BinaryOperator)operator, new ModuloOutlet(), scope);
    }

    private static Outlet<Value> compileUnaryOperator(UnaryOperator operator, Outlet<? extends Value> scope) {
        if (operator instanceof NotOperator) {
            return Dataflow.compileNotOperator((NotOperator)operator, scope);
        }
        if (operator instanceof BitwiseNotOperator) {
            return Dataflow.compileBitwiseNotOperator((BitwiseNotOperator)operator, scope);
        }
        if (operator instanceof NegativeOperator) {
            return Dataflow.compileNegativeOperator((NegativeOperator)operator, scope);
        }
        if (operator instanceof PositiveOperator) {
            return Dataflow.compilePositiveOperator((PositiveOperator)operator, scope);
        }
        throw new IllegalArgumentException(operator.toString());
    }

    private static Outlet<Value> compileUnaryOutlet(UnaryOperator operator, UnaryOutlet outlet, Outlet<? extends Value> scope) {
        Value operand = operator.operand().toValue();
        Outlet<Value> operandOutlet = Dataflow.compile(operand, scope);
        outlet.operandInlet().bindInput(operandOutlet);
        return outlet;
    }

    private static Outlet<Value> compileNotOperator(NotOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileUnaryOutlet((UnaryOperator)operator, new NotOutlet(), scope);
    }

    private static Outlet<Value> compileBitwiseNotOperator(BitwiseNotOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileUnaryOutlet((UnaryOperator)operator, new BitwiseNotOutlet(), scope);
    }

    private static Outlet<Value> compileNegativeOperator(NegativeOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileUnaryOutlet((UnaryOperator)operator, new NegativeOutlet(), scope);
    }

    private static Outlet<Value> compilePositiveOperator(PositiveOperator operator, Outlet<? extends Value> scope) {
        return Dataflow.compileUnaryOutlet((UnaryOperator)operator, new PositiveOutlet(), scope);
    }

    private static Outlet<Value> compileInvokeOperator(InvokeOperator operator, Outlet<? extends Value> scope) {
        Value func = operator.func();
        Value args = operator.args();
        InvokeOutlet invokeOutlet = new InvokeOutlet((Record)scope);
        Outlet<Value> funcOutlet = Dataflow.compile(func, scope);
        Outlet<Value> argsOutlet = Dataflow.compile(args, scope);
        invokeOutlet.funcInlet().bindInput(funcOutlet);
        invokeOutlet.argsInlet().bindInput(argsOutlet);
        return invokeOutlet;
    }
}

