/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.Map;
import java.util.NoSuchElementException;
import swim.concurrent.Cont;
import swim.concurrent.Sync;
import swim.db.BTreeNode;
import swim.db.BTreePageRef;
import swim.db.Page;
import swim.structure.Value;
import swim.util.OrderedMapCursor;

abstract class BTreeNodeCursor
implements OrderedMapCursor<Value, Value> {
    final BTreeNode page;
    long index;
    int childIndex;
    OrderedMapCursor<Value, Value> childCursor;

    BTreeNodeCursor(BTreeNode page, long index, int childIndex) {
        this.page = page;
        this.index = index;
        this.childIndex = childIndex;
    }

    BTreeNodeCursor(BTreeNode page) {
        this(page, 0L, 0);
    }

    abstract OrderedMapCursor<Value, Value> childCursor(BTreePageRef var1);

    public final boolean isEmpty() {
        while (true) {
            OrderedMapCursor<Value, Value> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    return false;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            BTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex + 1;
        }
        return true;
    }

    public final Map.Entry<Value, Value> head() {
        while (true) {
            OrderedMapCursor<Value, Value> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    return (Map.Entry)childCursor.head();
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            BTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex + 1;
        }
        throw new NoSuchElementException();
    }

    public final void step() {
        while (true) {
            OrderedMapCursor<Value, Value> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    ++this.index;
                    return;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            BTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex + 1;
        }
        throw new UnsupportedOperationException();
    }

    public final void skip(long count) {
        while (count > 0L) {
            OrderedMapCursor<Value, Value> childCursor = this.childCursor;
            if (childCursor != null) {
                if (childCursor.hasNext()) {
                    ++this.index;
                    --count;
                    childCursor.next();
                    continue;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            BTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            BTreePageRef childRef = childRefs[childIndex];
            long childSpan = childRef.span();
            this.childIndex = childIndex + 1;
            if (childSpan < count) {
                this.childCursor = this.childCursor(childRef);
                if (count <= 0L) break;
                this.index += count;
                this.childCursor.skip(count);
                count = 0L;
                break;
            }
            this.index += childSpan;
            count -= childSpan;
        }
    }

    public final boolean hasNext() {
        while (true) {
            OrderedMapCursor<Value, Value> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    return true;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            BTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex + 1;
        }
        return false;
    }

    public final long nextIndexLong() {
        return this.index;
    }

    public Value nextKey() {
        while (true) {
            OrderedMapCursor<Value, Value> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    return (Value)childCursor.nextKey();
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            BTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex + 1;
        }
        throw new NoSuchElementException();
    }

    public final Map.Entry<Value, Value> next() {
        while (true) {
            OrderedMapCursor<Value, Value> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    ++this.index;
                    return (Map.Entry)childCursor.next();
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            BTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex + 1;
        }
        throw new NoSuchElementException();
    }

    public final boolean hasPrevious() {
        while (true) {
            OrderedMapCursor<Value, Value> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasPrevious()) {
                    return true;
                }
                this.childCursor = null;
                continue;
            }
            BTreePageRef[] childRefs = this.page.childRefs;
            int childIndex = this.childIndex - 1;
            if (childIndex < 0) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex;
        }
        return false;
    }

    public final long previousIndexLong() {
        return this.index - 1L;
    }

    public Value previousKey() {
        while (true) {
            OrderedMapCursor<Value, Value> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasPrevious()) {
                    return (Value)childCursor.previousKey();
                }
                this.childCursor = null;
                continue;
            }
            BTreePageRef[] childRefs = this.page.childRefs;
            int childIndex = this.childIndex - 1;
            if (childIndex < 0) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex;
        }
        throw new NoSuchElementException();
    }

    public final Map.Entry<Value, Value> previous() {
        while (true) {
            OrderedMapCursor<Value, Value> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasPrevious()) {
                    --this.index;
                    return (Map.Entry)childCursor.previous();
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex - 1;
            BTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex;
        }
        throw new NoSuchElementException();
    }

    public void load() throws InterruptedException {
        Sync syncPage = new Sync();
        this.page.pageRef.loadTreeAsync(false, (Cont<Page>)syncPage);
        syncPage.await((long)this.page.pageRef.settings().pageLoadTimeout);
    }
}

