/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import swim.collections.FingerTrieSeq;
import swim.db.Commit;
import swim.db.Database;
import swim.db.Germ;
import swim.db.StoreException;
import swim.db.Tree;

public class Chunk {
    final Database database;
    final Commit commit;
    final int zone;
    final Germ germ;
    final FingerTrieSeq<Tree> trees;
    final ByteBuffer buffer;

    public Chunk(Database database, Commit commit, int zone, Germ germ, FingerTrieSeq<Tree> trees, ByteBuffer buffer) {
        this.database = database;
        this.commit = commit;
        this.zone = zone;
        this.germ = germ;
        this.trees = trees;
        this.buffer = buffer;
    }

    public Database database() {
        return this.database;
    }

    public Commit commit() {
        return this.commit;
    }

    public int zone() {
        return this.zone;
    }

    public Germ germ() {
        return this.germ;
    }

    public FingerTrieSeq<Tree> trees() {
        return this.trees;
    }

    public ByteBuffer toByteBuffer() {
        return this.buffer;
    }

    public long size() {
        return this.buffer.capacity();
    }

    public void write(WritableByteChannel channel) {
        ByteBuffer buffer = this.buffer;
        try {
            int k;
            while ((k = channel.write(buffer)) > 0 && buffer.hasRemaining()) {
            }
            if (buffer.hasRemaining()) {
                throw new StoreException("wrote incomplete chunk");
            }
        }
        catch (IOException cause) {
            throw new StoreException(cause);
        }
    }

    public void soften() {
        long version = this.germ.version();
        for (Tree tree : this.trees) {
            tree.soften(version);
        }
    }

    public String toString() {
        return new String(this.buffer.array(), Charset.forName("UTF-8"));
    }
}

