/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.collections.FingerTrieSeq;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.Chunk;

public final class Commit {
    private static Commit closed;
    private static Commit forced;
    final boolean isClosed;
    final boolean isForced;
    final boolean isShifted;
    final FingerTrieSeq<Cont<Chunk>> conts;

    public Commit(boolean isClosed, boolean isForced, boolean isShifted, FingerTrieSeq<Cont<Chunk>> conts) {
        this.isClosed = isClosed;
        this.isForced = isForced;
        this.isShifted = isShifted;
        this.conts = conts;
    }

    public Commit(boolean isClosed, boolean isForced, boolean isShifted) {
        this(isClosed, isForced, isShifted, (FingerTrieSeq<Cont<Chunk>>)FingerTrieSeq.empty());
    }

    public static Commit closed() {
        if (closed == null) {
            closed = new Commit(true, true, false);
        }
        return closed;
    }

    public static Commit forced() {
        if (forced == null) {
            forced = new Commit(false, true, false);
        }
        return forced;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Commit isClosed(boolean isClosed) {
        return new Commit(isClosed, this.isForced, this.isShifted, this.conts);
    }

    public boolean isForced() {
        return this.isForced;
    }

    public Commit isForced(boolean isForced) {
        return new Commit(this.isClosed, isForced, this.isShifted, this.conts);
    }

    public boolean isShifted() {
        return this.isShifted;
    }

    public Commit isShifted(boolean isShifted) {
        return new Commit(this.isClosed, this.isForced, isShifted, this.conts);
    }

    public FingerTrieSeq<Cont<Chunk>> conts() {
        return this.conts;
    }

    public Commit andThen(Cont<Chunk> cont) {
        return new Commit(this.isClosed, this.isForced, this.isShifted, (FingerTrieSeq<Cont<Chunk>>)this.conts.appended(cont));
    }

    public void bind(Chunk chunk) {
        for (Cont cont : this.conts) {
            try {
                cont.bind((Object)chunk);
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    cont.trap(cause);
                    continue;
                }
                throw cause;
            }
        }
    }

    public void trap(Throwable error) {
        for (Cont cont : this.conts) {
            try {
                cont.trap(error);
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    cause.printStackTrace();
                    continue;
                }
                throw cause;
            }
        }
    }

    public Commit merged(Commit that) {
        boolean isClosed = this.isClosed || that.isClosed;
        boolean isForced = this.isForced || that.isForced;
        boolean isShifted = this.isShifted || that.isShifted;
        FingerTrieSeq conts = this.conts.appended(that.conts);
        return new Commit(isClosed, isForced, isShifted, (FingerTrieSeq<Cont<Chunk>>)conts);
    }
}

