/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.collections.FingerTrieSeq;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.Commit;
import swim.db.Store;

public final class Compact {
    final int deleteDelay;
    final boolean isForced;
    final boolean isShifted;
    final FingerTrieSeq<Cont<Store>> conts;

    public Compact(int deleteDelay, boolean isForced, boolean isShifted, FingerTrieSeq<Cont<Store>> conts) {
        this.deleteDelay = deleteDelay;
        this.isForced = isForced;
        this.isShifted = isShifted;
        this.conts = conts;
    }

    public Compact(int deleteDelay, boolean isForced, boolean isShifted) {
        this(deleteDelay, isForced, isShifted, (FingerTrieSeq<Cont<Store>>)FingerTrieSeq.empty());
    }

    public static Compact forced(int deleteDelay) {
        return new Compact(deleteDelay, true, false);
    }

    public int deleteDelay() {
        return this.deleteDelay;
    }

    public Compact deleteDelay(int deleteDelay) {
        return new Compact(deleteDelay, this.isForced, this.isShifted, this.conts);
    }

    public boolean isForced() {
        return this.isForced;
    }

    public Compact isForced(boolean isForced) {
        return new Compact(this.deleteDelay, isForced, this.isShifted, this.conts);
    }

    public boolean isShifted() {
        return this.isShifted;
    }

    public Compact isShifted(boolean isShifted) {
        return new Compact(this.deleteDelay, this.isForced, isShifted, this.conts);
    }

    public FingerTrieSeq<Cont<Store>> conts() {
        return this.conts;
    }

    public Compact andThen(Cont<Store> cont) {
        return new Compact(this.deleteDelay, this.isForced, this.isShifted, (FingerTrieSeq<Cont<Store>>)this.conts.appended(cont));
    }

    public void bind(Store store) {
        for (Cont cont : this.conts) {
            try {
                cont.bind((Object)store);
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    cont.trap(cause);
                    continue;
                }
                throw cause;
            }
        }
    }

    public void trap(Throwable error) {
        for (Cont cont : this.conts) {
            try {
                cont.trap(error);
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    cause.printStackTrace();
                    continue;
                }
                throw cause;
            }
        }
    }

    public Compact merged(Compact that) {
        int deleteDelay = Math.max(this.deleteDelay, that.deleteDelay);
        boolean isForced = this.isForced || that.isForced;
        boolean isShifted = this.isShifted || that.isShifted;
        FingerTrieSeq conts = this.conts.appended(that.conts);
        return new Compact(deleteDelay, isForced, isShifted, (FingerTrieSeq<Cont<Store>>)conts);
    }

    public Commit commit() {
        return new Commit(false, this.isForced, this.isShifted);
    }
}

