/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.collections.HashTrieMap;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.FileStore;
import swim.db.FileZone;
import swim.db.Page;
import swim.db.PageLoader;
import swim.db.PageRef;
import swim.db.TreeDelegate;
import swim.db.Zone;

final class FilePageLoader
extends PageLoader {
    static final AtomicReferenceFieldUpdater<FilePageLoader, HashTrieMap<Integer, FileChannel>> CHANNELS = AtomicReferenceFieldUpdater.newUpdater(FilePageLoader.class, HashTrieMap.class, "channels");
    final FileStore store;
    final TreeDelegate treeDelegate;
    final boolean isResident;
    volatile HashTrieMap<Integer, FileChannel> channels;

    FilePageLoader(FileStore store, TreeDelegate treeDelegate, boolean isResident) {
        this.store = store;
        this.treeDelegate = treeDelegate;
        this.isResident = isResident;
        this.channels = HashTrieMap.empty();
    }

    @Override
    public boolean isResident() {
        return this.isResident;
    }

    @Override
    public void loadPageAsync(PageRef pageRef, Cont<Page> cont) {
        try {
            int zoneId = pageRef.zone();
            this.store.openZoneAsync(zoneId, new LoadPage(this, pageRef, cont));
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    void loadPageAsync(FileZone zone, PageRef pageRef, Cont<Page> cont) {
        try {
            FileChannel channel;
            block8: {
                HashTrieMap<Integer, FileChannel> oldChannels;
                FileChannel oldChannel;
                Integer zoneId = zone.id;
                channel = null;
                while ((oldChannel = (FileChannel)(oldChannels = this.channels).get((Object)zoneId)) == null) {
                    channel = zone.openReadChannel();
                    HashTrieMap newChannels = oldChannels.updated((Object)zoneId, (Object)channel);
                    if (!CHANNELS.compareAndSet(this, oldChannels, (HashTrieMap<Integer, FileChannel>)newChannels)) continue;
                    break block8;
                }
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException swallow) {
                        swallow.printStackTrace();
                    }
                }
                channel = oldChannel;
            }
            zone.loadPageAsync(channel, pageRef, this.treeDelegate, this.isResident, cont);
        }
        catch (IOException cause) {
            cont.trap((Throwable)cause);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    @Override
    public void close() {
        HashTrieMap newChannels;
        HashTrieMap<Integer, FileChannel> oldChannels;
        while ((oldChannels = this.channels) != (newChannels = HashTrieMap.empty())) {
            if (!CHANNELS.compareAndSet(this, oldChannels, (HashTrieMap<Integer, FileChannel>)newChannels)) continue;
            Iterator channelIterator = oldChannels.valueIterator();
            while (channelIterator.hasNext()) {
                try {
                    ((FileChannel)channelIterator.next()).close();
                }
                catch (IOException swallow) {
                    swallow.printStackTrace();
                }
            }
            break block2;
        }
    }

    static final class LoadPage
    implements Cont<Zone> {
        final FilePageLoader pageLoader;
        final PageRef pageRef;
        final Cont<Page> cont;

        LoadPage(FilePageLoader pageLoader, PageRef pageRef, Cont<Page> cont) {
            this.pageLoader = pageLoader;
            this.pageRef = pageRef;
            this.cont = cont;
        }

        public void bind(Zone zone) {
            try {
                this.pageLoader.loadPageAsync((FileZone)zone, this.pageRef, this.cont);
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    this.cont.trap(cause);
                }
                throw cause;
            }
        }

        public void trap(Throwable error) {
            this.cont.trap(error);
        }
    }
}

