/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.concurrent.AbstractTask;
import swim.concurrent.Conts;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Database;
import swim.db.FileStore;
import swim.db.FileZone;
import swim.db.StoreException;

final class FileStoreCommitter
extends AbstractTask {
    static final AtomicReferenceFieldUpdater<FileStoreCommitter, Commit> COMMIT = AtomicReferenceFieldUpdater.newUpdater(FileStoreCommitter.class, Commit.class, "commit");
    final FileStore store;
    volatile Commit commit;

    FileStoreCommitter(FileStore store) {
        this.store = store;
    }

    void commitAsync(Commit commit) {
        block5: {
            int newStatus;
            int oldStatus;
            Commit newCommit;
            Commit oldCommit;
            if ((this.store.status & 2) == 0) {
                try {
                    this.store.open();
                }
                catch (InterruptedException cause) {
                    throw new StoreException(cause);
                }
            }
            while (!COMMIT.compareAndSet(this, oldCommit, newCommit = (oldCommit = this.commit) != null ? oldCommit.merged(commit) : commit)) {
            }
            if (oldCommit != null) break block5;
            while (!FileStore.STATUS.compareAndSet(this.store, oldStatus = this.store.status, newStatus = oldStatus | 4)) {
            }
            this.cue();
        }
    }

    public boolean taskWillBlock() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask() {
        block19: {
            FileStore store = this.store;
            Database database = null;
            try {
                database = store.openDatabase();
                Commit commit = COMMIT.getAndSet(this, null);
                if (commit == null) {
                    return;
                }
                if ((commit = database.databaseWillCommit(commit)).isShifted()) {
                    store.shiftZone();
                }
                FileZone zone = store.zone;
                Chunk chunk = zone.commitAndWriteChunk(commit);
                database.databaseDidCommit(chunk);
                if (chunk != null) {
                    chunk.soften();
                }
                commit.bind(chunk);
            }
            catch (InterruptedException cause) {
                try {
                    database.databaseCommitDidFail(cause);
                }
                finally {
                    this.commit.trap(cause);
                }
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    try {
                        database.databaseCommitDidFail(cause);
                        break block19;
                    }
                    finally {
                        this.commit.trap(cause);
                    }
                }
                throw cause;
            }
            finally {
                int newStatus;
                int oldStatus;
                while (!FileStore.STATUS.compareAndSet(store, oldStatus = this.store.status, newStatus = oldStatus & 0xFFFFFFFB)) {
                }
            }
        }
    }
}

