/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.concurrent.Sync;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Database;
import swim.db.FileZoneAwait;
import swim.db.FileZoneOpen;
import swim.db.FileZoneOpenDatabase;
import swim.db.FileZonePageReader;
import swim.db.Germ;
import swim.db.Page;
import swim.db.PageRef;
import swim.db.Store;
import swim.db.StoreException;
import swim.db.StoreSettings;
import swim.db.TreeDelegate;
import swim.db.Zone;

public class FileZone
extends Zone {
    static final int OPENING = 1;
    static final int OPENED = 2;
    static final int FAILED = 4;
    static final boolean WINDOWS = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    static final AtomicReferenceFieldUpdater<FileZone, Database> DATABASE = AtomicReferenceFieldUpdater.newUpdater(FileZone.class, Database.class, "database");
    static final AtomicIntegerFieldUpdater<FileZone> STATUS = AtomicIntegerFieldUpdater.newUpdater(FileZone.class, "status");
    final Store store;
    final int id;
    final File file;
    final Stage stage;
    volatile Database database;
    volatile Germ germ;
    volatile long size;
    volatile int status;

    public FileZone(Store store, int id, File file, Stage stage, Database database, Germ germ) {
        if (database == null || germ == null) {
            throw new NullPointerException();
        }
        this.store = store;
        this.id = id;
        this.file = file;
        this.stage = stage;
        this.database = database;
        this.germ = germ;
        this.status = 2;
    }

    public FileZone(Store store, int id, File file, Stage stage) {
        this.store = store;
        this.id = id;
        this.file = file;
        this.stage = stage;
    }

    public final Store store() {
        return this.store;
    }

    @Override
    public final int id() {
        return this.id;
    }

    public final File file() {
        return this.file;
    }

    public final Stage stage() {
        return this.stage;
    }

    public final Database database() {
        return this.database;
    }

    @Override
    public final Germ germ() {
        return this.germ;
    }

    @Override
    public final StoreSettings settings() {
        return this.store.settings();
    }

    @Override
    public final long size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openAsync(Cont<Zone> cont) {
        block18: {
            try {
                int oldStatus;
                while (((oldStatus = this.status) & 7) == 0) {
                    int newStatus = oldStatus | 1;
                    if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                    try {
                        FileChannel channel = null;
                        try {
                            channel = this.openReadChannel();
                            this.size = channel.size();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                        this.stage.execute((Runnable)new FileZoneOpen(this, channel, cont));
                        break block18;
                    }
                    catch (Throwable cause) {
                        STATUS.set(this, 4);
                        FileZone fileZone = this;
                        synchronized (fileZone) {
                            this.notifyAll();
                        }
                        throw cause;
                    }
                }
                if ((oldStatus & 1) != 0) {
                    FileZone fileZone = this;
                    synchronized (fileZone) {
                        ForkJoinPool.managedBlock(new FileZoneAwait(this));
                    }
                }
                if ((this.status & 2) != 0) {
                    cont.bind((Object)this);
                } else {
                    cont.trap((Throwable)new StoreException("failed to open zone " + this.file.getPath()));
                }
            }
            catch (IOException | InterruptedException cause) {
                cont.trap((Throwable)cause);
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    cont.trap(cause);
                }
                throw cause;
            }
        }
    }

    @Override
    public FileZone open() throws InterruptedException {
        Sync syncZone = new Sync();
        this.openAsync((Cont<Zone>)syncZone);
        return (FileZone)syncZone.await((long)this.settings().zoneOpenTimeout);
    }

    @Override
    public void close() {
    }

    @Override
    public void openDatabaseAsync(Cont<Database> cont) {
        try {
            this.openAsync(new FileZoneOpenDatabase(this, cont));
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    public FileChannel openReadChannel() throws IOException {
        return new RandomAccessFile(this.file, "r").getChannel();
    }

    public FileChannel openWriteChannel() throws IOException {
        return new RandomAccessFile(this.file, "rw").getChannel();
    }

    void loadPageAsync(FileChannel channel, PageRef pageRef, TreeDelegate treeDelegate, boolean isResident, Cont<Page> cont) {
        try {
            this.stage.execute((Runnable)new FileZonePageReader(this, channel, pageRef.base(), pageRef.pageSize(), pageRef, treeDelegate, isResident, cont));
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public Chunk commitAndWriteChunk(Commit commit) {
        Database database = this.database;
        Chunk chunk = null;
        try (FileChannel channel = this.openWriteChannel();){
            Chunk chunk2;
            block19: {
                FileLock fileLock = null;
                if (!WINDOWS) {
                    fileLock = channel.lock();
                }
                try {
                    long base = Math.max(this.size, Math.max(8192L, channel.size()));
                    chunk = database.commitChunk(commit, this.id, base);
                    if (chunk != null) {
                        ByteBuffer buffer = chunk.toByteBuffer();
                        this.write(channel, buffer, base);
                        Germ germ = chunk.germ();
                        buffer = germ.toByteBuffer();
                        this.write(channel, buffer, 0L);
                        ((Buffer)buffer).flip();
                        this.write(channel, buffer, 4096L);
                        if (commit.isForced()) {
                            channel.force(true);
                        }
                        this.size = Math.max(this.size + chunk.size(), channel.size());
                    }
                    chunk2 = chunk;
                    if (fileLock == null) break block19;
                }
                catch (Throwable throwable) {
                    if (fileLock != null) {
                        fileLock.release();
                    }
                    throw throwable;
                }
                fileLock.release();
            }
            return chunk2;
        }
        catch (IOException cause) {
            if (chunk != null) {
                database.uncommit(chunk.germ.version);
            }
            throw new StoreException(cause);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                if (chunk != null) {
                    database.uncommit(chunk.germ.version);
                }
                throw new StoreException(cause);
            }
            throw cause;
        }
    }

    void write(FileChannel channel, ByteBuffer buffer, long position) throws IOException {
        int k;
        do {
            k = channel.write(buffer, position);
            position += (long)k;
        } while (k >= 0 && buffer.hasRemaining());
        if (buffer.hasRemaining()) {
            throw new StoreException("wrote incomplete chunk to " + this.file.getPath());
        }
    }
}

