/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import swim.codec.Binary;
import swim.codec.Input;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.FileZone;
import swim.db.FileZoneReader;
import swim.db.Germ;
import swim.db.Zone;
import swim.recon.Recon;
import swim.structure.Value;

final class FileZoneOpen
extends FileZoneReader {
    final Cont<Zone> cont;

    FileZoneOpen(FileZone zone, FileChannel channel, Cont<Zone> cont) {
        super(zone, channel, 0L, 8192);
        this.cont = cont;
    }

    @Override
    protected void bind(ByteBuffer buffer) {
        Germ germ;
        ((Buffer)buffer).position(0).limit(4096);
        Germ germ0 = this.parseGerm(Utf8.decodedInput((Input)Binary.inputBuffer((ByteBuffer)buffer)));
        ((Buffer)buffer).position(4096).limit(8192);
        Germ germ1 = this.parseGerm(Utf8.decodedInput((Input)Binary.inputBuffer((ByteBuffer)buffer)));
        if (germ0 != null && germ1 != null) {
            germ = germ0.updated() < germ1.updated() ? germ1 : germ0;
        } else if (germ1 != null) {
            germ = germ1;
        } else if (germ0 != null) {
            germ = germ0;
        } else {
            long time = System.currentTimeMillis();
            germ = new Germ(10, 1L, time, time, Value.absent());
        }
        this.zone.germ = germ;
        FileZone.STATUS.set(this.zone, 2);
        this.cont.bind((Object)this.zone);
    }

    @Override
    protected void trap(Throwable error) {
        try {
            FileZone.STATUS.set(this.zone, 4);
            this.zone.close();
        }
        finally {
            this.cont.trap(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doRead(FileChannel channel) {
        try {
            if (channel != null && (long)this.size <= channel.size()) {
                super.doRead(channel);
                return;
            }
            long time = System.currentTimeMillis();
            this.zone.germ = new Germ(10, 1L, time, time, Value.absent());
            FileZone.STATUS.set(this.zone, 2);
            this.cont.bind((Object)this.zone);
            return;
        }
        catch (IOException cause) {
            this.trap(cause);
            return;
        }
        catch (Throwable cause) {
            if (!Conts.isNonFatal((Throwable)cause)) throw cause;
            this.trap(cause);
            return;
        }
        finally {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException swallow) {
                swallow.printStackTrace();
            }
            finally {
                FileZone swallow = this.zone;
                synchronized (swallow) {
                    this.zone.notifyAll();
                }
            }
        }
    }

    protected Germ parseGerm(Input input) {
        try {
            Parser parser = Recon.structureParser().parseBlock(input);
            if (parser.isDone()) {
                return Germ.fromValue((Value)parser.bind());
            }
            return null;
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                return null;
            }
            throw cause;
        }
    }
}

