/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.nio.channels.FileChannel;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.FileZone;
import swim.db.FileZoneReconReader;
import swim.db.Page;
import swim.db.PageRef;
import swim.db.TreeDelegate;
import swim.structure.Value;

final class FileZonePageReader
extends FileZoneReconReader {
    final PageRef pageRef;
    final TreeDelegate treeDelegate;
    final boolean isResident;
    final Cont<Page> cont;

    FileZonePageReader(FileZone zone, FileChannel channel, long offset, int size, PageRef pageRef, TreeDelegate treeDelegate, boolean isResident, Cont<Page> cont) {
        super(zone, channel, offset, size);
        this.pageRef = pageRef;
        this.treeDelegate = treeDelegate;
        this.isResident = isResident;
        this.cont = cont;
    }

    @Override
    protected void bind(Value value) {
        try {
            Page page = this.pageRef.setPageValue(value, this.isResident);
            if (this.treeDelegate != null) {
                this.treeDelegate.treeDidLoadPage(page);
            }
            this.cont.bind((Object)page);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                this.trap(cause);
            }
            throw cause;
        }
    }

    @Override
    protected void trap(Throwable error) {
        this.cont.trap(error);
    }
}

