/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Database;
import swim.db.QTree;
import swim.db.QTreeEntryCursor;
import swim.db.QTreeMapView;
import swim.db.QTreeShapeCursor;
import swim.db.QTreeValueCursor;
import swim.db.StoreException;
import swim.db.StoreSettings;
import swim.db.Tree;
import swim.db.TreeContext;
import swim.db.TreeDelegate;
import swim.db.Trunk;
import swim.math.Z2Form;
import swim.spatial.BitInterval;
import swim.spatial.SpatialMap;
import swim.spatial.SpatialValueMap;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.util.Cursor;

public class QTreeMap<S>
implements SpatialMap<Value, S, Value> {
    final Trunk<QTree> trunk;
    final Z2Form<S> shapeForm;

    public QTreeMap(Trunk<QTree> trunk, Z2Form<S> shapeForm) {
        this.trunk = trunk;
        this.shapeForm = shapeForm;
    }

    public final Trunk<QTree> trunk() {
        return this.trunk;
    }

    public final StoreSettings settings() {
        return this.trunk.settings();
    }

    public final Database database() {
        return this.trunk.database;
    }

    public final Value name() {
        return this.trunk.name;
    }

    public final QTree tree() {
        return (QTree)this.trunk.tree;
    }

    public final TreeDelegate treeDelegate() {
        return this.tree().treeDelegate();
    }

    public void setTreeDelegate(TreeDelegate treeDelegate) {
        this.tree().setTreeDelegate(treeDelegate);
    }

    public Z2Form<S> shapeForm() {
        return this.shapeForm;
    }

    public boolean isResident() {
        return this.tree().isResident();
    }

    public QTreeMap<S> isResident(boolean isResident) {
        long newVersion;
        QTree newTree;
        QTree oldTree;
        do {
            newVersion = this.trunk.version();
        } while ((oldTree = this.tree()) != (newTree = oldTree.isResident(isResident)) && !this.trunk.updateTree(oldTree, newTree, newVersion));
        return this;
    }

    public boolean isTransient() {
        return this.tree().isTransient();
    }

    public QTreeMap<S> isTransient(boolean isTransient) {
        long newVersion;
        QTree newTree;
        QTree oldTree;
        do {
            newVersion = this.trunk.version();
        } while ((oldTree = this.tree()) != (newTree = oldTree.isTransient(isTransient)) && !this.trunk.updateTree(oldTree, newTree, newVersion));
        return this;
    }

    public <K> SpatialValueMap<K, S, Value> keyForm(Form<K> keyForm) {
        return new SpatialValueMap((SpatialMap)this, keyForm, Form.forValue());
    }

    public <K> SpatialValueMap<K, S, Value> keyClass(Class<K> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public <V> SpatialValueMap<Value, S, V> valueForm(Form<V> valueForm) {
        return new SpatialValueMap((SpatialMap)this, Form.forValue(), valueForm);
    }

    public <V> SpatialValueMap<Value, S, V> valueClass(Class<V> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public QTreeMapView<S> snapshot() {
        return new QTreeMapView<S>(this.tree(), this.shapeForm);
    }

    public boolean isEmpty() {
        return this.tree().isEmpty();
    }

    public int size() {
        return (int)this.tree().span();
    }

    public long span() {
        return this.tree().span();
    }

    public long treeSize() {
        return this.tree().treeSize();
    }

    public boolean containsKey(Value key, S shape) {
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span((long)shapeForm.getXMin(shape), (long)shapeForm.getXMax(shape));
        long y = BitInterval.span((long)shapeForm.getYMin(shape), (long)shapeForm.getYMax(shape));
        int retries = 0;
        while (true) {
            try {
                return this.tree().containsKey(key, x, y);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public boolean containsKey(Object key) {
        if (key instanceof Value) {
            return this.containsKey((Value)key);
        }
        return false;
    }

    private boolean containsKey(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().containsKey(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public boolean containsValue(Object value) {
        if (value instanceof Value) {
            return this.containsValue((Value)value);
        }
        return false;
    }

    private boolean containsValue(Value value) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().containsValue(value);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value get(Object key) {
        if (key instanceof Value) {
            return this.get((Value)key);
        }
        return Value.absent();
    }

    private Value get(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().get(key).body();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value get(Value key, S shape) {
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span((long)shapeForm.getXMin(shape), (long)shapeForm.getXMax(shape));
        long y = BitInterval.span((long)shapeForm.getYMin(shape), (long)shapeForm.getYMax(shape));
        int retries = 0;
        while (true) {
            try {
                return this.tree().get(key, x, y).body();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value put(Value key, S shape, Value newValue) {
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span((long)shapeForm.getXMin(shape), (long)shapeForm.getXMax(shape));
        long y = BitInterval.span((long)shapeForm.getYMin(shape), (long)shapeForm.getYMax(shape));
        newValue = shapeForm.mold(shape).concat((Item)newValue);
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                QTree oldTree = this.tree();
                QTree newTree = oldTree.updated(key, x, y, newValue, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    Value oldValue = oldTree.get(key, x, y);
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.qtreeDidUpdate(newTree, oldTree, key, x, y, newValue, oldValue);
                    treeContext.treeDidChange(newTree, oldTree);
                    return oldValue;
                }
                return Value.absent();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value move(Value key, S oldShape, S newShape, Value newValue) {
        Z2Form<S> shapeForm = this.shapeForm;
        long oldX = BitInterval.span((long)shapeForm.getXMin(oldShape), (long)shapeForm.getXMax(oldShape));
        long oldY = BitInterval.span((long)shapeForm.getYMin(oldShape), (long)shapeForm.getYMax(oldShape));
        long newX = BitInterval.span((long)shapeForm.getXMin(newShape), (long)shapeForm.getXMax(newShape));
        long newY = BitInterval.span((long)shapeForm.getYMin(newShape), (long)shapeForm.getYMax(newShape));
        newValue = shapeForm.mold(newShape).concat((Item)newValue);
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                QTree oldTree = this.tree();
                QTree newTree = oldTree.moved(key, oldX, oldY, newX, newY, newValue, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    Value oldValue = oldTree.get(key, oldX, oldY);
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.qtreeDidMove(newTree, oldTree, key, newX, newY, newValue, oldX, oldY, oldValue);
                    treeContext.treeDidChange(newTree, oldTree);
                    return oldValue;
                }
                return Value.absent();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value remove(Value key, S shape) {
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span((long)shapeForm.getXMin(shape), (long)shapeForm.getXMax(shape));
        long y = BitInterval.span((long)shapeForm.getYMin(shape), (long)shapeForm.getYMax(shape));
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                QTree oldTree = this.tree();
                QTree newTree = oldTree.removed(key, x, y, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    Value oldValue = oldTree.get(key, x, y);
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.qtreeDidRemove(newTree, oldTree, key, x, y, oldValue);
                    treeContext.treeDidChange(newTree, oldTree);
                    return oldValue;
                }
                return Value.absent();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public void clear() {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            try {
                QTree oldTree = this.tree();
                QTree newTree = oldTree.cleared(newVersion);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.treeDidClear(newTree, oldTree);
                    treeContext.treeDidChange(newTree, oldTree);
                    return;
                }
                return;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<SpatialMap.Entry<Value, S, Value>> iterator(S shape) {
        int retries = 0;
        while (true) {
            try {
                Z2Form<S> shapeForm = this.shapeForm;
                long x = BitInterval.span((long)shapeForm.getXMin(shape), (long)shapeForm.getXMax(shape));
                long y = BitInterval.span((long)shapeForm.getYMin(shape), (long)shapeForm.getYMax(shape));
                return new QTreeShapeCursor<S>(this.tree().cursor(x, y), shapeForm, shape);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<SpatialMap.Entry<Value, S, Value>> iterator() {
        int retries = 0;
        while (true) {
            try {
                return new QTreeEntryCursor<S>(this.tree().cursor(), this.shapeForm);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Value> keyIterator() {
        int retries = 0;
        while (true) {
            try {
                return Cursor.keys(this.tree().cursor());
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Value> valueIterator() {
        int retries = 0;
        while (true) {
            try {
                return new QTreeValueCursor(this.tree().cursor());
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Value> depthValueIterator(int maxDepth) {
        int retries = 0;
        while (true) {
            try {
                return new QTreeValueCursor(this.tree().depthCursor(maxDepth));
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    protected void didFail(StoreException error) {
        System.err.println(error.getMessage());
        error.printStackTrace();
        this.clear();
    }

    public void loadAsync(Cont<QTreeMap<S>> cont) {
        try {
            Cont andThen = Conts.constant(cont, (Object)this);
            this.tree().loadAsync((Cont<Tree>)andThen);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    public QTreeMap<S> load() throws InterruptedException {
        this.tree().load();
        return this;
    }

    public void commitAsync(Commit commit) {
        try {
            this.trunk.commitAsync(commit);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                commit.trap(cause);
            }
            throw cause;
        }
    }

    public Chunk commit(Commit commit) throws InterruptedException {
        return this.trunk.commit(commit);
    }
}

