/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Database;
import swim.db.STree;
import swim.db.STreeListView;
import swim.db.STreeSubList;
import swim.db.StoreException;
import swim.db.StoreSettings;
import swim.db.Tree;
import swim.db.TreeContext;
import swim.db.TreeDelegate;
import swim.db.Trunk;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.structure.collections.ValueList;
import swim.util.Cursor;
import swim.util.KeyedList;

public class STreeList
implements KeyedList<Value> {
    final Trunk<STree> trunk;

    public STreeList(Trunk<STree> trunk) {
        this.trunk = trunk;
    }

    public final Trunk<STree> trunk() {
        return this.trunk;
    }

    public final StoreSettings settings() {
        return this.trunk.settings();
    }

    public final Database database() {
        return this.trunk.database;
    }

    public final Value name() {
        return this.trunk.name;
    }

    public final STree tree() {
        return (STree)this.trunk.tree;
    }

    public final TreeDelegate treeDelegate() {
        return this.tree().treeDelegate();
    }

    public void setTreeDelegate(TreeDelegate treeDelegate) {
        this.tree().setTreeDelegate(treeDelegate);
    }

    public boolean isResident() {
        return this.tree().isResident();
    }

    public STreeList isResident(boolean isResident) {
        long newVersion;
        STree newTree;
        STree oldTree;
        do {
            newVersion = this.trunk.version();
        } while ((oldTree = this.tree()) != (newTree = oldTree.isResident(isResident)) && !this.trunk.updateTree(oldTree, newTree, newVersion));
        return this;
    }

    public boolean isTransient() {
        return this.tree().isTransient();
    }

    public STreeList isTransient(boolean isTransient) {
        long newVersion;
        STree newTree;
        STree oldTree;
        do {
            newVersion = this.trunk.version();
        } while ((oldTree = this.tree()) != (newTree = oldTree.isTransient(isTransient)) && !this.trunk.updateTree(oldTree, newTree, newVersion));
        return this;
    }

    public <V> ValueList<V> valueForm(Form<V> valueForm) {
        return new ValueList((List)((Object)this), valueForm);
    }

    public <V> ValueList<V> valueClass(Class<V> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public STreeListView snapshot() {
        return new STreeListView(this.tree());
    }

    public boolean isEmpty() {
        return this.tree().isEmpty();
    }

    public int size() {
        return (int)this.tree().span();
    }

    public long span() {
        return this.tree().span();
    }

    public long treeSize() {
        return this.tree().treeSize();
    }

    public boolean contains(Object value) {
        if (value instanceof Value) {
            return this.contains((Value)value);
        }
        return false;
    }

    private boolean contains(Value value) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().contains(value);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public boolean containsAll(Collection<?> values) {
        for (Object value : values) {
            if (value instanceof Value && this.contains((Value)value)) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object object) {
        int retries = 0;
        while (true) {
            try {
                long k = this.tree().indexOf(object);
                int i = (int)k;
                if ((long)i != k) {
                    throw new IndexOutOfBoundsException("index overflow");
                }
                return i;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public int lastIndexOf(Object object) {
        int retries = 0;
        while (true) {
            try {
                long k = this.tree().lastIndexOf(object);
                int i = (int)k;
                if ((long)i != k) {
                    throw new IndexOutOfBoundsException("index overflow");
                }
                return i;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value get(int index) {
        return this.get(index, null);
    }

    public Value get(int index, Object key) {
        int retries = 0;
        while (true) {
            try {
                STree tree = this.tree();
                if (key != null && (index = (int)tree.lookup(index, key)) < 0) {
                    return Value.absent();
                }
                return tree.get(index);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Map.Entry<Object, Value> getEntry(int index) {
        return this.getEntry(index, null);
    }

    public Map.Entry<Object, Value> getEntry(int index, Object key) {
        int retries = 0;
        while (true) {
            try {
                STree tree = this.tree();
                if (key != null && (index = (int)tree.lookup(index, key)) < 0) {
                    return null;
                }
                return tree.getEntry(index);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value set(int index, Value newValue) {
        return this.set(index, newValue, (Object)null);
    }

    public Value set(int index, Value newValue, Object key) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                STree oldTree = this.tree();
                if (key != null && (index = (int)oldTree.lookup(index, key)) < 0) {
                    throw new NoSuchElementException(key.toString());
                }
                STree newTree = oldTree.updated(index, newValue, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    Slot oldSlot = oldTree.getEntry(index);
                    Value oldKey = oldSlot.key();
                    Value oldValue = oldSlot.value();
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.streeDidUpdate(newTree, oldTree, index, oldKey, newValue, oldValue);
                    treeContext.treeDidChange(newTree, oldTree);
                    return oldValue;
                }
                return Value.absent();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public boolean add(Value newValue) {
        return this.add(newValue, (Object)null);
    }

    public boolean add(Value newValue, Object key) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                Value newKey;
                STree newTree;
                STree oldTree = this.tree();
                if (!this.trunk.updateTree(oldTree, newTree = oldTree.appended(newKey = key instanceof Value ? (Value)key : this.identify(newValue), newValue, newVersion, newPost), newVersion)) continue;
                int index = (int)oldTree.span();
                TreeContext treeContext = newTree.treeContext();
                treeContext.streeDidInsert(newTree, oldTree, index, newKey, newValue);
                treeContext.treeDidChange(newTree, oldTree);
                return true;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public boolean addAll(Collection<? extends Value> newValues) {
        boolean modified = false;
        for (Value value : newValues) {
            this.add(value);
            modified = true;
        }
        return modified;
    }

    public void add(int index, Value newValue) {
        this.add(index, newValue, (Object)null);
    }

    public void add(int index, Value newValue, Object key) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                Value newKey;
                STree newTree;
                STree oldTree = this.tree();
                if (!this.trunk.updateTree(oldTree, newTree = oldTree.inserted(index, newKey = key instanceof Value ? (Value)key : this.identify(newValue), newValue, newVersion, newPost), newVersion)) continue;
                TreeContext treeContext = newTree.treeContext();
                treeContext.streeDidInsert(newTree, oldTree, index, newKey, newValue);
                treeContext.treeDidChange(newTree, oldTree);
                return;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public boolean addAll(int index, Collection<? extends Value> newValues) {
        boolean modified = false;
        for (Value value : newValues) {
            this.add(index, value);
            ++index;
            modified = true;
        }
        return modified;
    }

    public Value remove(int index) {
        return this.remove(index, null);
    }

    public Value remove(int index, Object key) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                STree oldTree = this.tree();
                if (key != null && (index = (int)oldTree.lookup(index, key)) < 0) {
                    return null;
                }
                STree newTree = oldTree.removed(index, newVersion, newPost);
                if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                Slot oldSlot = oldTree.getEntry(index);
                Value oldKey = oldSlot.key();
                Value oldValue = oldSlot.value();
                TreeContext treeContext = newTree.treeContext();
                treeContext.streeDidRemove(newTree, oldTree, index, oldKey, oldValue);
                treeContext.treeDidChange(newTree, oldTree);
                return oldValue;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public boolean remove(Object value) {
        if (value instanceof Value) {
            return this.remove((Value)value);
        }
        return false;
    }

    private boolean remove(Value value) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                STree oldTree = this.tree();
                STree newTree = oldTree.removed(value, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    long index = oldTree.indexOf(value);
                    Slot oldSlot = oldTree.getEntry(index);
                    Value key = oldSlot.key();
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.streeDidRemove(newTree, oldTree, index, key, value);
                    treeContext.treeDidChange(newTree, oldTree);
                    return true;
                }
                return false;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public boolean removeAll(Collection<?> values) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                STree oldTree = this.tree();
                Record removed = null;
                STree newTree = oldTree;
                long n = newTree.span();
                long i = 0L;
                while (i < n) {
                    Slot slot = newTree.getEntry(i);
                    if (values.contains(slot.value())) {
                        newTree = newTree.removed(i, newVersion, newPost);
                        if (removed == null) {
                            removed = Record.create();
                        }
                        removed.add((Item)Record.create((int)2).item(i).item((Item)slot));
                        --n;
                        continue;
                    }
                    ++i;
                }
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    TreeContext treeContext = newTree.treeContext();
                    for (Item entry : removed) {
                        long index = entry.getItem(0).longValue();
                        Slot oldSlot = (Slot)entry.getItem(1);
                        treeContext.streeDidRemove(newTree, oldTree, index, oldSlot.key(), oldSlot.value());
                    }
                    treeContext.treeDidChange(newTree, oldTree);
                    return true;
                }
                return false;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public boolean retainAll(Collection<?> values) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                STree oldTree = this.tree();
                Record removed = null;
                STree newTree = oldTree;
                long n = newTree.span();
                long i = 0L;
                while (i < n) {
                    Slot slot = newTree.getEntry(i);
                    if (!values.contains(slot.value())) {
                        newTree = newTree.removed(i, newVersion, newPost);
                        if (removed == null) {
                            removed = Record.create();
                        }
                        removed.add((Item)Record.create((int)2).item(i).item((Item)slot));
                        --n;
                        continue;
                    }
                    ++i;
                }
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    TreeContext treeContext = newTree.treeContext();
                    for (Item entry : removed) {
                        long index = entry.getItem(0).longValue();
                        Slot oldSlot = (Slot)entry.getItem(1);
                        treeContext.streeDidRemove(newTree, oldTree, index, oldSlot.key(), oldSlot.value());
                    }
                    treeContext.treeDidChange(newTree, oldTree);
                    return true;
                }
                return false;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public void move(int fromIndex, int toIndex) {
        this.move(fromIndex, toIndex, null);
    }

    public void move(int fromIndex, int toIndex, Object key) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                STree oldTree = this.tree();
                if (key != null && (fromIndex = (int)oldTree.lookup(fromIndex, key)) < 0) {
                    throw new NoSuchElementException(key.toString());
                }
                if (fromIndex < 0 || (long)fromIndex >= oldTree.span()) {
                    throw new IndexOutOfBoundsException(Integer.toString(fromIndex));
                }
                if (toIndex < 0 || (long)toIndex >= oldTree.span()) {
                    throw new IndexOutOfBoundsException(Integer.toString(toIndex));
                }
                if (fromIndex == toIndex) continue;
                Slot slot = oldTree.getEntry(fromIndex);
                Value oldKey = slot.key();
                Value oldValue = slot.value();
                STree newTree = oldTree.removed(fromIndex, newVersion, newPost).inserted(toIndex, oldKey, oldValue, newVersion, newPost);
                if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                TreeContext treeContext = newTree.treeContext();
                treeContext.streeDidMove(newTree, oldTree, fromIndex, toIndex, oldKey, oldValue);
                treeContext.treeDidChange(newTree, oldTree);
                return;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public void drop(int lower) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                STree oldTree = this.tree();
                STree newTree = oldTree.drop(lower, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.streeDidDrop(newTree, oldTree, lower);
                    treeContext.treeDidChange(newTree, oldTree);
                    return;
                }
                return;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public void take(int upper) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                STree oldTree = this.tree();
                STree newTree = oldTree.take(upper, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.streeDidTake(newTree, oldTree, upper);
                    treeContext.treeDidChange(newTree, oldTree);
                    return;
                }
                return;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public void clear() {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            try {
                STree oldTree = this.tree();
                STree newTree = oldTree.cleared(newVersion);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.treeDidClear(newTree, oldTree);
                    treeContext.treeDidChange(newTree, oldTree);
                    return;
                }
                return;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Object[] toArray() {
        int retries = 0;
        while (true) {
            try {
                STree tree = this.tree();
                long k = tree.span();
                int n = (int)k;
                if ((long)n != k) {
                    throw new IndexOutOfBoundsException("length overflow");
                }
                Object[] array = new Object[n];
                tree.copyToArray(array, 0);
                return array;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public <T> T[] toArray(T[] array) {
        int retries = 0;
        while (true) {
            try {
                STree tree = this.tree();
                long k = tree.span();
                int n = (int)k;
                if ((long)n != k) {
                    throw new IndexOutOfBoundsException("length overflow");
                }
                if (array.length < n) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), n);
                }
                tree.copyToArray(array, 0);
                if (array.length > n) {
                    array[n] = null;
                }
                return array;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Value> iterator() {
        int retries = 0;
        while (true) {
            try {
                return Cursor.values(this.tree().cursor());
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Value> listIterator() {
        int retries = 0;
        while (true) {
            try {
                return Cursor.values(this.tree().cursor());
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Value> listIterator(int index) {
        int retries = 0;
        while (true) {
            try {
                Cursor<Slot> cursor = this.tree().cursor();
                cursor.skip((long)index);
                return Cursor.values(cursor);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Object> keyIterator() {
        int retries = 0;
        while (true) {
            try {
                return Cursor.keys(this.tree().cursor());
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Map.Entry<Object, Value>> entryIterator() {
        int retries = 0;
        while (true) {
            try {
                return this.tree().cursor();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Value> depthIterator(int maxDepth) {
        int retries = 0;
        while (true) {
            try {
                return Cursor.values(this.tree().depthCursor(maxDepth));
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public List<Value> subList(int fromIndex, int toIndex) {
        int retries = 0;
        while (true) {
            try {
                if (fromIndex > toIndex) {
                    throw new IllegalArgumentException();
                }
                return new STreeSubList(this, fromIndex, toIndex);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    protected Value identify(Value value) {
        return Num.from((long)ThreadLocalRandom.current().nextLong());
    }

    protected void didFail(StoreException error) {
        System.err.println(error.getMessage());
        error.printStackTrace();
        this.clear();
    }

    public void loadAsync(Cont<STreeList> cont) {
        try {
            Cont andThen = Conts.constant(cont, (Object)this);
            this.tree().loadAsync((Cont<Tree>)andThen);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    public STreeList load() throws InterruptedException {
        this.tree().load();
        return this;
    }

    public void commitAsync(Commit commit) {
        try {
            this.trunk.commitAsync(commit);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                commit.trap(cause);
            }
            throw cause;
        }
    }

    public Chunk commit(Commit commit) throws InterruptedException {
        return this.trunk.commit(commit);
    }
}

