/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Conts;
import swim.db.PageContext;
import swim.db.PageRef;
import swim.db.StoreException;
import swim.db.TreeType;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

public class Seed {
    final TreeType treeType;
    final int stem;
    final long created;
    final long updated;
    final Value rootRefValue;

    public Seed(TreeType treeType, int stem, long created, long updated, Value rootRefValue) {
        this.treeType = treeType;
        this.stem = stem;
        this.created = created;
        this.updated = updated;
        this.rootRefValue = rootRefValue.commit();
    }

    public static Seed fromValue(Value value) {
        try {
            String tag = value.tag();
            TreeType treeType = TreeType.fromTag(tag);
            if (treeType == null) {
                return null;
            }
            Value header = value.header(tag);
            int stem = header.get("stem").intValue();
            long created = header.get("created").longValue();
            long updated = header.get("updated").longValue();
            Value rootRefValue = value.get("root");
            return new Seed(treeType, stem, created, updated, rootRefValue);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                Output message = Unicode.stringOutput((String)"Malformed seed: ");
                Recon.write((Item)value, (Output)message);
                throw new StoreException((String)message.bind(), cause);
            }
            throw cause;
        }
    }

    public TreeType treeType() {
        return this.treeType;
    }

    public int stem() {
        return this.stem;
    }

    public long created() {
        return this.created;
    }

    public long updated() {
        return this.updated;
    }

    public Value rootRefValue() {
        return this.rootRefValue;
    }

    public PageRef rootRef(PageContext pageContext) {
        if (this.rootRefValue.isDefined()) {
            return this.treeType.pageRefFromValue(pageContext, this.stem, this.rootRefValue);
        }
        return this.treeType.emptyPageRef(pageContext, this.stem, 0L);
    }

    public Seed committed(long updated, PageRef newRootRef) {
        return new Seed(this.treeType, this.stem, this.created, updated, newRootRef.toValue());
    }

    public Seed uncommitted(PageRef newRootRef) {
        return new Seed(this.treeType, this.stem, this.created, this.updated, newRootRef.toValue());
    }

    public Value toValue() {
        Record header = Record.create((int)3).slot("stem", this.stem).slot("created", this.created).slot("updated", this.updated);
        return Record.create((int)2).attr(this.treeType.tag(), (Value)header).slot("root", this.rootRefValue);
    }
}

