/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.db.StoreSettingsForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.util.Murmur3;

public class StoreSettings
implements Debug {
    private static int hashSeed;
    private static StoreSettings standard;
    private static Form<StoreSettings> form;
    protected final int pageSplitSize;
    protected final int pageCacheSize;
    protected final int autoCommitInterval;
    protected final long autoCommitSize;
    protected final long minCompactSize;
    protected final long maxZoneSize;
    protected final double minZoneFill;
    protected final double minTreeFill;
    protected final int maxRetries;
    protected final int deleteDelay;
    protected final int storeOpenTimeout;
    protected final int storeCloseTimeout;
    protected final int zoneOpenTimeout;
    protected final int zoneCloseTimeout;
    protected final int databaseOpenTimeout;
    protected final int databaseCloseTimeout;
    protected final int databaseCommitTimeout;
    protected final int databaseCompactTimeout;
    protected final int pageLoadTimeout;
    protected final int treeLoadTimeout;

    public StoreSettings(int pageSplitSize, int pageCacheSize, int autoCommitInterval, long autoCommitSize, long minCompactSize, long maxZoneSize, double minZoneFill, double minTreeFill, int maxRetries, int deleteDelay, int storeOpenTimeout, int storeCloseTimeout, int zoneOpenTimeout, int zoneCloseTimeout, int databaseOpenTimeout, int databaseCloseTimeout, int databaseCommitTimeout, int databaseCompactTimeout, int pageLoadTimeout, int treeLoadTimeout) {
        this.pageSplitSize = pageSplitSize;
        this.pageCacheSize = pageCacheSize;
        this.autoCommitInterval = autoCommitInterval;
        this.autoCommitSize = autoCommitSize;
        this.minCompactSize = minCompactSize;
        this.maxZoneSize = maxZoneSize;
        this.minZoneFill = minZoneFill;
        this.minTreeFill = minTreeFill;
        this.maxRetries = maxRetries;
        this.deleteDelay = deleteDelay;
        this.storeOpenTimeout = storeOpenTimeout;
        this.storeCloseTimeout = storeCloseTimeout;
        this.zoneOpenTimeout = zoneOpenTimeout;
        this.zoneCloseTimeout = zoneCloseTimeout;
        this.databaseOpenTimeout = databaseOpenTimeout;
        this.databaseCloseTimeout = databaseCloseTimeout;
        this.databaseCommitTimeout = databaseCommitTimeout;
        this.databaseCompactTimeout = databaseCompactTimeout;
        this.pageLoadTimeout = pageLoadTimeout;
        this.treeLoadTimeout = treeLoadTimeout;
    }

    public static StoreSettings standard() {
        if (standard == null) {
            int treeLoadTimeout;
            int pageLoadTimeout;
            int databaseCompactTimeout;
            int databaseCommitTimeout;
            int databaseCloseTimeout;
            int databaseOpenTimeout;
            int zoneCloseTimeout;
            int zoneOpenTimeout;
            int storeCloseTimeout;
            int storeOpenTimeout;
            int deleteDelay;
            int maxRetries;
            double minTreeFill;
            double minZoneFill;
            long maxZoneSize;
            long minCompactSize;
            long autoCommitSize;
            int autoCommitInterval;
            int pageCacheSize;
            int pageSplitSize;
            try {
                pageSplitSize = Integer.parseInt(System.getProperty("swim.db.page.split.size"));
            }
            catch (NumberFormatException e) {
                pageSplitSize = 16384;
            }
            try {
                pageCacheSize = Integer.parseInt(System.getProperty("swim.db.page.cache.size"));
            }
            catch (NumberFormatException e) {
                pageCacheSize = 4096;
            }
            try {
                autoCommitInterval = Integer.parseInt(System.getProperty("swim.db.auto.commit.interval"));
            }
            catch (NumberFormatException e) {
                autoCommitInterval = 10000;
            }
            try {
                autoCommitSize = Long.parseLong(System.getProperty("swim.db.auto.commit.size"));
            }
            catch (NumberFormatException e) {
                autoCommitSize = 524288L;
            }
            try {
                minCompactSize = Long.parseLong(System.getProperty("swim.db.min.compact.size"));
            }
            catch (NumberFormatException e) {
                minCompactSize = 0x100000L;
            }
            try {
                maxZoneSize = Long.parseLong(System.getProperty("swim.db.max.zone.size"));
            }
            catch (NumberFormatException e) {
                maxZoneSize = 0x20000000L;
            }
            try {
                minZoneFill = Double.parseDouble(System.getProperty("swim.db.min.zone.fill"));
            }
            catch (NullPointerException | NumberFormatException e) {
                minZoneFill = 0.5;
            }
            try {
                minTreeFill = Double.parseDouble(System.getProperty("swim.db.min.tree.fill"));
            }
            catch (NullPointerException | NumberFormatException e) {
                minTreeFill = 0.2;
            }
            try {
                maxRetries = Integer.parseInt(System.getProperty("swim.db.max.retries"));
            }
            catch (NumberFormatException e) {
                maxRetries = 2;
            }
            try {
                deleteDelay = Integer.parseInt(System.getProperty("swim.db.delete.delay"));
            }
            catch (NumberFormatException e) {
                deleteDelay = 45000;
            }
            try {
                storeOpenTimeout = Integer.parseInt(System.getProperty("swim.db.store.open.timeout"));
            }
            catch (NumberFormatException e) {
                storeOpenTimeout = 30000;
            }
            try {
                storeCloseTimeout = Integer.parseInt(System.getProperty("swim.db.store.close.timeout"));
            }
            catch (NumberFormatException e) {
                storeCloseTimeout = 60000;
            }
            try {
                zoneOpenTimeout = Integer.parseInt(System.getProperty("swim.db.zone.open.timeout"));
            }
            catch (NumberFormatException e) {
                zoneOpenTimeout = 30000;
            }
            try {
                zoneCloseTimeout = Integer.parseInt(System.getProperty("swim.db.zone.close.timeout"));
            }
            catch (NumberFormatException e) {
                zoneCloseTimeout = 60000;
            }
            try {
                databaseOpenTimeout = Integer.parseInt(System.getProperty("swim.db.database.open.timeout"));
            }
            catch (NumberFormatException e) {
                databaseOpenTimeout = 30000;
            }
            try {
                databaseCloseTimeout = Integer.parseInt(System.getProperty("swim.db.database.close.timeout"));
            }
            catch (NumberFormatException e) {
                databaseCloseTimeout = 60000;
            }
            try {
                databaseCommitTimeout = Integer.parseInt(System.getProperty("swim.db.database.commit.timeout"));
            }
            catch (NumberFormatException e) {
                databaseCommitTimeout = 60000;
            }
            try {
                databaseCompactTimeout = Integer.parseInt(System.getProperty("swim.db.database.commit.timeout"));
            }
            catch (NumberFormatException e) {
                databaseCompactTimeout = 900000;
            }
            try {
                pageLoadTimeout = Integer.parseInt(System.getProperty("swim.db.page.load.timeout"));
            }
            catch (NumberFormatException e) {
                pageLoadTimeout = 30000;
            }
            try {
                treeLoadTimeout = Integer.parseInt(System.getProperty("swim.db.tree.load.timeout"));
            }
            catch (NumberFormatException e) {
                treeLoadTimeout = 30000;
            }
            standard = new StoreSettings(pageSplitSize, pageCacheSize, autoCommitInterval, autoCommitSize, minCompactSize, maxZoneSize, minZoneFill, minTreeFill, maxRetries, deleteDelay, storeOpenTimeout, storeCloseTimeout, zoneOpenTimeout, zoneCloseTimeout, databaseOpenTimeout, databaseCloseTimeout, databaseCommitTimeout, databaseCompactTimeout, pageLoadTimeout, treeLoadTimeout);
        }
        return standard;
    }

    @Kind
    public static Form<StoreSettings> form() {
        if (form == null) {
            form = new StoreSettingsForm();
        }
        return form;
    }

    public final int pageSplitSize() {
        return this.pageSplitSize;
    }

    public StoreSettings pageSplitSize(int pageSplitSize) {
        return this.copy(pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int pageCacheSize() {
        return this.pageCacheSize;
    }

    public StoreSettings pageCacheSize(int pageCacheSize) {
        return this.copy(this.pageSplitSize, pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int autoCommitInterval() {
        return this.autoCommitInterval;
    }

    public StoreSettings autoCommitInterval(int autoCommitInterval) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final long autoCommitSize() {
        return this.autoCommitSize;
    }

    public StoreSettings autoCommitSize(long autoCommitSize) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final long minCompactSize() {
        return this.minCompactSize;
    }

    public StoreSettings minCompactSize(long minCompactSize) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final long maxZoneSize() {
        return this.maxZoneSize;
    }

    public StoreSettings maxZoneSize(long maxZoneSize) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final double minZoneFill() {
        return this.minZoneFill;
    }

    public StoreSettings minZoneFill(double minZoneFill) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final double minTreeFill() {
        return this.minTreeFill;
    }

    public StoreSettings minTreeFill(double minTreeFill) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int maxRetries() {
        return this.maxRetries;
    }

    public StoreSettings maxRetries(int maxRetries) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int deleteDelay() {
        return this.deleteDelay;
    }

    public StoreSettings deleteDelay(int deleteDelay) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int storeOpenTimeout() {
        return this.storeOpenTimeout;
    }

    public StoreSettings storeOpenTimeout(int storeOpenTimeout) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int storeCloseTimeout() {
        return this.storeCloseTimeout;
    }

    public StoreSettings storeCloseTimeout(int storeCloseTimeout) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int zoneOpenTimeout() {
        return this.zoneOpenTimeout;
    }

    public StoreSettings zoneOpenTimeout(int zoneOpenTimeout) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int zoneCloseTimeout() {
        return this.zoneCloseTimeout;
    }

    public StoreSettings zoneCloseTimeout(int zoneCloseTimeout) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int databaseOpenTimeout() {
        return this.databaseOpenTimeout;
    }

    public StoreSettings databaseOpenTimeout(int databaseOpenTimeout) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int databaseCloseTimeout() {
        return this.databaseCloseTimeout;
    }

    public StoreSettings databaseCloseTimeout(int databaseCloseTimeout) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int databaseCommitTimeout() {
        return this.databaseCommitTimeout;
    }

    public StoreSettings databaseCommitTimeout(int databaseCommitTimeout) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int databaseCompactTimeout() {
        return this.databaseCompactTimeout;
    }

    public StoreSettings databaseCompactTimeout(int databaseCompactTimeout) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, databaseCompactTimeout, this.pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int pageLoadTimeout() {
        return this.pageLoadTimeout;
    }

    public StoreSettings pageLoadTimeout(int pageLoadTimeout) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, pageLoadTimeout, this.treeLoadTimeout);
    }

    public final int treeLoadTimeout() {
        return this.treeLoadTimeout;
    }

    public StoreSettings treeLoadTimeout(int treeLoadTimeout) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.autoCommitInterval, this.autoCommitSize, this.minCompactSize, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay, this.storeOpenTimeout, this.storeCloseTimeout, this.zoneOpenTimeout, this.zoneCloseTimeout, this.databaseOpenTimeout, this.databaseCloseTimeout, this.databaseCommitTimeout, this.databaseCompactTimeout, this.pageLoadTimeout, treeLoadTimeout);
    }

    protected StoreSettings copy(int pageSplitSize, int pageCacheSize, int autoCommitInterval, long autoCommitSize, long minCompactSize, long maxZoneSize, double minZoneFill, double minTreeFill, int maxRetries, int deleteDelay, int storeOpenTimeout, int storeCloseTimeout, int zoneOpenTimeout, int zoneCloseTimeout, int databaseOpenTimeout, int databaseCloseTimeout, int databaseCommitTimeout, int databaseCompactTimeout, int pageLoadTimeout, int treeLoadTimeout) {
        return new StoreSettings(pageSplitSize, pageCacheSize, autoCommitInterval, autoCommitSize, minCompactSize, maxZoneSize, minZoneFill, minTreeFill, maxRetries, deleteDelay, storeOpenTimeout, storeCloseTimeout, zoneOpenTimeout, zoneCloseTimeout, databaseOpenTimeout, databaseCloseTimeout, databaseCommitTimeout, databaseCompactTimeout, pageLoadTimeout, treeLoadTimeout);
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoreSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof StoreSettings) {
            StoreSettings that = (StoreSettings)other;
            return that.canEqual(this) && this.pageSplitSize == that.pageSplitSize && this.pageCacheSize == that.pageCacheSize && this.autoCommitInterval == that.autoCommitInterval && this.autoCommitSize == that.autoCommitSize && this.minCompactSize == that.minCompactSize && this.maxZoneSize == that.maxZoneSize && this.minZoneFill == that.minZoneFill && this.minTreeFill == that.minTreeFill && this.maxRetries == that.maxRetries && this.deleteDelay == that.deleteDelay && this.storeOpenTimeout == that.storeOpenTimeout && this.storeCloseTimeout == that.storeCloseTimeout && this.zoneOpenTimeout == that.zoneOpenTimeout && this.zoneCloseTimeout == that.zoneCloseTimeout && this.databaseOpenTimeout == that.databaseOpenTimeout && this.databaseCloseTimeout == that.databaseCloseTimeout && this.databaseCommitTimeout == that.databaseCommitTimeout && this.databaseCompactTimeout == that.databaseCompactTimeout && this.pageLoadTimeout == that.pageLoadTimeout && this.treeLoadTimeout == that.treeLoadTimeout;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(StoreSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.pageSplitSize), (int)this.pageCacheSize), (int)this.autoCommitInterval), (int)Murmur3.hash((long)this.autoCommitSize)), (int)Murmur3.hash((long)this.minCompactSize)), (int)Murmur3.hash((long)this.maxZoneSize)), (int)Murmur3.hash((double)this.minZoneFill)), (int)Murmur3.hash((double)this.minTreeFill)), (int)this.maxRetries), (int)this.deleteDelay), (int)this.storeOpenTimeout), (int)this.storeCloseTimeout), (int)this.zoneOpenTimeout), (int)this.zoneCloseTimeout), (int)this.databaseOpenTimeout), (int)this.databaseCloseTimeout), (int)this.databaseCommitTimeout), (int)this.databaseCompactTimeout), (int)this.pageLoadTimeout), (int)this.treeLoadTimeout));
    }

    public void debug(Output<?> output) {
        output.write("StoreSettings").write(46).write("standard").write(40).write(41).write(46).write("pageSplitSize").write(40).debug((Object)this.pageSplitSize).write(41).write(46).write("pageCacheSize").write(40).debug((Object)this.pageCacheSize).write(41).write(46).write("autoCommitInterval").write(40).debug((Object)this.autoCommitInterval).write(41).write(46).write("autoCommitSize").write(40).debug((Object)this.autoCommitSize).write(41).write(46).write("minCompactSize").write(40).debug((Object)this.minCompactSize).write(41).write(46).write("maxZoneSize").write(40).debug((Object)this.maxZoneSize).write(41).write(46).write("minZoneFill").write(40).debug((Object)this.minZoneFill).write(41).write(46).write("minTreeFill").write(40).debug((Object)this.minTreeFill).write(41).write(46).write("maxRetries").write(40).debug((Object)this.maxRetries).write(41).write(46).write("deleteDelay").write(40).debug((Object)this.deleteDelay).write(41).write(46).write("storeOpenTimeout").write(40).debug((Object)this.storeOpenTimeout).write(41).write(46).write("storeCloseTimeout").write(40).debug((Object)this.storeCloseTimeout).write(41).write(46).write("zoneOpenTimeout").write(40).debug((Object)this.zoneOpenTimeout).write(41).write(46).write("zoneCloseTimeout").write(40).debug((Object)this.zoneCloseTimeout).write(41).write(46).write("databaseOpenTimeout").write(40).debug((Object)this.databaseOpenTimeout).write(41).write(46).write("databaseCloseTimeout").write(40).debug((Object)this.databaseCloseTimeout).write(41).write(46).write("databaseCommitTimeout").write(40).debug((Object)this.databaseCommitTimeout).write(41).write(46).write("databaseCompactTimeout").write(40).debug((Object)this.databaseCompactTimeout).write(41).write(46).write("pageLoadTimeout").write(40).debug((Object)this.pageLoadTimeout).write(41).write(46).write("treeLoadTimeout").write(40).debug((Object)this.treeLoadTimeout).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

