/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.concurrent.Stage;
import swim.db.BTree;
import swim.db.BTreeDelegate;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Database;
import swim.db.Page;
import swim.db.PageLoader;
import swim.db.QTree;
import swim.db.QTreeDelegate;
import swim.db.STree;
import swim.db.STreeDelegate;
import swim.db.StoreSettings;
import swim.db.Tree;
import swim.db.TreeContext;
import swim.db.TreeDelegate;
import swim.db.UTree;
import swim.db.UTreeDelegate;
import swim.structure.Value;

public class Trunk<T extends Tree>
extends TreeContext {
    static final AtomicReferenceFieldUpdater<Trunk<?>, Tree> TREE = AtomicReferenceFieldUpdater.newUpdater(Trunk.class, Tree.class, "tree");
    final Database database;
    final Value name;
    volatile T tree;
    TreeDelegate treeDelegate;

    public Trunk(Database database, Value name, T tree) {
        this.database = database;
        this.name = name;
        this.tree = tree;
    }

    @Override
    public final StoreSettings settings() {
        return this.database.settings();
    }

    public final Database database() {
        return this.database;
    }

    public final long version() {
        return this.database.version;
    }

    public final int post() {
        return this.database.post;
    }

    public final Value name() {
        return this.name;
    }

    public final T tree() {
        return this.tree;
    }

    public boolean updateTree(T oldTree, T newTree, long newVersion) {
        if (this.database.version == newVersion && TREE.compareAndSet(this, (Tree)oldTree, (Tree)newTree)) {
            this.database.databaseDidUpdateTrunk(this, (Tree)newTree, (Tree)oldTree, newVersion);
            return this.database.version == newVersion;
        }
        return false;
    }

    public void commitAsync(Commit commit) {
        this.database.commitAsync(commit);
    }

    public Chunk commit(Commit commit) throws InterruptedException {
        return this.database.commit(commit);
    }

    @Override
    public TreeDelegate treeDelegate() {
        return this.treeDelegate;
    }

    @Override
    public void setTreeDelegate(TreeDelegate treeDelegate) {
        this.treeDelegate = treeDelegate;
    }

    @Override
    public Stage stage() {
        return this.database.stage();
    }

    @Override
    public boolean pageShouldSplit(Page page) {
        return this.database.store.pageShouldSplit(this.database, page);
    }

    @Override
    public boolean pageShouldMerge(Page page) {
        return this.database.store.pageShouldMerge(this.database, page);
    }

    @Override
    public PageLoader openPageLoader(boolean isResident) {
        return this.database.store.openPageLoader(this.treeDelegate, isResident);
    }

    @Override
    public void hitPage(Page page) {
        this.database.store.hitPage(this.database, page);
    }

    @Override
    public void treeDidChange(Tree newTree, Tree oldTree) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate != null) {
            treeDelegate.treeDidChange(newTree, oldTree);
        }
        this.database.store.treeDidChange(this.database, newTree, oldTree);
    }

    @Override
    public void treeDidCommit(Tree newTree, Tree oldTree) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate != null) {
            treeDelegate.treeDidCommit(newTree, oldTree);
        }
    }

    @Override
    public void treeDidClear(Tree newTree, Tree oldTree) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate != null) {
            treeDelegate.treeDidClear(newTree, oldTree);
        }
    }

    @Override
    public void btreeDidUpdate(BTree newTree, BTree oldTree, Value key, Value newValue, Value oldValue) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof BTreeDelegate) {
            ((BTreeDelegate)treeDelegate).btreeDidUpdate(newTree, oldTree, key, newValue, oldValue);
        }
    }

    @Override
    public void btreeDidRemove(BTree newTree, BTree oldTree, Value key, Value oldValue) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof BTreeDelegate) {
            ((BTreeDelegate)treeDelegate).btreeDidRemove(newTree, oldTree, key, oldValue);
        }
    }

    @Override
    public void btreeDidDrop(BTree newTree, BTree oldTree, long lower) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof BTreeDelegate) {
            ((BTreeDelegate)treeDelegate).btreeDidDrop(newTree, oldTree, lower);
        }
    }

    @Override
    public void btreeDidTake(BTree newTree, BTree oldTree, long upper) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof BTreeDelegate) {
            ((BTreeDelegate)treeDelegate).btreeDidTake(newTree, oldTree, upper);
        }
    }

    @Override
    public void qtreeDidUpdate(QTree newTree, QTree oldTree, Value key, long x, long y, Value newValue, Value oldValue) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof QTreeDelegate) {
            ((QTreeDelegate)treeDelegate).qtreeDidUpdate(newTree, oldTree, key, x, y, newValue, oldValue);
        }
    }

    @Override
    public void qtreeDidMove(QTree newTree, QTree oldTree, Value key, long newX, long newY, Value newValue, long oldX, long oldY, Value oldValue) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof QTreeDelegate) {
            ((QTreeDelegate)treeDelegate).qtreeDidMove(newTree, oldTree, key, newX, newY, newValue, oldX, oldY, oldValue);
        }
    }

    @Override
    public void qtreeDidRemove(QTree newTree, QTree oldTree, Value key, long x, long y, Value oldValue) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof QTreeDelegate) {
            ((QTreeDelegate)treeDelegate).qtreeDidRemove(newTree, oldTree, key, x, y, oldValue);
        }
    }

    @Override
    public void streeDidUpdate(STree newTree, STree oldTree, long index, Value id, Value newValue, Value oldValue) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof STreeDelegate) {
            ((STreeDelegate)treeDelegate).streeDidUpdate(newTree, oldTree, index, id, newValue, oldValue);
        }
    }

    @Override
    public void streeDidInsert(STree newTree, STree oldTree, long index, Value id, Value newValue) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof STreeDelegate) {
            ((STreeDelegate)treeDelegate).streeDidInsert(newTree, oldTree, index, id, newValue);
        }
    }

    @Override
    public void streeDidRemove(STree newTree, STree oldTree, long index, Value id, Value oldValue) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof STreeDelegate) {
            ((STreeDelegate)treeDelegate).streeDidRemove(newTree, oldTree, index, id, oldValue);
        }
    }

    @Override
    public void streeDidDrop(STree newTree, STree oldTree, long lower) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof STreeDelegate) {
            ((STreeDelegate)treeDelegate).streeDidDrop(newTree, oldTree, lower);
        }
    }

    @Override
    public void streeDidTake(STree newTree, STree oldTree, long upper) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof STreeDelegate) {
            ((STreeDelegate)treeDelegate).streeDidTake(newTree, oldTree, upper);
        }
    }

    @Override
    public void utreeDidUpdate(UTree newTree, UTree oldTree, Value newValue, Value oldValue) {
        TreeDelegate treeDelegate = this.treeDelegate;
        if (treeDelegate instanceof UTreeDelegate) {
            ((UTreeDelegate)treeDelegate).utreeDidUpdate(newTree, oldTree, newValue, oldValue);
        }
    }
}

