/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.Map;
import java.util.NoSuchElementException;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.OrderedMapCursor;

final class BTreeLeafCursor
implements OrderedMapCursor<Value, Value> {
    final Slot[] array;
    int index;
    int limit;

    BTreeLeafCursor(Slot[] array, int index, int limit) {
        this.array = array;
        this.index = index;
        this.limit = limit;
    }

    public boolean isEmpty() {
        return this.index >= this.limit;
    }

    public Map.Entry<Value, Value> head() {
        if (this.index < this.limit) {
            return this.array[this.index];
        }
        throw new NoSuchElementException();
    }

    public void step() {
        if (this.index >= this.limit) {
            throw new UnsupportedOperationException();
        }
        this.index = 1;
    }

    public void skip(long count) {
        this.index = (int)Math.max(0L, Math.min((long)this.index + count, (long)this.limit));
    }

    public boolean hasNext() {
        return this.index < this.limit;
    }

    public long nextIndexLong() {
        return this.index;
    }

    public int nextIndex() {
        return this.index;
    }

    public Value nextKey() {
        return this.array[this.index].key();
    }

    public Map.Entry<Value, Value> next() {
        int index = this.index;
        if (index < this.limit) {
            this.index = index + 1;
            return this.array[index];
        }
        this.index = this.limit;
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public long previousIndexLong() {
        return this.index - 1;
    }

    public int previousIndex() {
        return this.index - 1;
    }

    public Value previousKey() {
        return this.array[this.index - 1].key();
    }

    public Map.Entry<Value, Value> previous() {
        int index = this.index - 1;
        if (index >= 0) {
            this.index = index;
            return this.array[index];
        }
        this.index = 0;
        throw new NoSuchElementException();
    }
}

