/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.Comparator;
import java.util.Map;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.BTree;
import swim.db.BTreeMapView;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Database;
import swim.db.StoreException;
import swim.db.StoreSettings;
import swim.db.Tree;
import swim.db.TreeContext;
import swim.db.TreeDelegate;
import swim.db.Trunk;
import swim.structure.Form;
import swim.structure.Slot;
import swim.structure.Value;
import swim.structure.collections.ValueMap;
import swim.util.CombinerFunction;
import swim.util.Cursor;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;
import swim.util.ReducedMap;

public class BTreeMap
implements OrderedMap<Value, Value>,
ReducedMap<Value, Value, Value> {
    final Trunk<BTree> trunk;

    public BTreeMap(Trunk<BTree> trunk) {
        this.trunk = trunk;
    }

    public final Trunk<BTree> trunk() {
        return this.trunk;
    }

    public final StoreSettings settings() {
        return this.trunk.settings();
    }

    public final Database database() {
        return this.trunk.database;
    }

    public final Value name() {
        return this.trunk.name;
    }

    public final BTree tree() {
        return (BTree)this.trunk.tree;
    }

    public final TreeDelegate treeDelegate() {
        return this.tree().treeDelegate();
    }

    public void setTreeDelegate(TreeDelegate treeDelegate) {
        this.tree().setTreeDelegate(treeDelegate);
    }

    public boolean isResident() {
        return this.tree().isResident();
    }

    public BTreeMap isResident(boolean isResident) {
        long newVersion;
        BTree newTree;
        BTree oldTree;
        do {
            newVersion = this.trunk.version();
        } while ((oldTree = this.tree()) != (newTree = oldTree.isResident(isResident)) && !this.trunk.updateTree(oldTree, newTree, newVersion));
        return this;
    }

    public boolean isTransient() {
        return this.tree().isTransient();
    }

    public BTreeMap isTransient(boolean isTransient) {
        long newVersion;
        BTree newTree;
        BTree oldTree;
        do {
            newVersion = this.trunk.version();
        } while ((oldTree = this.tree()) != (newTree = oldTree.isTransient(isTransient)) && !this.trunk.updateTree(oldTree, newTree, newVersion));
        return this;
    }

    public <K> ValueMap<K, Value> keyForm(Form<K> keyForm) {
        return new ValueMap((Map)((Object)this), keyForm, Form.forValue());
    }

    public <K> ValueMap<K, Value> keyClass(Class<K> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public <V> ValueMap<Value, V> valueForm(Form<V> valueForm) {
        return new ValueMap((Map)((Object)this), Form.forValue(), valueForm);
    }

    public <V> ValueMap<Value, V> valueClass(Class<V> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public BTreeMapView snapshot() {
        return new BTreeMapView(this.tree());
    }

    public boolean isEmpty() {
        return this.tree().isEmpty();
    }

    public int size() {
        return (int)this.tree().span();
    }

    public long span() {
        return this.tree().span();
    }

    public long treeSize() {
        return this.tree().treeSize();
    }

    public boolean containsKey(Object key) {
        if (key instanceof Value) {
            return this.containsKey((Value)key);
        }
        return false;
    }

    private boolean containsKey(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().containsKey(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public boolean containsValue(Object value) {
        if (value instanceof Value) {
            return this.containsValue((Value)value);
        }
        return false;
    }

    private boolean containsValue(Value value) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().containsValue(value);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public int indexOf(Object key) {
        if (key instanceof Value) {
            return (int)this.indexOf((Value)key);
        }
        throw new IllegalArgumentException(key.toString());
    }

    private long indexOf(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().indexOf(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value get(Object key) {
        if (key instanceof Value) {
            return this.get((Value)key);
        }
        return Value.absent();
    }

    private Value get(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().get(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Slot getEntry(Object key) {
        if (key instanceof Value) {
            return this.getEntry((Value)key);
        }
        return null;
    }

    private Slot getEntry(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().getEntry(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Slot getIndex(int index) {
        return this.getIndex((long)index);
    }

    public Slot getIndex(long index) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().getIndex(index);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Slot firstEntry() {
        int retries = 0;
        while (true) {
            try {
                return this.tree().firstEntry();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value firstKey() {
        int retries = 0;
        while (true) {
            try {
                return this.tree().firstKey();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value firstValue() {
        int retries = 0;
        while (true) {
            try {
                return this.tree().firstValue();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Slot lastEntry() {
        int retries = 0;
        while (true) {
            try {
                return this.tree().lastEntry();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value lastKey() {
        int retries = 0;
        while (true) {
            try {
                return this.tree().lastKey();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value lastValue() {
        int retries = 0;
        while (true) {
            try {
                return this.tree().lastValue();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Slot nextEntry(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().nextEntry(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value nextKey(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().nextKey(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value nextValue(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().nextValue(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Slot previousEntry(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().previousEntry(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value previousKey(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().previousKey(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value previousValue(Value key) {
        int retries = 0;
        while (true) {
            try {
                return this.tree().previousValue(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value put(Value key, Value newValue) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                BTree oldTree = this.tree();
                BTree newTree = oldTree.updated(key, newValue, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    Value oldValue = oldTree.get(key);
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.btreeDidUpdate(newTree, oldTree, key, newValue, oldValue);
                    treeContext.treeDidChange(newTree, oldTree);
                    return oldValue;
                }
                return oldTree.get(key);
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public void putAll(Map<? extends Value, ? extends Value> map) {
        for (Map.Entry<? extends Value, ? extends Value> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Value remove(Object key) {
        if (key instanceof Value) {
            return this.remove((Value)key);
        }
        return Value.absent();
    }

    private Value remove(Value key) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                BTree oldTree = this.tree();
                BTree newTree = oldTree.removed(key, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    Value oldValue = oldTree.get(key);
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.btreeDidRemove(newTree, oldTree, key, oldValue);
                    treeContext.treeDidChange(newTree, oldTree);
                    return oldValue;
                }
                return Value.absent();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public void drop(int lower) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                BTree oldTree = this.tree();
                BTree newTree = oldTree.drop(lower, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.btreeDidDrop(newTree, oldTree, lower);
                    treeContext.treeDidChange(newTree, oldTree);
                    return;
                }
                return;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public void take(int upper) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                BTree oldTree = this.tree();
                BTree newTree = oldTree.take(upper, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.btreeDidTake(newTree, oldTree, upper);
                    treeContext.treeDidChange(newTree, oldTree);
                    return;
                }
                return;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public void clear() {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            try {
                BTree oldTree = this.tree();
                BTree newTree = oldTree.cleared(newVersion);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.treeDidClear(newTree, oldTree);
                    treeContext.treeDidChange(newTree, oldTree);
                    return;
                }
                return;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                BTree oldTree = this.tree();
                BTree newTree = oldTree.reduced(identity, accumulator, combiner, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.treeDidChange(newTree, oldTree);
                    return newTree.rootRef.fold();
                }
                return newTree.rootRef.fold();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public OrderedMapCursor<Value, Value> iterator() {
        int retries = 0;
        while (true) {
            try {
                return this.tree().cursor();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Value> keyIterator() {
        int retries = 0;
        while (true) {
            try {
                return Cursor.keys(this.tree().cursor());
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Value> valueIterator() {
        int retries = 0;
        while (true) {
            try {
                return Cursor.values(this.tree().cursor());
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Cursor<Value> depthValueIterator(int maxDepth) {
        int retries = 0;
        while (true) {
            try {
                return Cursor.values(this.tree().depthCursor(maxDepth));
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    protected void didFail(StoreException error) {
        System.err.println(error.getMessage());
        error.printStackTrace();
        this.clear();
    }

    public void loadAsync(Cont<BTreeMap> cont) {
        try {
            Cont andThen = Conts.constant(cont, (Object)this);
            this.tree().loadAsync((Cont<Tree>)andThen);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    public BTreeMap load() throws InterruptedException {
        this.tree().load();
        return this;
    }

    public void commitAsync(Commit commit) {
        try {
            this.trunk.commitAsync(commit);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                commit.trap(cause);
            }
            throw cause;
        }
    }

    public Chunk commit(Commit commit) throws InterruptedException {
        return this.trunk.commit(commit);
    }

    public Comparator<? super Value> comparator() {
        return null;
    }
}

