/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.Database;
import swim.db.Tree;

final class DatabaseOpen
implements Cont<Tree> {
    final Database database;
    final Cont<Database> andThen;

    DatabaseOpen(Database database, Cont<Database> andThen) {
        this.database = database;
        this.andThen = andThen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Tree tree) {
        try {
            this.database.databaseDidOpen();
            Database.STATUS.set(this.database, 2);
            this.andThen.bind((Object)this.database);
            Database database = this.database;
            synchronized (database) {
                this.database.notifyAll();
            }
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                this.trap(cause);
            }
            throw cause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trap(Throwable error) {
        try {
            Database.STATUS.set(this.database, 4);
            this.andThen.trap(error);
        }
        finally {
            Database database = this.database;
            synchronized (database) {
                this.database.notifyAll();
            }
        }
    }
}

