/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.File;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.concurrent.AbstractTask;
import swim.concurrent.Conts;
import swim.db.Compact;
import swim.db.Database;
import swim.db.FileStore;
import swim.db.StoreException;

final class FileStoreCompactor
extends AbstractTask {
    static final AtomicReferenceFieldUpdater<FileStoreCompactor, Compact> COMPACT = AtomicReferenceFieldUpdater.newUpdater(FileStoreCompactor.class, Compact.class, "compact");
    final FileStore store;
    volatile Compact compact;

    FileStoreCompactor(FileStore store) {
        this.store = store;
    }

    void compactAsync(Compact compact) {
        block5: {
            int newStatus;
            int oldStatus;
            Compact newCompact;
            Compact oldCompact;
            if ((this.store.status & 2) == 0) {
                try {
                    this.store.open();
                }
                catch (InterruptedException cause) {
                    throw new StoreException(cause);
                }
            }
            while (!COMPACT.compareAndSet(this, oldCompact, newCompact = (oldCompact = this.compact) != null ? oldCompact.merged(compact) : compact)) {
            }
            if (oldCompact != null) break block5;
            while (!FileStore.STATUS.compareAndSet(this.store, oldStatus = this.store.status, newStatus = oldStatus | 8)) {
            }
            this.cue();
        }
    }

    public boolean taskWillBlock() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask() {
        block25: {
            FileStore store = this.store;
            Database database = null;
            try {
                database = store.openDatabase();
                Compact compact = COMPACT.getAndSet(this, null);
                if (compact == null) {
                    return;
                }
                if (!(compact = database.databaseWillCompact(compact)).isShifted() && store.zoneFiles().size() == 1) {
                    compact = compact.isShifted(true);
                }
                database.commit(compact.commit());
                if (compact.isShifted()) {
                    compact = compact.isShifted(false);
                }
                int post = store.zone.id;
                TreeMap<Integer, File> zoneFiles = store.zoneFiles();
                if (zoneFiles.containsKey(post)) {
                    zoneFiles.remove(post);
                    if (!zoneFiles.isEmpty() && zoneFiles.firstKey() < post) {
                        int oldestZone;
                        Database.POST.set(database, post);
                        database.evacuate(post);
                        database.commit(compact.commit());
                        int deleteDelay = compact.deleteDelay;
                        if (deleteDelay > 0) {
                            Thread.sleep(deleteDelay);
                        }
                        while (!zoneFiles.isEmpty() && (oldestZone = zoneFiles.firstKey().intValue()) < post) {
                            boolean deleted = zoneFiles.get(oldestZone).delete();
                            zoneFiles.remove(oldestZone);
                            store.closeZone(oldestZone);
                            if (!deleted) continue;
                            store.context.databaseDidDeleteZone(store, database, oldestZone);
                        }
                    }
                }
                database.databaseDidCompact(compact);
                compact.bind(store);
            }
            catch (InterruptedException cause) {
                try {
                    if (database != null) {
                        database.databaseCompactDidFail(cause);
                    }
                }
                finally {
                    this.compact.trap(cause);
                }
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    try {
                        if (database != null) {
                            database.databaseCompactDidFail(cause);
                        }
                        break block25;
                    }
                    finally {
                        this.compact.trap(cause);
                    }
                }
                throw cause;
            }
            finally {
                int newStatus;
                int oldStatus;
                while (!FileStore.STATUS.compareAndSet(store, oldStatus = this.store.status, newStatus = oldStatus & 0xFFFFFFF7)) {
                }
            }
        }
    }
}

