/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageRef;
import swim.db.PageType;
import swim.structure.Value;
import swim.util.Cursor;

public abstract class Page {
    public boolean isBTreePage() {
        return false;
    }

    public boolean isQTreePage() {
        return false;
    }

    public boolean isSTreePage() {
        return false;
    }

    public boolean isUTreePage() {
        return false;
    }

    public boolean isNode() {
        return false;
    }

    public boolean isLeaf() {
        return false;
    }

    public abstract PageRef pageRef();

    public PageContext pageContext() {
        return this.pageRef().pageContext();
    }

    public abstract PageType pageType();

    public abstract long version();

    public int stem() {
        return this.pageRef().stem();
    }

    public int post() {
        return this.pageRef().post();
    }

    public int zone() {
        return this.pageRef().zone();
    }

    public long base() {
        return this.pageRef().base();
    }

    public long span() {
        return this.pageRef().span();
    }

    public Value fold() {
        return this.pageRef().fold();
    }

    public abstract boolean isEmpty();

    public abstract int arity();

    public abstract int childCount();

    public abstract PageRef getChildRef(int var1);

    public abstract Page getChild(int var1);

    public int pageSize() {
        return this.pageRef().pageSize();
    }

    public int diffSize() {
        return this.pageRef().diffSize();
    }

    public long treeSize() {
        return this.pageRef().treeSize();
    }

    public abstract Value toHeader();

    public abstract Value toValue();

    public abstract Page evacuated(int var1, long var2);

    public abstract Page committed(int var1, long var2, long var4);

    public abstract Page uncommitted(long var1);

    public abstract void writePage(Output<?> var1);

    public abstract void writeDiff(Output<?> var1);

    public abstract void loadTreeAsync(PageLoader var1, Cont<Page> var2);

    public abstract void soften(long var1);

    public abstract Cursor<? extends Object> cursor();

    public void printTree() {
        System.out.println(this.pageRef());
        this.printTree(0);
    }

    void printTree(int indent) {
        for (int j = 0; j < indent; ++j) {
            System.out.print(' ');
        }
        System.out.println(this);
        int n = this.childCount();
        for (int i = 0; i < n; ++i) {
            this.getChildRef(i).page().printTree(indent + 2);
        }
    }

    public String toDebugString() {
        return this.pageRef().toDebugString();
    }

    static final class LoadSubtree
    implements Cont<Page> {
        final PageLoader pageLoader;
        final Page page;
        final int index;
        final Cont<Page> andThen;

        LoadSubtree(PageLoader pageLoader, Page page, int index, Cont<Page> andThen) {
            this.pageLoader = pageLoader;
            this.page = page;
            this.index = index;
            this.andThen = andThen;
        }

        public void bind(Page previous) {
            try {
                int i = this.index;
                int n = this.page.childCount();
                if (i >= n) {
                    this.andThen.bind((Object)this.page);
                } else {
                    LoadSubtree next = new LoadSubtree(this.pageLoader, this.page, i + 1, this.andThen);
                    this.page.getChildRef(i).loadTreeAsync(this.pageLoader, (Cont<Page>)next);
                }
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    this.trap(cause);
                }
                throw cause;
            }
        }

        public void trap(Throwable cause) {
            this.andThen.trap(cause);
        }
    }
}

