/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageType;
import swim.db.STreeLeaf;
import swim.db.STreeNodeDeltaCursor;
import swim.db.STreeNodeDepthCursor;
import swim.db.STreePage;
import swim.db.STreePageRef;
import swim.db.StoreException;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.CombinerFunction;
import swim.util.Cursor;

public final class STreeNode
extends STreePage {
    static final STreePageRef[] EMPTY_CHILD_REFS = new STreePageRef[0];
    static final long[] EMPTY_KNOT_INDEXES = new long[0];
    final STreePageRef pageRef;
    final long version;
    final STreePageRef[] childRefs;
    final long[] knotIndexes;

    protected STreeNode(STreePageRef pageRef, long version, STreePageRef[] childRefs, long[] knotIndexes) {
        this.pageRef = pageRef;
        this.version = version;
        this.childRefs = childRefs;
        this.knotIndexes = knotIndexes;
    }

    public static STreeNode create(PageContext context, int stem, long version, int post, int zone, long base, long span, Value fold, STreePageRef[] childRefs, long[] knotIndexes) {
        STreePageRef pageRef = new STreePageRef(context, PageType.NODE, stem, post, zone, base, span, fold);
        STreeNode page = new STreeNode(pageRef, version, childRefs, knotIndexes);
        pageRef.page = page;
        return page;
    }

    public static STreeNode create(PageContext context, int stem, long version, int zone, long base, long span, Value fold, STreePageRef[] childRefs, long[] knotIndexes) {
        int post = zone;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            int childPost = childRefs[i].post;
            if (childPost == 0) continue;
            post = post == 0 ? childPost : Math.min(post, childPost);
        }
        return STreeNode.create(context, stem, version, post, zone, base, span, fold, childRefs, knotIndexes);
    }

    public static STreeNode create(PageContext context, int stem, long version, long span, Value fold, STreePageRef[] childRefs, long[] knotIndexes) {
        return STreeNode.create(context, stem, version, 0, 0L, span, fold, childRefs, knotIndexes);
    }

    public static STreeNode create(PageContext context, int stem, long version, Value fold, STreePageRef[] childRefs) {
        int n = childRefs.length - 1;
        long[] knotIndexes = new long[n];
        int post = 0;
        long span = 0L;
        for (int i = 0; i < n; ++i) {
            STreePageRef childRef = childRefs[i];
            int childPost = childRef.post;
            if (childPost != 0) {
                post = post == 0 ? childPost : Math.min(post, childPost);
            }
            knotIndexes[i] = span += childRef.span;
        }
        return STreeNode.create(context, stem, version, post, 0, 0L, span += childRefs[n].span, fold, childRefs, knotIndexes);
    }

    public static STreeNode fromValue(STreePageRef pageRef, Value value) {
        Throwable cause = null;
        try {
            Value header = value.header("snode");
            long version = header.get("v").longValue();
            Record tail = value.tail();
            int n = tail.size() >>> 1;
            STreePageRef[] childRefs = new STreePageRef[n + 1];
            long[] knotIndexes = new long[n];
            childRefs[0] = STreePageRef.fromValue(pageRef.context, pageRef.stem, tail.get(0).toValue());
            for (int i = 1; i <= n; ++i) {
                knotIndexes[i - 1] = tail.get(2 * i - 1).header("knot").get("i").longValue();
                childRefs[i] = STreePageRef.fromValue(pageRef.context, pageRef.stem, tail.get(2 * i).toValue());
            }
            return new STreeNode(pageRef, version, childRefs, knotIndexes);
        }
        catch (Throwable error) {
            if (!Conts.isNonFatal((Throwable)error)) {
                throw error;
            }
            cause = error;
            Output message = Unicode.stringOutput((String)"Malformed snode: ");
            Recon.write((Item)value, (Output)message);
            throw new StoreException((String)message.bind(), cause);
        }
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public STreePageRef pageRef() {
        return this.pageRef;
    }

    @Override
    public PageType pageType() {
        return PageType.NODE;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public boolean isEmpty() {
        return this.pageRef.span == 0L;
    }

    @Override
    public int arity() {
        return this.knotIndexes.length;
    }

    @Override
    public int childCount() {
        return this.childRefs.length;
    }

    @Override
    public STreePageRef getChildRef(int index) {
        return this.childRefs[index];
    }

    @Override
    public STreePage getChild(int index) {
        try {
            return this.childRefs[index].page();
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public boolean contains(Value value) {
        try {
            STreePageRef[] childRefs = this.childRefs;
            int n = childRefs.length;
            for (int i = 0; i < n; ++i) {
                if (!childRefs[i].page().contains(value)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public Slot getSlot(int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value get(long index) {
        int x = this.lookup(index);
        x = x >= 0 ? ++x : -(x + 1);
        long i = x == 0 ? index : index - this.knotIndexes[x - 1];
        return this.getChild(x).get(i);
    }

    @Override
    public Slot getEntry(long index) {
        int x = this.lookup(index);
        x = x >= 0 ? ++x : -(x + 1);
        long i = x == 0 ? index : index - this.knotIndexes[x - 1];
        return this.getChild(x).getEntry(i);
    }

    int lookup(long index) {
        long[] knotIndexes = this.knotIndexes;
        int low = 0;
        int high = knotIndexes.length - 1;
        while (low <= high) {
            int x = low + high >>> 1;
            int order = Long.compare(index, knotIndexes[x]);
            if (order > 0) {
                low = x + 1;
                continue;
            }
            if (order < 0) {
                high = x - 1;
                continue;
            }
            return x;
        }
        return -(low + 1);
    }

    @Override
    public STreePage updated(long index, Value newValue, long newVersion) {
        int x = this.lookup(index);
        x = x >= 0 ? ++x : -(x + 1);
        long i = x == 0 ? index : index - this.knotIndexes[x - 1];
        STreePage oldPage = this.getChild(x);
        STreePage newPage = oldPage.updated(i, newValue, newVersion);
        if (oldPage != newPage) {
            if (oldPage.span() != newPage.span() && this.pageRef.context.pageShouldSplit(newPage)) {
                return this.updatedPageSplit(x, newPage, oldPage, newVersion);
            }
            return this.updatedPage(x, newPage, oldPage, newVersion);
        }
        return this;
    }

    STreeNode updatedPage(int x, STreePage newPage, STreePage oldPage, long newVersion) {
        long newSpan;
        long[] newKnotIndexes;
        STreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        STreePageRef[] newChildRefs = new STreePageRef[n];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, n);
        newChildRefs[x] = newPage.pageRef();
        long[] oldKnotIndexes = this.knotIndexes;
        if (n - 1 > 0) {
            newKnotIndexes = new long[n - 1];
            if (x > 0) {
                System.arraycopy(oldKnotIndexes, 0, newKnotIndexes, 0, x);
                newSpan = oldKnotIndexes[x - 1];
            } else {
                newSpan = 0L;
            }
            for (int i = x; i < n - 1; ++i) {
                newKnotIndexes[i] = newSpan += newChildRefs[i].span;
            }
            newSpan += newChildRefs[n - 1].span;
        } else {
            newKnotIndexes = EMPTY_KNOT_INDEXES;
            newSpan = 0L;
        }
        return STreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotIndexes);
    }

    STreeNode updatedPageSplit(int x, STreePage newPage, STreePage oldPage, long newVersion) {
        STreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length + 1;
        STreePageRef[] newChildRefs = new STreePageRef[n];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, x);
        int y = newPage.arity() >>> 1;
        STreePage newLeftPage = newPage.splitLeft(y, newVersion);
        STreePage newRightPage = newPage.splitRight(y, newVersion);
        newChildRefs[x] = newLeftPage.pageRef();
        newChildRefs[x + 1] = newRightPage.pageRef();
        System.arraycopy(oldChildRefs, x + 1, newChildRefs, x + 2, n - (x + 2));
        return STreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newChildRefs);
    }

    STreeNode updatedPageMerge(int x, STreeNode newPage, STreePage oldPage, long newVersion) {
        STreePageRef[] oldChildRefs = this.childRefs;
        STreePageRef[] mergePages = newPage.childRefs;
        int k = mergePages.length;
        int n = oldChildRefs.length + (k - 1);
        STreePageRef[] newChildRefs = new STreePageRef[n];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, x);
        System.arraycopy(mergePages, 0, newChildRefs, x, k);
        System.arraycopy(oldChildRefs, x + 1, newChildRefs, x + k, n - (x + k));
        return STreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newChildRefs);
    }

    @Override
    public STreePage inserted(long index, Value key, Value newValue, long newVersion) {
        int x = this.lookup(index);
        x = x >= 0 ? ++x : -(x + 1);
        long i = x == 0 ? index : index - this.knotIndexes[x - 1];
        STreePage oldPage = this.getChild(x);
        STreePage newPage = oldPage.inserted(i, key, newValue, newVersion);
        if (oldPage != newPage) {
            if (this.pageRef.context.pageShouldSplit(newPage)) {
                return this.updatedPageSplit(x, newPage, oldPage, newVersion);
            }
            return this.updatedPage(x, newPage, oldPage, newVersion);
        }
        return this;
    }

    @Override
    public STreePage removed(long index, long newVersion) {
        int x = this.lookup(index);
        x = x >= 0 ? ++x : -(x + 1);
        long i = x == 0 ? index : index - this.knotIndexes[x - 1];
        STreePage oldPage = this.getChild(x);
        STreePage newPage = oldPage.removed(i, newVersion);
        if (oldPage != newPage) {
            return this.replacedPage(x, newPage, oldPage, newVersion);
        }
        return this;
    }

    STreePage replacedPage(int x, STreePage newPage, STreePage oldPage, long newVersion) {
        if (!newPage.isEmpty()) {
            if (newPage.isNode() && this.pageRef.context.pageShouldMerge(newPage)) {
                return this.updatedPageMerge(x, (STreeNode)newPage, oldPage, newVersion);
            }
            return this.updatedPage(x, newPage, oldPage, newVersion);
        }
        if (this.childRefs.length > 2) {
            return this.removedPage(x, newPage, oldPage, newVersion);
        }
        if (this.childRefs.length > 1) {
            if (x == 0) {
                return this.getChild(1);
            }
            return this.getChild(0);
        }
        return STreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
    }

    STreeNode removedPage(int x, STreePage newPage, STreePage oldPage, long newVersion) {
        long newSpan;
        STreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length - 1;
        STreePageRef[] newChildRefs = new STreePageRef[n];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, x);
        System.arraycopy(oldChildRefs, x + 1, newChildRefs, x, n - x);
        long[] oldKnotIndexes = this.knotIndexes;
        long[] newKnotIndexes = new long[n - 1];
        if (x > 0) {
            System.arraycopy(oldKnotIndexes, 0, newKnotIndexes, 0, x);
            newSpan = oldKnotIndexes[x - 1];
        } else {
            newSpan = 0L;
        }
        for (int i = x; i < n - 1; ++i) {
            newKnotIndexes[i] = newSpan += newChildRefs[i].span;
        }
        return STreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan += newChildRefs[n - 1].span, Value.absent(), newChildRefs, newKnotIndexes);
    }

    @Override
    public STreePage removed(Object object, long newVersion) {
        try {
            STreePageRef[] childRefs = this.childRefs;
            int n = childRefs.length;
            for (int x = 0; x < n; ++x) {
                STreePage newPage;
                STreePage oldPage = childRefs[x].page();
                if (oldPage == (newPage = oldPage.removed(object, newVersion))) continue;
                return this.replacedPage(x, newPage, oldPage, newVersion);
            }
            return this;
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public STreePage drop(long lower, long newVersion) {
        try {
            if (lower > 0L) {
                if (lower < this.span()) {
                    int x = this.lookup(lower);
                    x = x >= 0 ? ++x : -(x + 1);
                    long i = x == 0 ? lower : lower - this.knotIndexes[x - 1];
                    STreePageRef[] oldChildRefs = this.childRefs;
                    int k = oldChildRefs.length;
                    int n = k - x;
                    if (n > 1) {
                        STreeNode newNode;
                        if (x > 0) {
                            STreePageRef[] newChildRefs = new STreePageRef[n];
                            System.arraycopy(oldChildRefs, x, newChildRefs, 0, n);
                            newNode = STreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newChildRefs);
                        } else {
                            newNode = this;
                        }
                        if (i > 0L) {
                            STreePage oldPage = oldChildRefs[x].page();
                            STreePage newPage = oldPage.drop(i, newVersion);
                            return newNode.replacedPage(0, newPage, oldPage, newVersion);
                        }
                        return newNode;
                    }
                    return oldChildRefs[x].page().drop(i, newVersion);
                }
                return STreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
            }
            return this;
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public STreePage take(long upper, long newVersion) {
        try {
            if (upper < this.span()) {
                if (upper > 0L) {
                    int n;
                    int x = this.lookup(upper);
                    x = x >= 0 ? ++x : -(x + 1);
                    long i = x == 0 ? upper : upper - this.knotIndexes[x - 1];
                    STreePageRef[] oldChildRefs = this.childRefs;
                    int k = oldChildRefs.length;
                    int n2 = n = i == 0L ? x : x + 1;
                    if (n > 1) {
                        STreeNode newNode;
                        if (x < k) {
                            STreePageRef[] newChildRefs = new STreePageRef[n];
                            System.arraycopy(oldChildRefs, 0, newChildRefs, 0, n);
                            long[] newKnotIndexes = new long[n - 1];
                            System.arraycopy(this.knotIndexes, 0, newKnotIndexes, 0, n - 1);
                            long newSpan = newKnotIndexes[n - 2] + newChildRefs[n - 1].span;
                            newNode = STreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotIndexes);
                        } else {
                            newNode = this;
                        }
                        if (i > 0L) {
                            STreePage oldPage = oldChildRefs[x].page();
                            STreePage newPage = oldPage.take(i, newVersion);
                            return newNode.replacedPage(x, newPage, oldPage, newVersion);
                        }
                        return newNode;
                    }
                    if (i > 0L) {
                        return oldChildRefs[0].page().take(i, newVersion);
                    }
                    return oldChildRefs[0].page();
                }
                return STreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
            }
            return this;
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public long indexOf(Object object) {
        try {
            STreePageRef[] childRefs = this.childRefs;
            long k = 0L;
            int n = childRefs.length;
            for (int x = 0; x < n; ++x) {
                STreePage page = childRefs[x].page();
                long i = page.indexOf(object);
                if (i >= 0L) {
                    return k + i;
                }
                k += page.span();
            }
            return -1L;
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public long lastIndexOf(Object object) {
        try {
            STreePageRef[] childRefs = this.childRefs;
            long k = this.span();
            for (int x = childRefs.length - 1; x >= 0; --x) {
                STreePage page = childRefs[x].page();
                long i = page.lastIndexOf(object);
                k -= page.span();
                if (i < 0L) continue;
                return k + 1L;
            }
            return -1L;
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public void copyToArray(Object[] array, int offset) {
        try {
            STreePageRef[] childRefs = this.childRefs;
            int n = childRefs.length;
            for (int x = 0; x < n; ++x) {
                STreePage page = childRefs[x].page();
                page.copyToArray(array, offset);
                offset = (int)((long)offset + page.span());
            }
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public STreeNode balanced(long newVersion) {
        if (this.childRefs.length > 1 && this.pageRef.context.pageShouldSplit(this)) {
            int x = this.knotIndexes.length >>> 1;
            return this.split(x, newVersion);
        }
        return this;
    }

    @Override
    public STreeNode split(int x, long newVersion) {
        STreePageRef[] newChildRefs = new STreePageRef[2];
        STreeNode newLeftPage = this.splitLeft(x, newVersion);
        STreeNode newRightPage = this.splitRight(x, newVersion);
        newChildRefs[0] = newLeftPage.pageRef();
        newChildRefs[1] = newRightPage.pageRef();
        long[] newKnotIndexes = new long[]{newLeftPage.span()};
        return STreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span, Value.absent(), newChildRefs, newKnotIndexes);
    }

    @Override
    public STreeNode splitLeft(int x, long newVersion) {
        STreePageRef[] oldChildRefs = this.childRefs;
        STreePageRef[] newChildRefs = new STreePageRef[x + 1];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, x + 1);
        long[] oldKnotIndexes = this.knotIndexes;
        long[] newKnotIndexes = new long[x];
        System.arraycopy(oldKnotIndexes, 0, newKnotIndexes, 0, x);
        long newSpan = 0L;
        for (int i = 0; i <= x; ++i) {
            newSpan += newChildRefs[i].span;
        }
        return STreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotIndexes);
    }

    @Override
    public STreeNode splitRight(int x, long newVersion) {
        long newSpan;
        STreePageRef[] oldChildRefs = this.childRefs;
        int y = oldChildRefs.length - (x + 1);
        STreePageRef[] newChildRefs = new STreePageRef[y];
        System.arraycopy(oldChildRefs, x + 1, newChildRefs, 0, y);
        long[] newKnotIndexes = new long[y - 1];
        if (y > 0) {
            newSpan = newChildRefs[0].span;
            for (int i = 1; i < y; ++i) {
                newKnotIndexes[i - 1] = newSpan;
                newSpan += newChildRefs[i].span;
            }
        } else {
            newSpan = 0L;
        }
        return STreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotIndexes);
    }

    @Override
    public int pageSize() {
        return this.pageRef.pageSize();
    }

    @Override
    public int diffSize() {
        return this.pageRef.diffSize();
    }

    @Override
    public long treeSize() {
        return this.pageRef.treeSize();
    }

    @Override
    void memoizeSize(STreePageRef pageRef) {
        int pageSize = 12;
        pageSize += Recon.sizeOf((Item)Num.from((int)this.pageRef.stem));
        pageSize += 3;
        pageSize += Recon.sizeOf((Item)Num.from((long)this.version));
        ++pageSize;
        STreePageRef[] childRefs = this.childRefs;
        int n = childRefs.length;
        long[] knotIndexes = this.knotIndexes;
        int diffSize = 0;
        long treeSize = 0L;
        if (n > 0) {
            ++pageSize;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    long index = knotIndexes[i - 1];
                    pageSize += 9;
                    pageSize += Recon.sizeOf((Item)Num.from((long)index));
                    pageSize += 2;
                }
                STreePageRef childRef = childRefs[i];
                pageSize += childRef.pageRefSize();
                if (this.version == childRef.softVersion()) {
                    diffSize += childRef.diffSize();
                }
                treeSize += childRef.treeSize();
            }
            ++pageSize;
            ++pageSize;
        }
        pageRef.pageSize = pageSize;
        pageRef.diffSize = diffSize += pageSize;
        pageRef.treeSize = treeSize += (long)pageSize;
    }

    @Override
    public Value toHeader() {
        Record header = Record.create((int)2).slot("stem", this.pageRef.stem).slot("v", this.version);
        return Record.create((int)1).attr("snode", (Value)header);
    }

    @Override
    public Value toValue() {
        Record record = (Record)this.toHeader();
        STreePageRef[] childRefs = this.childRefs;
        long[] knotIndexes = this.knotIndexes;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                record.add((Item)Record.create((int)1).attr("knot", (Value)Record.create((int)1).slot("i", knotIndexes[i - 1])));
            }
            record.add((Item)childRefs[i].toValue());
        }
        return record;
    }

    @Override
    public STreeNode reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner, long newVersion) {
        STreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        STreePageRef[] newChildRefs = new STreePageRef[n];
        for (int i = 0; i < n; ++i) {
            newChildRefs[i] = oldChildRefs[i].reduced(identity, accumulator, combiner, newVersion);
        }
        Value fold = newChildRefs[0].fold();
        for (int i = 1; i < n; ++i) {
            fold = (Value)combiner.combine((Object)fold, (Object)newChildRefs[i].fold());
        }
        return STreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span, fold, newChildRefs, this.knotIndexes);
    }

    @Override
    public STreeNode evacuated(int post, long version) {
        int oldPost = this.pageRef.post;
        if (oldPost != 0 && oldPost < post) {
            STreePageRef[] oldChildRefs = this.childRefs;
            int n = oldChildRefs.length;
            STreePageRef[] newChildRefs = new STreePageRef[n];
            for (int i = 0; i < n; ++i) {
                STreePageRef newChildRef;
                STreePageRef oldChildRef = oldChildRefs[i];
                newChildRefs[i] = newChildRef = oldChildRef.evacuated(post, version);
                if (oldChildRef == newChildRef) continue;
                if (++i < n) {
                    System.arraycopy(oldChildRefs, i, newChildRefs, i, n - i);
                }
                return STreeNode.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.span, this.pageRef.fold, newChildRefs, this.knotIndexes);
            }
        }
        return this;
    }

    @Override
    public STreeNode committed(int zone, long base, long version) {
        STreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        STreePageRef[] newChildRefs = new STreePageRef[n];
        long step = base;
        for (int i = 0; i < n; ++i) {
            STreePageRef oldChildRef = oldChildRefs[i];
            if (!oldChildRef.isCommitted()) {
                STreePageRef newChildRef;
                newChildRefs[i] = newChildRef = oldChildRef.committed(zone, step, version);
                step += (long)newChildRef.diffSize();
                continue;
            }
            newChildRefs[i] = oldChildRef;
        }
        return STreeNode.create(this.pageRef.context, this.pageRef.stem, version, zone, step, this.pageRef.span, this.pageRef.fold, newChildRefs, this.knotIndexes);
    }

    @Override
    public STreeNode uncommitted(long version) {
        STreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        STreePageRef[] newChildRefs = new STreePageRef[n];
        for (int i = 0; i < n; ++i) {
            newChildRefs[i] = oldChildRefs[i].uncommitted(version);
        }
        return STreeNode.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.span, this.pageRef.fold, newChildRefs, this.knotIndexes);
    }

    @Override
    public void writePage(Output<?> output) {
        Recon.write((Item)this.toHeader(), output);
        this.writePageContent(output);
        output.write(10);
    }

    void writePageContent(Output<?> output) {
        STreePageRef[] childRefs = this.childRefs;
        int n = childRefs.length;
        long[] knotIndexes = this.knotIndexes;
        if (n > 0) {
            output.write(123);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    output.write(44).write(64).write(107).write(110).write(111).write(116).write(40).write(105).write(58);
                    Recon.write((Item)Num.from((long)knotIndexes[i - 1]), output);
                    output.write(41).write(44);
                }
                childRefs[i].writePageRef(output);
            }
            output.write(125);
        }
    }

    @Override
    public void writeDiff(Output<?> output) {
        for (STreePageRef childRef : this.childRefs) {
            if (this.version != childRef.softVersion()) continue;
            childRef.writeDiff(output);
        }
        this.writePage(output);
    }

    @Override
    public void loadTreeAsync(PageLoader pageLoader, Cont<Page> cont) {
        try {
            STreePageRef[] childRefs = this.childRefs;
            if (childRefs.length > 0) {
                childRefs[0].loadTreeAsync(pageLoader, (Cont<Page>)new Page.LoadSubtree(pageLoader, this, 1, cont));
            } else {
                this.pageRef.context.stage().execute(Conts.async(cont, (Object)this));
            }
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    @Override
    public void soften(long version) {
        STreePageRef[] childRefs = this.childRefs;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            childRefs[i].soften(version);
        }
    }

    @Override
    public Cursor<Slot> cursor() {
        return new STreeNodeDepthCursor(this, Integer.MAX_VALUE);
    }

    @Override
    public Cursor<Slot> depthCursor(int maxDepth) {
        return new STreeNodeDepthCursor(this, maxDepth);
    }

    @Override
    public Cursor<Slot> deltaCursor(long sinceVersion) {
        return new STreeNodeDeltaCursor(this, sinceVersion);
    }

    public String toString() {
        Output output = Unicode.stringOutput((int)(this.pageSize() - 1));
        Recon.write((Item)this.toHeader(), (Output)output);
        this.writePageContent(output);
        return (String)output.bind();
    }
}

