/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.concurrent.Cont;
import swim.concurrent.Stage;
import swim.concurrent.Sync;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Compact;
import swim.db.Database;
import swim.db.Page;
import swim.db.PageLoader;
import swim.db.StoreContext;
import swim.db.StoreSettings;
import swim.db.Tree;
import swim.db.TreeDelegate;
import swim.db.Zone;

public abstract class Store {
    public abstract StoreContext storeContext();

    public StoreSettings settings() {
        return this.storeContext().settings;
    }

    public abstract Database database();

    public abstract Stage stage();

    public abstract long size();

    public abstract boolean isCommitting();

    public abstract boolean isCompacting();

    public abstract void openAsync(Cont<Store> var1);

    public abstract Store open() throws InterruptedException;

    public abstract void closeAsync(Cont<Store> var1);

    public abstract void close() throws InterruptedException;

    public abstract Zone zone();

    public abstract Zone zone(int var1);

    public abstract void openZoneAsync(int var1, Cont<Zone> var2);

    public abstract Zone openZone(int var1) throws InterruptedException;

    public abstract void openDatabaseAsync(Cont<Database> var1);

    public Database openDatabase() throws InterruptedException {
        Sync syncDatabase = new Sync();
        this.openDatabaseAsync((Cont<Database>)syncDatabase);
        return (Database)syncDatabase.await((long)this.settings().databaseOpenTimeout);
    }

    public abstract PageLoader openPageLoader(TreeDelegate var1, boolean var2);

    public abstract void commitAsync(Commit var1);

    public abstract void compactAsync(Compact var1);

    public abstract Zone shiftZone();

    boolean pageShouldSplit(Database database, Page page) {
        return this.storeContext().pageShouldSplit(this, database, page);
    }

    boolean pageShouldMerge(Database database, Page page) {
        return this.storeContext().pageShouldMerge(this, database, page);
    }

    void hitPage(Database database, Page page) {
        this.storeContext().hitPage(this, database, page);
    }

    void treeDidOpen(Database database, Tree tree) {
        this.storeContext().treeDidOpen(this, database, tree);
    }

    void treeDidClose(Database database, Tree tree) {
        this.storeContext().treeDidClose(this, database, tree);
    }

    void treeDidChange(Database database, Tree newTree, Tree oldTree) {
        this.storeContext().treeDidChange(this, database, newTree, oldTree);
    }

    void databaseWillOpen(Database database) {
        this.storeContext().databaseWillOpen(this, database);
    }

    void databaseDidOpen(Database database) {
        this.storeContext().databaseDidOpen(this, database);
    }

    void databaseWillClose(Database database) {
        this.storeContext().databaseWillClose(this, database);
    }

    void databaseDidClose(Database database) {
        this.storeContext().databaseDidClose(this, database);
    }

    Commit databaseWillCommit(Database database, Commit commit) {
        return this.storeContext().databaseWillCommit(this, database, commit);
    }

    void databaseDidCommit(Database database, Chunk chunk) {
        this.storeContext().databaseDidCommit(this, database, chunk);
    }

    void databaseCommitDidFail(Database database, Throwable error) {
        this.storeContext().databaseCommitDidFail(this, database, error);
    }

    Compact databaseWillCompact(Database database, Compact compact) {
        return this.storeContext().databaseWillCompact(this, database, compact);
    }

    void databaseDidCompact(Database database, Compact compact) {
        this.storeContext().databaseDidCompact(this, database, compact);
    }

    void databaseCompactDidFail(Database database, Throwable error) {
        this.storeContext().databaseCompactDidFail(this, database, error);
    }
}

