/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.concurrent.Cont;
import swim.db.PageRef;
import swim.db.Seed;
import swim.db.StoreSettings;
import swim.db.TreeContext;
import swim.db.TreeDelegate;
import swim.db.TreeType;
import swim.structure.Value;
import swim.util.Cursor;

public abstract class Tree {
    public abstract TreeType treeType();

    public abstract TreeContext treeContext();

    public StoreSettings settings() {
        return this.treeContext().settings();
    }

    public TreeDelegate treeDelegate() {
        return this.treeContext().treeDelegate();
    }

    public void setTreeDelegate(TreeDelegate treeDelegate) {
        this.treeContext().setTreeDelegate(treeDelegate);
    }

    public abstract PageRef rootRef();

    public abstract Seed seed();

    public int stem() {
        return this.seed().stem;
    }

    public int post() {
        return this.rootRef().post();
    }

    public long span() {
        return this.rootRef().span();
    }

    public Value fold() {
        return this.rootRef().fold();
    }

    public abstract boolean isResident();

    public abstract Tree isResident(boolean var1);

    public abstract boolean isTransient();

    public abstract Tree isTransient(boolean var1);

    public abstract boolean isEmpty();

    public abstract int diffSize(long var1);

    public abstract long treeSize();

    public abstract Tree evacuated(int var1, long var2);

    public abstract Tree committed(int var1, long var2, long var4, long var6);

    public abstract Tree uncommitted(long var1);

    public abstract void writeDiff(Output<?> var1, long var2);

    public abstract void loadAsync(Cont<Tree> var1);

    public abstract Tree load() throws InterruptedException;

    public abstract void soften(long var1);

    public abstract Cursor<? extends Object> cursor();
}

