/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.codec.Binary;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.concurrent.Sync;
import swim.db.BTree;
import swim.db.BTreeMap;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Compact;
import swim.db.DatabaseAwait;
import swim.db.DatabaseClose;
import swim.db.DatabaseDelegate;
import swim.db.DatabaseEvacuate;
import swim.db.DatabaseLeafIterator;
import swim.db.DatabaseOpen;
import swim.db.DatabaseTreeIterator;
import swim.db.Germ;
import swim.db.MetaLeaf;
import swim.db.MetaTree;
import swim.db.QTree;
import swim.db.QTreeMap;
import swim.db.STree;
import swim.db.STreeList;
import swim.db.Seed;
import swim.db.Store;
import swim.db.StoreException;
import swim.db.StoreSettings;
import swim.db.Tree;
import swim.db.TreeType;
import swim.db.Trunk;
import swim.db.UTree;
import swim.db.UTreeValue;
import swim.math.Z2Form;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.Cursor;
import swim.util.OrderedMapCursor;

public class Database {
    final Store store;
    volatile DatabaseDelegate delegate;
    volatile Germ germ;
    volatile int stem;
    volatile int post;
    volatile long version;
    volatile long diffSize;
    volatile long treeSize;
    final Trunk<BTree> metaTrunk;
    final Trunk<BTree> seedTrunk;
    volatile HashTrieMap<Value, WeakReference<Trunk<Tree>>> trunks;
    volatile HashTrieMap<Value, Trunk<Tree>> sprouts;
    volatile int status;
    static final int OPENING = 1;
    static final int OPENED = 2;
    static final int FAILED = 4;
    static final AtomicIntegerFieldUpdater<Database> STEM = AtomicIntegerFieldUpdater.newUpdater(Database.class, "stem");
    static final AtomicLongFieldUpdater<Database> VERSION = AtomicLongFieldUpdater.newUpdater(Database.class, "version");
    static final AtomicIntegerFieldUpdater<Database> POST = AtomicIntegerFieldUpdater.newUpdater(Database.class, "post");
    static final AtomicLongFieldUpdater<Database> DIFF_SIZE = AtomicLongFieldUpdater.newUpdater(Database.class, "diffSize");
    static final AtomicLongFieldUpdater<Database> TREE_SIZE = AtomicLongFieldUpdater.newUpdater(Database.class, "treeSize");
    static final AtomicIntegerFieldUpdater<Database> STATUS = AtomicIntegerFieldUpdater.newUpdater(Database.class, "status");
    static final AtomicReferenceFieldUpdater<Database, HashTrieMap<Value, WeakReference<Trunk<Tree>>>> TRUNKS = AtomicReferenceFieldUpdater.newUpdater(Database.class, HashTrieMap.class, "trunks");
    static final AtomicReferenceFieldUpdater<Database, HashTrieMap<Value, Trunk<Tree>>> SPROUTS = AtomicReferenceFieldUpdater.newUpdater(Database.class, HashTrieMap.class, "sprouts");

    Database(Store store, int stem, long version) {
        this.store = store;
        this.stem = stem;
        this.version = version;
        this.metaTrunk = new Trunk<Object>(this, (Value)Record.create((int)1).attr("meta"), null);
        this.metaTrunk.tree = new BTree(this.metaTrunk, 0, version, true, false);
        this.seedTrunk = new Trunk<Object>(this, (Value)Record.create((int)1).attr("seed"), null);
        this.seedTrunk.tree = new BTree(this.seedTrunk, 1, version, true, false);
        this.trunks = HashTrieMap.empty();
        this.sprouts = HashTrieMap.empty();
        long time = System.currentTimeMillis();
        this.germ = new Germ(stem, version, time, time, ((BTree)this.seedTrunk.tree).rootRef().toValue());
    }

    Database(Store store, Germ germ) {
        this.store = store;
        this.germ = germ;
        this.stem = germ.stem();
        this.version = germ.version() + 1L;
        this.metaTrunk = new Trunk<Object>(this, (Value)Record.create((int)1).attr("meta"), null);
        this.metaTrunk.tree = new BTree(this.metaTrunk, 0, this.version, true, false);
        this.seedTrunk = new Trunk<Object>(this, (Value)Record.create((int)1).attr("seed"), null);
        this.seedTrunk.tree = new BTree(this.seedTrunk, germ.seed(), true, false);
        this.trunks = HashTrieMap.empty();
        this.sprouts = HashTrieMap.empty();
    }

    Database(Store store) {
        this(store, 10, 1L);
    }

    public Store store() {
        return this.store;
    }

    public StoreSettings settings() {
        return this.store.settings();
    }

    public Stage stage() {
        return this.store.stage();
    }

    public DatabaseDelegate databaseDelegate() {
        return this.delegate;
    }

    public void setDatabaseDelegate(DatabaseDelegate delegate) {
        this.delegate = delegate;
    }

    public Germ germ() {
        return this.germ;
    }

    public int stem() {
        return this.stem;
    }

    public int post() {
        return this.post;
    }

    public long version() {
        return this.version;
    }

    public long diffSize() {
        return this.diffSize;
    }

    public long treeSize() {
        return this.treeSize;
    }

    public long treeCount() {
        return ((BTree)this.seedTrunk.tree).span();
    }

    public int trunkCount() {
        return this.trunks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openAsync(Cont<Database> cont) {
        block16: {
            try {
                int oldStatus;
                while (((oldStatus = this.status) & 7) == 0) {
                    int newStatus = oldStatus | 1;
                    if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                    try {
                        this.store.databaseWillOpen(this);
                        ((BTree)this.seedTrunk.tree).loadAsync(new DatabaseOpen(this, cont));
                        break block16;
                    }
                    catch (Throwable cause) {
                        STATUS.set(this, 4);
                        Database database = this;
                        synchronized (database) {
                            this.notifyAll();
                        }
                        throw cause;
                    }
                }
                if ((oldStatus & 1) != 0) {
                    Database database = this;
                    synchronized (database) {
                        ForkJoinPool.managedBlock(new DatabaseAwait(this));
                    }
                }
                if ((this.status & 2) != 0) {
                    cont.bind((Object)this);
                } else {
                    cont.trap((Throwable)new StoreException("failed to open database"));
                }
            }
            catch (InterruptedException cause) {
                cont.trap((Throwable)cause);
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    cont.trap(cause);
                }
                throw cause;
            }
        }
    }

    public Database open() throws InterruptedException {
        Sync syncDatabase = new Sync();
        this.openAsync((Cont<Database>)syncDatabase);
        return (Database)syncDatabase.await((long)this.settings().databaseOpenTimeout);
    }

    public void closeAsync(Cont<Database> cont) {
        try {
            this.commitAsync(Commit.closed().andThen(new DatabaseClose(this, cont)));
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    public void close() throws InterruptedException {
        Sync syncDatabase = new Sync();
        this.closeAsync((Cont<Database>)syncDatabase);
        syncDatabase.await((long)this.settings().databaseCloseTimeout);
    }

    public <T extends Tree> Trunk<T> openTrunk(Value name, TreeType treeType, boolean isResident, boolean isTransient) {
        Trunk oldTrunk;
        block6: {
            HashTrieMap newTrunks;
            HashTrieMap<Value, WeakReference<Trunk<Tree>>> oldTrunks;
            Trunk<Object> newTrunk = null;
            WeakReference<Trunk<Object>> newTrunkRef = null;
            boolean created = false;
            do {
                WeakReference oldTrunkRef;
                Trunk trunk = oldTrunk = (oldTrunkRef = (WeakReference)(oldTrunks = this.trunks).get((Object)name)) != null ? (Trunk)oldTrunkRef.get() : null;
                if (oldTrunk != null) break block6;
                if (newTrunk != null) continue;
                Seed seed = Seed.fromValue(((BTree)this.seedTrunk.tree).get(name));
                newTrunk = new Trunk<Object>(this, name, null);
                if (seed != null) {
                    newTrunk.tree = seed.treeType().treeFromSeed(newTrunk, seed, isResident, isTransient);
                } else if (treeType != null) {
                    int stem = STEM.getAndIncrement(this);
                    newTrunk.tree = treeType.emptyTree(newTrunk, stem, this.version, isResident, isTransient);
                    created = true;
                } else {
                    return null;
                }
                newTrunkRef = new WeakReference<Trunk<Object>>(newTrunk);
            } while (!TRUNKS.compareAndSet(this, oldTrunks, (HashTrieMap<Value, WeakReference<Trunk<Tree>>>)(newTrunks = oldTrunks.updated((Object)name, newTrunkRef))));
            if (created) {
                this.databaseDidCreateTrunk(newTrunk);
            }
            this.databaseDidOpenTrunk(newTrunk);
            return newTrunk;
        }
        return oldTrunk;
    }

    public Trunk<BTree> openBTreeTrunk(Value name, boolean isResident, boolean isTransient) {
        return this.openTrunk(name, TreeType.BTREE, isResident, isTransient);
    }

    public BTreeMap openBTreeMap(Value name, boolean isResident, boolean isTransient) {
        return new BTreeMap(this.openBTreeTrunk(name, isResident, isTransient));
    }

    public BTreeMap openBTreeMap(Value name) {
        return new BTreeMap(this.openBTreeTrunk(name, false, false));
    }

    public BTreeMap openBTreeMap(String name) {
        return new BTreeMap(this.openBTreeTrunk((Value)Text.from((String)name), false, false));
    }

    public Trunk<QTree> openQTreeTrunk(Value name, boolean isResident, boolean isTransient) {
        return this.openTrunk(name, TreeType.QTREE, isResident, isTransient);
    }

    public <S> QTreeMap<S> openQTreeMap(Value name, Z2Form<S> shapeForm, boolean isResident, boolean isTransient) {
        return new QTreeMap<S>(this.openQTreeTrunk(name, isResident, isTransient), shapeForm);
    }

    public <S> QTreeMap<S> openQTreeMap(Value name, Z2Form<S> shapeForm) {
        return new QTreeMap<S>(this.openQTreeTrunk(name, false, false), shapeForm);
    }

    public <S> QTreeMap<S> openQTreeMap(String name, Z2Form<S> shapeForm) {
        return new QTreeMap<S>(this.openQTreeTrunk((Value)Text.from((String)name), false, false), shapeForm);
    }

    public Trunk<STree> openSTreeTrunk(Value name, boolean isResident, boolean isTransient) {
        return this.openTrunk(name, TreeType.STREE, isResident, isTransient);
    }

    public STreeList openSTreeList(Value name, boolean isResident, boolean isTransient) {
        return new STreeList(this.openSTreeTrunk(name, isResident, isTransient));
    }

    public STreeList openSTreeList(Value name) {
        return new STreeList(this.openSTreeTrunk(name, false, false));
    }

    public STreeList openSTreeList(String name) {
        return new STreeList(this.openSTreeTrunk((Value)Text.from((String)name), false, false));
    }

    private Trunk<UTree> openUTreeTrunk(Value name, boolean isResident, boolean isTransient) {
        return this.openTrunk(name, TreeType.UTREE, isResident, isTransient);
    }

    public UTreeValue openUTreeValue(Value name) {
        return new UTreeValue(this.openUTreeTrunk(name, false, false));
    }

    public UTreeValue openUTreeValue(String name) {
        return new UTreeValue(this.openUTreeTrunk((Value)Text.from((String)name), false, false));
    }

    public void closeTrunk(Value name) {
        HashTrieMap newTrunks;
        HashTrieMap<Value, WeakReference<Trunk<Tree>>> oldTrunks;
        while ((oldTrunks = this.trunks) != (newTrunks = oldTrunks.removed((Object)name))) {
            if (!TRUNKS.compareAndSet(this, oldTrunks, (HashTrieMap<Value, WeakReference<Trunk<Tree>>>)newTrunks)) continue;
            WeakReference oldTrunkRef = (WeakReference)oldTrunks.get((Object)name);
            Trunk oldTrunk = (Trunk)oldTrunkRef.get();
            if (oldTrunk == null) break;
            this.databaseDidCloseTrunk(oldTrunk);
            break;
        }
    }

    public void removeTree(Value name) {
        int newPost;
        long newVersion;
        BTree newSeedTree;
        BTree oldSeedTree;
        HashTrieMap newSprouts;
        HashTrieMap<Value, Trunk<Tree>> oldSprouts;
        this.closeTrunk(name);
        while ((oldSprouts = this.sprouts) != (newSprouts = oldSprouts.removed((Object)name)) && !SPROUTS.compareAndSet(this, oldSprouts, (HashTrieMap<Value, Trunk<Tree>>)newSprouts)) {
        }
        while ((oldSeedTree = (BTree)this.seedTrunk.tree) != (newSeedTree = oldSeedTree.removed(name, newVersion = this.version, newPost = this.post))) {
            if (!Trunk.TREE.compareAndSet(this.seedTrunk, oldSeedTree, newSeedTree)) continue;
            Value seedValue = oldSeedTree.get(name);
            Value sizeValue = seedValue.get("root").head().toValue().get("area");
            long treeSize = sizeValue.longValue(0L);
            TREE_SIZE.addAndGet(this, -treeSize);
            break;
        }
    }

    public void commitAsync(Commit commit) {
        try {
            if (this.diffSize > 0L) {
                this.store.commitAsync(commit);
            } else {
                commit.bind(null);
            }
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                commit.trap(cause);
            }
            throw cause;
        }
    }

    public Chunk commit(Commit commit) throws InterruptedException {
        if (this.diffSize > 0L) {
            Sync syncChunk = new Sync();
            this.commitAsync(commit.andThen((Cont<Chunk>)syncChunk));
            return (Chunk)syncChunk.await((long)this.settings().databaseCommitTimeout);
        }
        return null;
    }

    public void compactAsync(Compact compact) {
        try {
            this.store.compactAsync(compact);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                compact.trap(cause);
            }
            throw cause;
        }
    }

    public Store compact(Compact compact) throws InterruptedException {
        Sync syncStore = new Sync();
        this.compactAsync(compact.andThen((Cont<Store>)syncStore));
        return (Store)syncStore.await((long)this.settings().databaseCompactTimeout);
    }

    public void evacuateAsync(int post, Cont<Database> cont) {
        try {
            this.stage().execute((Runnable)new DatabaseEvacuate(this, this.post, cont));
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    public void evacuate(int post) {
        boolean quiescent;
        block0: do {
            BTree newMetaTree;
            BTree oldMetaTree;
            long version;
            BTree newSeedTree;
            BTree oldSeedTree;
            quiescent = true;
            OrderedMapCursor<Value, Value> seedCursor = ((BTree)this.seedTrunk.tree).cursor();
            block1: while (seedCursor.hasNext()) {
                int newPost;
                long version2;
                Tree newTree;
                Object oldTree;
                Trunk<Tree> trunk;
                Value name = (Value)((Map.Entry)seedCursor.next()).getKey();
                do {
                    version2 = this.version;
                    trunk = this.openTrunk(name, null, false, false);
                    oldTree = trunk.tree;
                    newTree = ((Tree)oldTree).evacuated(post, version2);
                    if (oldTree == newTree) continue block1;
                    newPost = newTree.post();
                } while (!trunk.updateTree((Tree)oldTree, newTree, version2) || newPost == 0 || newPost >= post);
                quiescent = false;
            }
            while ((oldSeedTree = (BTree)this.seedTrunk.tree) != (newSeedTree = oldSeedTree.evacuated(post, version = this.version))) {
                int newPost = newSeedTree.post();
                if (!Trunk.TREE.compareAndSet(this.seedTrunk, oldSeedTree, newSeedTree) || newPost == 0 || newPost >= post) continue;
                quiescent = false;
                break;
            }
            while ((oldMetaTree = (BTree)this.metaTrunk.tree) != (newMetaTree = oldMetaTree.evacuated(post, version = this.version))) {
                int newPost = newMetaTree.post();
                if (!Trunk.TREE.compareAndSet(this.metaTrunk, oldMetaTree, newMetaTree) || newPost == 0 || newPost >= post) continue;
                quiescent = false;
                continue block0;
            }
        } while (!quiescent);
    }

    public void shiftZone() {
        this.store.shiftZone();
    }

    public Chunk commitChunk(Commit commit, int zone, long base) {
        Germ germ;
        BTree metaTree;
        BTree oldMetaTree;
        BTree seedTree;
        BTree oldSeedTree;
        HashTrieMap<Value, Trunk<Tree>> sprouts;
        DIFF_SIZE.set(this, 0L);
        long version = VERSION.getAndIncrement(this);
        long time = System.currentTimeMillis();
        while (!SPROUTS.compareAndSet(this, sprouts = this.sprouts, (HashTrieMap<Value, Trunk<Tree>>)HashTrieMap.empty())) {
        }
        if (sprouts.isEmpty()) {
            return null;
        }
        Builder commitBuilder = FingerTrieSeq.builder();
        long step = base;
        Iterator trunks = sprouts.valueIterator();
        block1: while (trunks.hasNext()) {
            Tree newTree;
            Object oldTree;
            Trunk trunk = (Trunk)trunks.next();
            while ((oldTree = trunk.tree) != (newTree = ((Tree)oldTree).committed(zone, step, version, time))) {
                BTree newSeedTree;
                BTree oldSeedTree2;
                if (!Trunk.TREE.compareAndSet(trunk, (Tree)oldTree, newTree)) continue;
                while (!Trunk.TREE.compareAndSet(this.seedTrunk, oldSeedTree2 = (BTree)this.seedTrunk.tree, newSeedTree = oldSeedTree2.updated(trunk.name, newTree.seed().toValue(), version, this.post))) {
                }
                commitBuilder.add((Object)newTree);
                TREE_SIZE.addAndGet(this, newTree.treeSize() - ((Tree)oldTree).treeSize());
                newTree.treeContext().treeDidCommit(newTree, (Tree)oldTree);
                step += (long)newTree.diffSize(version);
                continue block1;
            }
        }
        while (!Trunk.TREE.compareAndSet(this.seedTrunk, oldSeedTree = (BTree)this.seedTrunk.tree, seedTree = oldSeedTree.committed(zone, step, version, time))) {
        }
        step += (long)seedTree.diffSize(version);
        while (!Trunk.TREE.compareAndSet(this.metaTrunk, oldMetaTree = (BTree)this.metaTrunk.tree, metaTree = oldMetaTree.updated((Value)Text.from((String)"seed"), seedTree.rootRef().toValue(), version, this.post).updated((Value)Text.from((String)"stem"), (Value)Num.from((int)this.stem), version, this.post).updated((Value)Text.from((String)"time"), (Value)Num.from((long)time), version, this.post).committed(zone, step, version, time))) {
        }
        FingerTrieSeq commits = (FingerTrieSeq)commitBuilder.bind();
        int size = (int)((step += (long)metaTree.diffSize(version)) - base);
        OutputBuffer output = Binary.outputBuffer((byte[])new byte[size]);
        Output encoder = Utf8.encodedOutput((Output)output);
        step = base;
        for (Tree tree : commits) {
            tree.writeDiff(encoder, version);
            Database.assertStep(output, base, step += (long)tree.diffSize(version));
        }
        seedTree.writeDiff(encoder, version);
        Database.assertStep(output, base, step += (long)seedTree.diffSize(version));
        metaTree.writeDiff(encoder, version);
        Database.assertStep(output, base, step += (long)metaTree.diffSize(version));
        if (output.index() != size) {
            throw new StoreException();
        }
        this.germ = germ = new Germ(this.stem, version, this.germ.created(), time, seedTree.rootRef().toValue());
        return new Chunk(this, commit, zone, germ, (FingerTrieSeq<Tree>)commits, (ByteBuffer)output.bind());
    }

    private static void assertStep(OutputBuffer<?> output, long base, long step) {
        int skew = output.index() - (int)(step - base);
        if (skew != 0) {
            StoreException error = new StoreException("chunk offset skew: " + skew + "; base: " + base + "; step: " + step);
            if (skew < 0) {
                throw error;
            }
            error.printStackTrace();
        }
    }

    public void uncommit(long version) {
        OrderedMapCursor<Value, Value> seedCursor = ((BTree)this.seedTrunk.tree).cursor();
        while (seedCursor.hasNext()) {
            long newVersion;
            Tree newTree;
            Trunk<Tree> trunk;
            Object oldTree;
            Value name = (Value)((Map.Entry)seedCursor.next()).getKey();
            do {
                newVersion = this.version;
                trunk = this.openTrunk(name, null, false, false);
            } while ((oldTree = trunk.tree) != (newTree = ((Tree)oldTree).uncommitted(version)) && !trunk.updateTree((Tree)oldTree, newTree, newVersion));
        }
    }

    public Iterator<MetaTree> trees() {
        return new DatabaseTreeIterator((Cursor<Map.Entry<Value, Value>>)((BTree)this.seedTrunk.tree).cursor());
    }

    public Iterator<MetaLeaf> leafs() {
        return new DatabaseLeafIterator(this, this.trees());
    }

    void databaseDidOpen() {
        long treeSize = 0L;
        OrderedMapCursor<Value, Value> seedCursor = ((BTree)this.seedTrunk.tree).cursor();
        while (seedCursor.hasNext()) {
            Value seedValue = (Value)((Map.Entry)seedCursor.next()).getValue();
            Value sizeValue = seedValue.get("root").head().toValue().get("area");
            treeSize += sizeValue.longValue(0L);
        }
        TREE_SIZE.set(this, treeSize);
        this.store.databaseDidOpen(this);
    }

    void databaseDidClose() {
        this.store.databaseDidClose(this);
    }

    public void databaseDidCreateTrunk(Trunk<?> trunk) {
        TREE_SIZE.addAndGet(this, ((Tree)trunk.tree).treeSize());
    }

    public void databaseDidOpenTrunk(Trunk<?> trunk) {
        this.store.treeDidOpen(this, (Tree)trunk.tree);
    }

    Commit databaseWillCommit(Commit commit) {
        return this.store.databaseWillCommit(this, commit);
    }

    void databaseDidCommit(Chunk chunk) {
        this.store.databaseDidCommit(this, chunk);
        DatabaseDelegate delegate = this.delegate;
        if (delegate != null) {
            delegate.databaseDidCommit(this, chunk);
        }
    }

    void databaseCommitDidFail(Throwable error) {
        this.store.databaseCommitDidFail(this, error);
    }

    Compact databaseWillCompact(Compact compact) {
        return this.store.databaseWillCompact(this, compact);
    }

    void databaseDidCompact(Compact compact) {
        this.store.databaseDidCompact(this, compact);
        DatabaseDelegate delegate = this.delegate;
        if (delegate != null) {
            delegate.databaseDidCompact(this, compact);
        }
    }

    void databaseCompactDidFail(Throwable error) {
        this.store.databaseCompactDidFail(this, error);
    }

    public void databaseDidUpdateTrunk(Trunk<?> trunk, Tree newTree, Tree oldTree, long newVersion) {
        if (!newTree.isTransient()) {
            HashTrieMap newSprouts;
            HashTrieMap<Value, Trunk<Tree>> oldSprouts;
            while ((oldSprouts = this.sprouts) != (newSprouts = oldSprouts.updated((Object)trunk.name, trunk)) && !SPROUTS.compareAndSet(this, oldSprouts, (HashTrieMap<Value, Trunk<Tree>>)newSprouts)) {
            }
            int deltaSize = newTree.diffSize(newVersion);
            if (!oldTree.isTransient()) {
                deltaSize -= oldTree.diffSize(newVersion);
            }
            DIFF_SIZE.addAndGet(this, deltaSize);
        }
        TREE_SIZE.addAndGet(this, newTree.treeSize() - oldTree.treeSize());
    }

    public void databaseDidCloseTrunk(Trunk<?> trunk) {
        this.store.treeDidClose(this, (Tree)trunk.tree);
    }
}

